/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user or with the express written consent of
 * Sun Microsystems, Inc.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
/*      @(#)rpc_com.h 1.17 91/03/11 SMI      */

/*
 * rpc_com.h, Common definitions for both the server and client side.
 * All for the topmost layer of rpc
 *
 * Copyright (C) 1988, Sun Microsystems, Inc.
 */

#ifndef _RPC_RPCCOM_H
#define _RPC_RPCCOM_H

/*
 * File descriptor to be used on xxx_create calls to get default descriptor
 */
#define	RPC_ANYSOCK	-1
#define RPC_ANYFD	RPC_ANYSOCK	
/*
 * The max size of the transport, if the size cannot be determined
 * by other means.
 */
#define MAXTR_BSIZE 9000

#ifdef __cplusplus
extern "C" u_int _rpc_get_t_size (int, long);
extern "C" u_int _rpc_get_a_size (long);
extern "C" int _rpc_dtbsize ();
extern "C" char *_rpc_gethostname ();
#elif c_plusplus
extern u_int _rpc_get_t_size (int, long);
extern u_int _rpc_get_a_size (long);
extern int _rpc_dtbsize ();
extern char *_rpc_gethostname ();
#elif __STDC__
extern u_int _rpc_get_t_size (int, long);
extern u_int _rpc_get_a_size (long);
extern int _rpc_dtbsize (void);
extern char *_rpc_gethostname (void);
#else
extern u_int _rpc_get_t_size ();
extern u_int _rpc_get_a_size ();
extern int _rpc_dtbsize ();
extern char *_rpc_gethostname ();
#endif

#endif /* _RPC_RPCCOM_H */
