/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user or with the express written consent of
 * Sun Microsystems, Inc.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
#if !defined(lint) && defined(SCCSIDS)
static char sccsid[] = "@(#)key_call.c 1.19 91/03/11 Copyr 1986 Sun Micro";
#endif 

/*
 * key_call.c, Interface to keyserver
 *
 * Copyright (C) 1986, Sun Microsystems, Inc. 
 *
 * setsecretkey(key) - set your secret key
 * encryptsessionkey(agent, deskey) - encrypt a session key to talk to agent
 * decryptsessionkey(agent, deskey) - decrypt ditto
 * gendeskey(deskey) - generate a secure des key
 */

#include <rpc/rpc.h>
#include <rpc/key_prot.h>
#include <stdio.h>
#include <netconfig.h>

#define KEY_TIMEOUT	5	/* per-try timeout in seconds */
#define KEY_NRETRY	12	/* number of retries */

#ifdef DEBUG
#define debug(msg)	(void) fprintf(stderr, "%s\n", msg);
#else
#define debug(msg)
#endif /* DEBUG */

key_setsecret(secretkey)
	char *secretkey;
{
	keystatus       status;

	if (!key_call((u_long) KEY_SET, xdr_keybuf, secretkey,
		      xdr_keystatus, (char *) &status)) {
		return (-1);
	}
	if (status != KEY_SUCCESS) {
		debug("set status is nonzero");
		return (-1);
	}
	return (0);
}

key_encryptsession(remotename, deskey)
	char *remotename;
	des_block *deskey;
{
	cryptkeyarg arg;
	cryptkeyres res;

	arg.remotename = remotename;
	arg.deskey = *deskey;
	if (!key_call((u_long)KEY_ENCRYPT, xdr_cryptkeyarg, (char *)&arg,
			xdr_cryptkeyres, (char *)&res)) {
		return (-1);
	}
	if (res.status != KEY_SUCCESS) {
		debug("encrypt status is nonzero");
		return (-1);
	}
	*deskey = res.cryptkeyres_u.deskey;
	return (0);
}

key_decryptsession(remotename, deskey)
	char *remotename;
	des_block *deskey;
{
	cryptkeyarg arg;
	cryptkeyres res;

	arg.remotename = remotename;
	arg.deskey = *deskey;
	if (!key_call((u_long)KEY_DECRYPT, xdr_cryptkeyarg, (char *)&arg,
			xdr_cryptkeyres, (char *)&res)) {
		return (-1);
	}
	if (res.status != KEY_SUCCESS) {
		debug("decrypt status is nonzero");
		return (-1);
	}
	*deskey = res.cryptkeyres_u.deskey;
	return (0);
}

key_gendes(key)
	des_block *key;
{
	if (!key_call((u_long)KEY_GEN, xdr_void, (char *)NULL,
			xdr_des_block, (char *)key)) {
		return (-1);
	}
	return (0);
}

/*
 * Keep the handle cached.  This call may be made quite often.
 */
static CLIENT *
getkeyserv_handle()
{
	void *localhandle;
   	struct netconfig *nconf;
	struct netconfig *tpconf;
	static CLIENT *clnt;
	struct timeval wait_time;	

#define TOTAL_TIMEOUT   30      /* total timeout talking to keyserver */
#define TOTAL_TRIES     5      /* Number of tries */

	if (clnt)
		return (clnt);
       if (!(localhandle = setnetconfig()))
		return (NULL);
	tpconf = NULL;
        while (nconf = getnetconfig(localhandle)) {
                if (strcmp(nconf->nc_protofmly, NC_LOOPBACK) == 0) {
			if (nconf->nc_semantics == NC_TPI_CLTS) {
			clnt = clnt_tp_create(_rpc_gethostname(),
				 KEY_PROG, KEY_VERS, nconf);
				if (clnt)
					break;
			} else {
				tpconf = nconf;
                }
        }
	}
	if ((clnt == NULL) && (tpconf))
		/* Now, try the connection-oriented loopback transport */
		clnt = clnt_tp_create(_rpc_gethostname(), KEY_PROG,
				KEY_VERS, tpconf);
        endnetconfig(localhandle);

	if (clnt == NULL)
		return (NULL);

	clnt->cl_auth = authsys_create("", geteuid(), 0, 0, NULL);
	if (clnt->cl_auth == NULL) {
		clnt_destroy(clnt);
		clnt = NULL;
		return (NULL);
	}
	wait_time.tv_sec = TOTAL_TIMEOUT/TOTAL_TRIES;
        wait_time.tv_usec = 0;
        (void) clnt_control(clnt, CLSET_RETRY_TIMEOUT, &wait_time);

	return (clnt);
}

/* returns  0 on failure, 1 on success */
static
key_call(proc, xdr_arg, arg, xdr_rslt, rslt)
	u_long proc;
	bool_t (*xdr_arg)();
	char *arg;
	bool_t (*xdr_rslt)();
	char *rslt;
{
	CLIENT *clnt;
	struct timeval wait_time;

	clnt = getkeyserv_handle();
	if (clnt == NULL)
		return (0);

	wait_time.tv_sec = TOTAL_TIMEOUT;
        wait_time.tv_usec = 0;

	if (CLNT_CALL(clnt, proc, xdr_arg, arg, xdr_rslt, rslt,
		wait_time) == RPC_SUCCESS)
		return (1);
	else
		return (0);
}
