/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user or with the express written consent of
 * Sun Microsystems, Inc.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
#if !defined(lint) && defined(SCCSIDS)
static char sccsid[] = "@(#)getdname.c 1.12 91/03/11 Copyr 1989 Sun Micro";
#endif

/*
 * getdname.c
 *	Gets and sets the domain name of the system
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/utsname.h>
#include <sys/systeminfo.h>

#ifdef _NSL_RPC_ABI
/* For internal use only when building the libnsl RPC routines */
#define sysinfo	_abi_sysinfo
#endif

#ifndef SI_SRPC_DOMAIN
#define use_file
#endif

#ifdef use_file
char *DOMAIN = "/etc/domain";
#endif

static char *domainname;
int setdomainname();
extern char *calloc();

#ifdef use_file
static char *
_domainname()
{
	register char *d = domainname;

	if (d == 0) {
		d = (char *)calloc(1, 256);
		domainname = d;
	}
	return (d);
}
#endif

int 
getdomainname(name, namelen)
	char *name;
	int namelen;
{
#ifdef use_file
	char *line = _domainname();
	FILE *domain_fd;

	if (line == NULL)
		return(-1);
	if ((domain_fd = fopen(DOMAIN, "r")) == NULL)
		return (-1);
	
	if (fscanf(domain_fd, "%s", line) == NULL) {
		fclose(domain_fd);
		return (-1);
	}
	fclose(domain_fd);
	(void) strncpy(name, line, namelen);
	return (0);
#else
	int sysinfostatus = sysinfo(SI_SRPC_DOMAIN, name, namelen);

	return ((sysinfostatus < 0) ? -1 : 0);
#endif
}

setdomainname(domain, len)
	char *domain;
	int len;
{
#ifdef use_file
	FILE *domain_fd;

	if ((domain_fd = fopen(DOMAIN, "rw")) == NULL)
		return (-1);
	if (fputs(domain, domain_fd) == NULL)
		return (-1);
	fclose(domain_fd);
	return(0);
#else
	int sysinfostatus;

	sysinfostatus = sysinfo(SI_SET_SRPC_DOMAIN,
					domain, len + 1); /* add null */
	return ((sysinfostatus < 0) ? -1 : 0);
#endif
}
