/*	@(#)udp_tli.h 1.3 91/03/11 SMI	*/

/*
 * Copyright (c) 1988 by Sun Microsystems, Inc.
 */

#ifndef	_UDP_TLI_
#define	_UDP_TLI_

/*
 * Max buffer size for each uio operation in udptli_Ercv()
 */
#define	TT_BUFSIZE	2048

/*
 * Send and Recv size for socket operations
 */
#define	TT_SENDSIZE	24 * 1024
#define TT_RECVSIZE	24 * 1024

#define TTS_DFLT_REUSEADDR	0
#define TTS_DFLT_BROADCAST	0

/*
 * Max number of uio vectors for sosend and soreceive
 */
#define	TT_MAXUIO	10

/*
 * Flag to indicate that only part of the data buffer got sent
 */
#define	TT_INCOMPLETESEND	201

/*
 * Protocol options (socket options) supported by T_OPTMGMT_REQ
 */
struct	tt_soopt {
	int	tts_reuseaddr;	/* reuse a bound address */
	int	tts_broadcast;	/* request permission to broadcast */
	int	tts_sendsize;	/* socket send size */
	int	tts_recvsize;	/* socket recv size */
};

#define	TTS_BUFSIZE	4096	/* default socket send/recv size */

extern void	udptli_error();

#endif	_UDP_TLI_

