/*      @(#)lodg_tli.h 1.2 91/03/11 SMI      */

/*
 * Copyright (c) 1989 by Sun Microsystems, Inc.
 */

/*
 * Options introductory header.
 */
typedef struct opthdr {
	long	opt_offset;
	long	next_hdr_offset;
} opthdr_t;

/*
 * Turn on some level of peer identification or
 * get the current level of peer identification.
 */
struct opt_setid {
	long	type;	/* must be SETID */
	long	id;	/* can be any combination of UID, GID, RUID, RGID */
};

struct opt_getid {
	long	type;	/* must be GETID */
	long	id;	/* can be any combination of UID, GID, RUID, RGID */
};

/*
 * Only use is for returning in answer to
 * T_DEFAULT requests.
 */
struct opt_noop {
	long	type;	/* can only be NOOP */
};

/*
 * One ot more of these are returned in the options
 * field of a t_rcvudata() request if peer
 * identification is turned on. They can also
 * be used in a T_NEGOTIATE request to return the
 * callers values.
 */
struct opt_uid {
	long	type;	/* Must be OPT_UID */
	long	uid;
};
struct opt_gid {
	long	type;	/* Must be OPT_GID */
	long	gid;
};
struct opt_ruid {
	long	type;	/* Must be OPT_RUID */
	long	ruid;
};
struct opt_rgid {
	long	type;	/* Must be OPT_RGID */
	long	rgid;
};

union opt_req {
	long			type;
	struct opt_noop		noop;
	struct opt_setid	setid;
	struct opt_getid	getid;
	struct opt_uid		uid;
	struct opt_gid		gid;
	struct opt_ruid		ruid;
	struct opt_rgid		rgid;
};

#define		NOOP		0x01
#define		SETID		0x02
#define		GETID		0x04

#define		OPT_UID		0x08
#define		OPT_GID		0x10
#define		OPT_RUID	0x20
#define		OPT_RGID	0x40


#define		LODG_TIDUSZ	(8*1024)
#define		LODG_OPTSZ	(LODG_TIDUSZ-24)
#define		LODG_ADDRSZ	128
