/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user or with the express written consent of
 * Sun Microsystems, Inc.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
#ifndef lint
static        char sccsid[] = "@(#)local_file.c	1.12 91/03/11";
#endif

/*
 * Copyright (c) 1989 by Sun Microsystems, Inc.
 */

/*
 * These are the name to address converters for the local (eg loopback) 
 * transport. 
 */

#include <stdio.h>
#include <sys/param.h>
#include <tiuser.h>
#include <netconfig.h>
#include <netdir.h>
#include <fcntl.h>
#include <netdb.h>
#include <sys/utsname.h>


extern int 	_nderror;
extern char	*strdup();
extern char	*malloc();
extern char	*index();

static struct servent *_local_getservbyname();

#define		LOCALHOST	"localhost"

/*
 *  local_getbyname(tp, serv)
 *
 *  serv->h_host must be HOST_SELF.  The name returned is string of form
 *  <hostname>.<servicename>, where <hostname> is localhost's real name and
 *  <servicename> is service's name as found in the /etc/services file.
 */

struct nd_addrlist *
#ifdef SHARED_LIBS
_netdir_getbyname(tp, serv)
#else
local_netdir_getbyname(tp, serv)
#endif
	struct netconfig *tp;
	struct nd_hostserv *serv;
{
	char			*name;
	struct utsname		hname;
	struct nd_addrlist	*result;
	struct servent		*service;

	if ((name = malloc((2*MAXHOSTNAMELEN)+1)) == NULL) {
		_nderror = ND_NOMEM;
		return (0);
	}
	if (uname(&hname) != 0) {   /* might have used gethostname() here */
	    (void) strcpy(name, LOCALHOST);    /* well, better than nothing */
	} else {
	    (void) strcpy(name, hname.nodename);
	}
	if (strcmp(serv->h_host, HOST_SELF) != 0 &&
		strcmp(serv->h_host, name) !=0 &&
		strcmp(serv->h_host, LOCALHOST) !=0) {
	    _nderror = ND_NOHOST;
	    free(name);
	    return (0);
	}
	(void) strcat(name, ".");
        if ((service = _local_getservbyname(serv->h_serv, NULL)) == NULL) {
	    /* hmm, well use the service name supplied */
	    (void) strcat(name, serv->h_serv);
	} else {
	    (void) strcat(name, service->s_name);
	}
	result = (struct nd_addrlist *)malloc(sizeof(struct nd_addrlist));
	if (result == NULL) {
		_nderror = ND_NOMEM;
		free(name);
		return (0);
	}
	result->n_addrs = (struct netbuf *)malloc(sizeof(struct netbuf));
	if (result->n_addrs == NULL) {
		free(name);
		free(result);
		_nderror = ND_NOMEM;
		return (0);
	}

	result->n_cnt = 1;
	result->n_addrs->buf = (char *)strdup(name);
	free(name);
	if (result->n_addrs->buf == NULL) {
		free(result->n_addrs);
		free(result);
		_nderror = ND_NOMEM;
		return (0);
	}
	result->n_addrs->len = strlen(result->n_addrs->buf) + 1;
	result->n_addrs->maxlen = local_maxlen(tp->nc_device);
	return (result);
}

/*
 *  local_getbyaddr(tp, addr)
 *
 * where addr is a netbuf whose buf is a string of the form: <host>.<service>
 * We return a list that has HOST_SELF as the h_host entry and the service's
 * official name and aliases in h_serv.  If service name was not found in
 * /etc/services, we return the name that was supplied.
 * Sorry, this routine doesn't handle dotted-decimal form addresses.
 */

struct nd_hostservlist *
#ifdef SHARED_LIBS
_netdir_getbyaddr(tp, addr)
#else
local_netdir_getbyaddr(tp, addr)
#endif
	struct netconfig	*tp;
	struct netbuf		*addr;
{
	int			namecnt = 1;  /* always have "offical" name */
	char			*name;
	struct utsname		hname;
	char			*dot;
	char			**servlist;
	struct servent		*service;
	struct nd_hostservlist 	*result;
	struct nd_hostserv	*hostservp;

	if ((dot=index(addr->buf, '.')) == NULL) {
	    _nderror = ND_BADARG;
	    return (0);
	}
	if ((name = malloc(MAXHOSTNAMELEN+1)) == NULL) {
	    _nderror = ND_NOMEM;
	    return (0);
	}
	if (uname(&hname) != 0) {   /* might have used gethostname() here */
	    (void) strcpy(name, LOCALHOST);    /* well, better than nothing */
	} else {
	    (void) strcpy(name, hname.nodename);
	}
	if (strncmp(name, addr->buf, dot - addr->buf) != 0) {
	    _nderror = ND_NOHOST;   /* note: host aliases are not acceptable */
	    free(name);
	    return (0);
	}
	free(name);
        if ((service = _local_getservbyname(dot+1, NULL)) == NULL) {
	    namecnt=1;		    /* we'll use service name supplied */
	} else {
	    dot = NULL;		    /* flag that we have a service list */
	    /* count how many service aliases we have */
	    for (servlist=service->s_aliases; *servlist != NULL; servlist++)
		namecnt++;
	}
	/* allocate major result structures */
	result =
	    (struct nd_hostservlist *)malloc(sizeof(struct nd_hostservlist));
	if (result == NULL) {
		_nderror = ND_NOMEM;
		return (0);
	}
	hostservp = result->h_hostservs =
	    (struct nd_hostserv *)malloc(namecnt * sizeof(struct nd_hostserv));
	if (result->h_hostservs == NULL) {
		free(result);
		_nderror = ND_NOMEM;
		return (0);
	}
	result->h_cnt = namecnt;
	/* make up the "offical" entry */
	hostservp->h_host = strdup(HOST_SELF);
	if (hostservp->h_host == NULL) {
		free(hostservp->h_serv);
		free(result->h_hostservs);
		free(result);
		_nderror = ND_NOMEM;
		return (0);
	}
	if (dot == NULL)
	    hostservp->h_serv = strdup(service->s_name);
	else
	    hostservp->h_serv = strdup(dot+1);
	if (hostservp->h_serv == NULL) {
		free(result->h_hostservs);
		free(result);
		_nderror = ND_NOMEM;
		return (0);
	}
	if (dot == NULL) {
	    /* Deal with the service aliases */
	    for (namecnt=1, servlist=service->s_aliases; *servlist != NULL;
		    namecnt++, servlist++) {
		(++hostservp)->h_serv = strdup(*servlist);
		hostservp->h_host = strdup(HOST_SELF);
		if (hostservp->h_host == NULL || hostservp->h_serv == NULL) {
		    /* return what we *do* have */
		    free(hostservp->h_serv);
		    free(hostservp->h_host);
		    result->h_cnt = namecnt;
		    break;
		}
	    }
	}
	return (result);
}

int
#ifdef SHARED_LIBS
_netdir_options(tp, opts, fd, par)
#else
local_netdir_options(tp, opts, fd, par)
#endif
	struct netconfig	*tp;
	int			opts;
	int			fd;
	char			*par;
{
	struct nd_mergearg *ma;

	switch (opts) {
	case ND_SET_BROADCAST:
		/* broadcasting meaningless on loopback transport */
		return (ND_FAILCTRL);
	case ND_SET_RESERVEDPORT:	/* bind to a resered port */
		return (ND_OK);		/* do nothing */
	case ND_CHECK_RESERVEDPORT:	/* check if reserved prot */
		return (ND_OK);		/* all are reserved */
	case ND_MERGEADDR:	/* Merge two addresses */
		ma = (struct nd_mergearg *)(par);
		ma->m_uaddr = strdup(ma->s_uaddr);  /* server's addr is best */
		return (ND_OK);
	default:
		break;
	}
	return (ND_NOCTRL);
}

char *
#ifdef SHARED_LIBS
_taddr2uaddr(tp, addr)
#else
local_taddr2uaddr(tp, addr)
#endif
	struct netconfig	*tp;
	struct netbuf		*addr;
{
#define	UNIT_SIZE   4		/* format: "xxx." */

	char	*tmp;
	char	*result = NULL;
	int	i;

	for (i=0; i < (addr->len-1); i++)
	    if (!isprint(addr->buf[i]))
		break;

	if (i+1 == addr->len && addr->buf[i] == '\0') { /* it's a string */
	    if ((result=malloc(i+1)) == NULL) {
		_nderror = ND_NOMEM;
		return (NULL);
	    }
	    (void) strcpy(result, addr->buf);
	    return (result);
	}
	if ((result=tmp=malloc((UNIT_SIZE * addr->len) + 1)) == NULL) {
		_nderror = ND_NOMEM;
		return (NULL);
	}
	for (i=0; i<addr->len; i++)  {
	    (void) sprintf(tmp, "%u.", (unsigned char)addr->buf[i]);
	    tmp += strlen(tmp);
	}
	*(tmp-1) = '\0';	    /* zap last '.' */
	return (result);
}

struct netbuf *
#ifdef SHARED_LIBS
_uaddr2taddr(tp, addr)
#else
local_uaddr2taddr(tp, addr)
#endif
	struct netconfig	*tp;
	char			*addr;
{
	int		i = 0;
	int		scan;
	char		*finddot;
	char		*dupaddr, *dupaddr_b;
	struct netbuf	*result;

	result = (struct netbuf *)malloc(sizeof(struct netbuf));
	if (result == NULL) {
		_nderror = ND_NOMEM;
		return (0);
	}
	result->maxlen=local_maxlen(tp->nc_device);

	/* dotted decimal or name.service format? */
	if ((finddot = index(addr, '.')) == NULL) { /* must have 1 dot */
	    free(result);
	    _nderror = ND_BADARG;
	    return (0);
	}
	if (index(++finddot, '.') == NULL) {	/* only 1 dot: name.service */
	    if ((result->buf=malloc((scan=strlen(addr)+1))) == NULL) {
		free(result);
		_nderror = ND_NOMEM;
		return (0);
	    }
	    (void) strcpy(result->buf, addr);
	    result->len = scan;
	    return (result);
	}
	/* more than 1 dot: address is dotted-decimal; convert it */
	if ((result->buf=malloc(strlen(addr))) == NULL) {
		_nderror = ND_NOMEM;
		free(result);
		return (0);
	}
	if ((dupaddr = dupaddr_b = strdup(addr)) == NULL) {
		_nderror = ND_NOMEM;
		free(result->buf);
		free(result);
		return (0);
	}
	do {
	    finddot=index(dupaddr, '.');
	    if (finddot != NULL)
		*finddot = '\0';
	    (void) sscanf(dupaddr, "%u", &scan);
	    result->buf[i] = (char)scan;
	    dupaddr = finddot+1;
	    i++;
	} while (finddot != NULL);
	result->len = i;
	free(dupaddr_b);
	return (result);
}

static int
local_maxlen(dev)
char *dev;
{
    int fd;
    struct t_info info;

    if ((fd=t_open(dev, O_RDONLY, &info)) < 0)
	return (-1);
    else {
	(void) t_close(fd);
	return (info.addr);
    }
}


#include "table.h"

static int parse_name(), parse_port();

#define SERVDB "/etc/services"

static struct ServData {
		FIELD	serv_fields[3];
		TABLE	serv_table;
		struct servent	serv;
		} *servdata, *_getservdata();

static struct ServData *
_getservdata()
{
	if (servdata)
		return servdata;

	servdata = (struct ServData *)calloc(1, sizeof(struct ServData));
	if (!servdata) {
		return NULL;
	}

	/* The fields */
	strcpy(servdata->serv_fields[0].name, "Servicename");
	servdata->serv_fields[0].index = 0;
	servdata->serv_fields[0].parse = parse_name;
	servdata->serv_fields[0].result = (void *)(&(servdata->serv.s_name));
	strcpy(servdata->serv_fields[1].name, "port");
	servdata->serv_fields[1].index = 1;
	servdata->serv_fields[1].parse = parse_port;
	servdata->serv_fields[1].result = (void *) &(servdata->serv.s_port);
	strcpy(servdata->serv_fields[2].name, "protocol");
	servdata->serv_fields[2].index = 2;
	servdata->serv_fields[2].parse = parse_name;
	servdata->serv_fields[2].result = (void *) &(servdata->serv.s_proto);
	strcpy(servdata->serv_fields[3].name, "Aliases");
	servdata->serv_fields[3].index = 3;
	servdata->serv_fields[3].parse = parse_name;
	servdata->serv_fields[3].result= (void *)(&(servdata->serv.s_aliases));

	/* The table */
	strcpy(servdata->serv_table.file, SERVDB);
	strcpy(servdata->serv_table.brk, " \t,/");
	servdata->serv_table.flags = TBF_MULTIVALUE,
	servdata->serv_table.n_fields = 3;
	servdata->serv_table.fields = servdata->serv_fields;

	return servdata;
}

static setservent(f)
	int	f;
{
	struct ServData *hd = _getservdata();

	opentable(&(hd->serv_table), f);
	return  0;
}

static struct servent *
getservent()
{
	struct ServData *sd = _getservdata();

	if (readtable(&(sd->serv_table)))
		return NULL;
	else
		return &(sd->serv);
}

static endservent()
{
	struct ServData *sd = _getservdata();

	closetable(&(sd->serv_table));
}

static struct servent *
_local_getservbyname(name, proto)
	char	*name;
	char 	*proto;
{
	struct servent *se;
	char **aliases;

	setservent(0);

	while ((se=getservent()) != NULL) {
	    if (proto != NULL) {
		if (strcmp(se->s_proto, proto) != 0)
		    continue;
	    }
	    if (strcmp(se->s_name, name) == 0) {
		break;
	    }
	    for (aliases=se->s_aliases; *aliases != NULL; aliases++) {
		if (strcmp(*aliases, name) == 0)
		    goto foundsrv;
	    }
	}
foundsrv:
	endservent();
	return (se);
}

static struct servent *
_local_getservbyport(port, proto)
	int	port;
	char	*proto;
{
	struct servent *se;

	setservent(0);

	while ((se=getservent()) != NULL) {
	    if (proto != NULL) {
		if (strcmp(se->s_proto, proto) != 0)
		    continue;
	    }
	    if (se->s_port == port)
		    break;
	}
	endservent();
	return (se);
}


static int
parse_port(data, deflt, result)
	char	*data;
	char 	**deflt;
	int	*result;
{
	*result = atoi(data);
	return 1;
}

static int
parse_name(data, deflt, result)
	char	*data;
	char 	**deflt;
	char	**result;
{
	*result = data;
	return 1;
}
