/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user or with the express written consent of
 * Sun Microsystems, Inc.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

/* @(#)table.h	1.5 91/03/11 TIRPC 1.0 */

/*
 *	table.h
 *
 * This file implements the table routines.
 *
 *	Copyright (c) 1989 by Sun Microsystems, Inc.
 *
 * Include file that defines constants used by the table routine.
 */

/* Manifest Constants */
#define TBL_COMMENT  '#'  /* The current comment character        */
#define TBL_DEFAULT  "-"  /* Place holder for missing token value */
#define DBM_TRIGGER  '+'  /* The name service trigger character   */

#define MAXBUF	    1024  /* Buffer working size (max for 1 line) */
#define MAXTOKEN      64  /* Maximum number of tokens in a line   */

/* Table flags */
#define TBF_MULTIVALUE 1 /* last field gets all remaining tokens   */
#define TBF_STAYOPEN   2 /* keep the fd open when you call close   */
#define TBF_FREEFORM   4 /* header line in file                    */
#define TBF_MULTILINE  8 /* Check for escaped new line chars	   */

/* Error codes */
#define TBE_NOMEM	10000	/* A very large number */
#define TBE_UNKNOWN_TOKEN 10001 /* To keep them from interfering with errno */
#define TBE_NOFILE         10002
#define TBE_NOT_ENOUGH     10003
#define TBE_TOKEN_MISMATCH 10004
#define TBE_NO_TOKENS      10005

/* Data structures */
struct tbl_field {
	char	name[32];	/* Field name 			   */
	int	index;		/* index into the file layout	   */
#if (__cplusplus || c_plusplus || __STDC__)
	int	(*parse)(...);	/* Parsing function 		   */
#else
	int	(*parse)();	/* Parsing function 		   */
#endif
	void	*result;	/* Place to store the result 	   */
	void	*defrslt;	/* Default value		   */
};

typedef struct tbl_field FIELD;

struct tbl_handle {
	char	file[64];	/* Fully specified filename 	*/
	FILE	*fd;		/* Table file descriptor	*/
	char	brk[4];		/* Character separators		*/
	int	error;		/* current error on this table	*/
	short	flags;		/* Flag information for table   */
	char	*s_data;	/* Static data area, malloc'd	*/
	int	n_tokens;	/* # of valid tokens in the list*/
	char	**tokens;	/* Static token list		*/
	int	n_fields;	/* Expected number of fields	*/
	FIELD	*fields;	/* Pointer to the first one	*/
};

typedef struct tbl_handle TABLE;

/* ANSI/C++ function declarations */

#ifdef __cplusplus
extern "C" int	opentable(TABLE *, int);
extern "C" int	closetable(TABLE *);
extern "C" int	readtable(TABLE *);
extern "C" int	searchbyfield(TABLE *, int, void *, int (*)(...));
extern "C" int	interpret(TABLE *);
#elif (__STDC__ || c_plusplus)
int	opentable(TABLE *, int);
int	closetable(TABLE *);
int	readtable(TABLE *);
int	searchbyfield(TABLE *, int, void *, int (*)());
int	interpret(TABLE *);
#else
int	opentable();
int	closetable();
int	readtable();
int	searchbyfield();
int	interpret();
#endif
