.\" @(#)rpcintro.ms 1.4 91/03/11 TIRPC 1.0
.\"
.\" Must use -- pic -- with this one
.\"
.if \\n%=1 .bp
.if t .po 1.25i
.ND
.\" prevent excess underlining in nroff
.if n .fp 2 R
.OF '''%'
.EF '%'''
.OH '\*(Tl''Introduction to Remote Procedure Calls'
.EH 'Introduction to Remote Procedure Calls''\\*(Tl'
.SH
\&Introduction to Remote Procedure Calls
.XS
\&Introduction to Remote Procedure Calls
.XE
.IX "RPC introduction"
.LP
What are remote procedure calls?  Simply put, they are a high-level
communications paradigm which allows network applications to be
developed by way of specialized kinds of procedure calls designed to 
hide the details of the underlying networking mechanisms.  RPC is 
transport independent, being able to take advantage of whatever kinds 
of networking mechanisms (such as TCP/IP or X.25 or npack) are
available.  Upon these mechanisms, and with the assistance of a small
number of generic facilities\(emsuch as 
.I rpcbind ,
which associates network services with well-known network addresses\(emit 
implements a logical client to server communications system designed
specifically for the support of network applications.  With RPC, the 
client makes a procedure call which sends data packets to the server
as necessary.  When these packets arrive, the server calls a dispatch 
routine, performs whatever service is requested, sends back the reply, 
and the procedure call returns to the client.
.LP
The net effect of programming with RPC is programs which are designed to
run within a client/server network model.  Such programs use RPC mechanisms
to avoid the details of interfacing to the network, and provide network
services to their callers without even requiring that they be aware of
the existence and function of the underlying network.  For example, a
program can simply make a call to
.I rnusers (),
a C routine which returns the number of users on a remote machine.  The
caller is not explicitly aware of using RPC \(em they simply call a
procedure, just as they would call
.I malloc() .
.LP
Although this discussion only mentions the interface to C, remote procedure
calls can be made from any language.  And even though this discussion
refers to RPC only insofar as it is used to communicate between processes
on different machines, it works just as well for communication between
different processes on the same machine.
.KS
.NH 1
\&The RPC Paradigm
.XS
    \&The RPC Paradigm
.XE
.IX RPC paradigm
.LP
Here is a diagram of the RPC paradigm:
.LP
.PS
L1: arrow down 1i "client " rjust "program " rjust
L2: line right 1.5i "\fIRPC Call\fP" ""
move up 1.5i; line dotted down 6i; move up 4.5i
arrow right 1i
L3: arrow down 1i "invoke " rjust "service " rjust
L4: arrow right 1.5i "call" "service"
L5: arrow down 1i " service" ljust " executes" ljust
L6: arrow left 1.5i "\fIRPC Return\fP" ""
L7: arrow down 1i "request " rjust "completed " rjust
L8: line left 1i
arrow left 1.5i "\fIreturn\fP" "reply"
L9: arrow down 1i "program " rjust "continues " rjust
line dashed down from L2 to L9
line dashed down from L4 to L7
line dashed up 1i from L3 "service " rjust "daemon " rjust
arrow dashed down 1i from L8
move right 1i from L3
box invis "Machine B"
move left 1.2i from L2; move down
box invis "Machine A"
.PE
.KE
.LP
In the above diagram, the details of the network transport are hidden
within the remote procedure call.  Note, however, that the RPC would not
be very useful if those details were entirely unavailable to users and
programmers who required access to them.  
.LP
For example, one of the reasons why transport independence is desirable is
that, with it, application binaries can be made portable across a variety
of platforms, even if those platforms don't support the same transports.
This goal can be achieved, but only if there is an adequate set of network
selection mechanisms by which both applications and their users can choose
the most appropriate of the available transports, and only if a transport,
once selected, can be configured so that the application will run on it
with no unacceptable performance loss.  RPC, with its universal addresses, 
and variety of interface levels, and with the support of name-to-address 
mapping facilities, and network selection mechanisms, meets both of these 
requirements.
.NH 1
\&Versions and Numbers
.XS
    \&Versions and Numbers
.XE
.LP
Each RPC procedure is uniquely defined by a program number, version number,
and procedure number.  The program number specifies a group of related
remote procedures, each of which has a different procedure number.  Each
program also has a version number, so when a minor change is made to a
remote service (adding a new procedure, for example), a new program number
doesn't have to be assigned.  When you want to call a procedure to find the
number of remote users, you look up the appropriate program, version and
procedure numbers in a manual, just as you look up the name of a memory
allocator when you want to allocate memory.
.NH 2
\&Assigning Program Numbers
.IX "program number assignment"
.IX "assigning program numbers"
.LP
Program numbers are assigned in groups of
.I 0x20000000 
according to the following chart:
.DS
.ft L
       0x0 - 0x1fffffff	\fRDefined by Sun\fP
0x20000000 - 0x3fffffff	\fRDefined by user\fP
0x40000000 - 0x5fffffff	\fRTransient\fP
0x60000000 - 0x7fffffff	\fRReserved\fP
0x80000000 - 0x9fffffff	\fRReserved\fP
0xa0000000 - 0xbfffffff	\fRReserved\fP
0xc0000000 - 0xdfffffff	\fRReserved\fP
0xe0000000 - 0xffffffff	\fRReserved\fP
.ft R
.DE
Sun Microsystems administers the first group of numbers, which
should be identical for all Sun customers.  If a customer
develops an application that might be of general interest, that
application should be given an assigned number in the first
range.  The second group of numbers is reserved for specific
customer applications.  This range is intended primarily for
debugging new programs.  The third group is reserved for
applications that generate program numbers dynamically.  The
final groups are reserved for future use, and should not be
used.
.LP
To register a protocol specification, send a request by email to
.I rpc@sun.com
or write to:
.DS
RPC Administrator
Sun Microsystems
2550 Garcia Ave.
Mountain View, CA 94043
.DE
Please include a compilable
.I rpcgen 
\*Q.x\*U file describing your protocol.
You will be given a unique program number in return.
.IX RPC administration
.IX administration "of RPC"
.LP
The RPC program numbers and protocol specifications of standard RPC 
services can be found in the include files in
.I "/usr/include/rpcsvc" .
These services, however, constitute only a small subset of those which 
have been registered.  
.NH 1
\&Network Selection
.XS
    \&Network Selection
.XE
.IX "network selection"
.LP
Network selection is a simple way by which users and applications can
dynamically select transports, according to both their preferences and 
the available transports.  It is based upon two mechanisms, the
.I /etc/netconfig 
database, which lists the transports available on the host and identifies
them by type, and the optional environmental variable
.I NETPATH ,
which allows the user to specify their preference among the transports
available in
.I /etc/netconfig 
and acceptable to the application.
.SH
.I
In order for an application to take advantage of network selection, it 
must interface to RPC at a level below the \*Qintermediate level\*U, 
i.e., the level composed of
.I clnt_create() 
and its associated routines.  Only then can it specify the types of
networks which it prefers.  See below for details about the various RPC
levels.
.LP
.LP
The 
.I /etc/netconfig 
file contains a number of lines, each of which corresponds to one of
the available transports.  Here are some possible entries:
.DS
.ft L
tcp tpi_cots v  inet tcp /dev/tcp /usr/lib/ip.so
udp tpi_clts vb inet udp /dev/udp /usr/lib/ip.so
loopback_dg tpi_clts - - - /dev/tidg /usr/lib/tidg.so
loopback_vc tpi_cots - - - /dev/tivc /usr/lib/tivc.so
.DE
For the details about 
.I /etc/netconfig ,
and about the applications interface to it, see the 
.I getnetconfig(3N) 
man page.  
Here, we just want to point out a few important points:
.IP \*(SQ
Each entry contains an identifier (the first field) which gives the 
network identifier by which it is commonly known.
.IP \*(SQ
Each entry also contains a flag or set of flags (the third field) that 
identifies it by type \(em the `v' flag, for example, identifies any 
transport which is `visible'.
.IP \*(SQ
The last field is a run-time linkable module which contains the 
name-to-address translation routines associated with the transport.  
(See below).
.IP \*(SQ
The loopback transports are required for registering services with
.I rpcbind .
They are local transports, available only to local clients and 
servers, and hence are more secure than other transports.
.LP
The format of
.I NETPATH
is simple, an ordered list of network identifiers separated by `:'.
For example,
.DS
.ft L
udp:tcp:npack
.DE
If
.I NETPATH 
is not set, the system defaults to all of the visible transports 
specified in 
.I /etc/netconfig ,
in the order which they appear.  By setting
.I NETPATH ,
however, the user can specify the order in which the application should 
try the various networks.  Importantly, applications can choose to ignore 
a user's 
.I NETPATH .
.LP
RPC divides all possible transports into the following types:
.IP "\*(SQ \f(BInetpath\fP" 12
Choose from those transports which have been specified in the 
.I NETPATH 
environment variable.
.IP "\*(SQ \f(BIvisible\fP"
Choose those transport which have the visible flag (`v') set in their
.I /etc/netconfig 
entries.
.IP "\*(SQ \f(BIcircuit_v\fP"
Same as \fIvisible\fP, but restricted to connection-oriented
transports.
.IP "\*(SQ \f(BIdatagram_v\fP"
Same as \fIvisible\fP, but restricted to connectionless transports. 
.IP "\*(SQ \f(BIcircuit_n\fP"
Whatever is defined in 
.I NETPATH ,
but restricted to connection-oriented transports.
.IP "\*(SQ \f(BIdatagram_n\fP"
Whatever is defined in 
.I NETPATH ,
but restricted to connectionless transports.
.IP "\*(SQ \f(BIudp\fP"
For backwards compatibility \(em specifies Internet udp.
.IP "\*(SQ \f(BItcp\fP"
For backwards compatibility \(em specifies Internet tcp.
.LP
When a transport-dependent application begins execution, it begins 
by calling the 
.I setnetconfig() ,
.I getnetconfig ()
and 
.I endnetconfig ()
routines, using them to search
.I /etc/netconfig 
for a transport which has the appropriate network type.  This information 
is then stored in local data structures of type \fIstruct netconfig\fP 
and is available for later use.
.LP
Taken together, these mechanisms allow a fine degree of control over
network selection.  A user can specify a preferred transport, and if
it is reasonable, applications will use it.  But in cases where the
transport fails \(em as, for example, when a remote server doesn't 
support a specified transport \(em the application will automatically 
try others with the right characteristics.
.NH 2
\&Name to Address Translation
.IX "name to address translation"
.LP
Each transport has associated a set of routines which convert between
universal network addresses \(em decimal-dotted string representations
of transport addresses \(em and its local address representation.  
These universal addresses are passed around within the RPC system, for
example, between
.I rpcbind 
and a client.  When any interface to transport code is made, a
transport-specific name-to-address translation routine is called to 
convert the universal address into local form.  Each transport has 
associated with it a run-time loadable library which contains the 
name-to-address translation routines associated with it.  The main 
routines are:
.IP "\fInetdir_getbyname\fP:"
Translates from host, service pairs (e.g. server1, rpcbind) to a set of
.I netbuf 
addresses.  
.I (netbuf 's
are TLI structures which are used at run-time to contain transport-specific 
addresses).
.IP "\fInetdir_getbyaddr\fP:"
Translates from 
.I netbuf 
addresses to host, service pairs.
.IP "\fIuaddr2taddr\fP:"
Translates from universal addresses to 
.I netbuf 
addresses.
.IP "\fItaddr2uaddr\fP:"
Translates from 
.I netbuf 
addresses to universal addresses.  This is the 
.I only
way to get an universal address.
.NH 1
\&\fBrpcbind\fP
.XS
    \&\fBrpcbind\fP
.XE
.IX rpcbind "" "\fIrpcbind\fP" "" PAGE MAJOR
.LP
Client programs need a way to find server programs; that is, they need a
way to look up the network addresses of server programs.  Network transport
services do not themselves provide such a service; they merely provide
process-to-process message transfer across a network.  A message is sent to
a transport-specific network address.  A network address is a logical
communications channel \(em by waiting on a network address, a process
receives messages from the network.
.LP
RPC, being transport independent, makes
.I no
assumptions about the structure of a network address.  It deals with
.I "universal addresses" ,
specified only as null-terminated strings of characters.  Such universal
addresses are translated into local transport addresses by translation
routines specific to each transport provider.  For more details on
these routines, see the
.I netdir(3N) 
man page.
.LP
How a process waits on a network address varies from one operating system to 
the next, but all provide mechanisms that by which a process can synchronize 
its activity with arriving messages. Thus, messages are not sent across 
networks to receiving processes, but rather to the network address at which 
receiving processes pick them up.  Network address are valuable because they 
allow message receivers to be specified in a way that is independent of the 
conventions of the receiving operating system.  The
.I rpcbind 
protocol defines a network service that provides a standard way for clients
to look up the network address of any remote program supported by a server.
Because it can be implemented on any transport, it provides a single 
solution to a general problem that works for all clients, all servers and 
all networks.
.NH 2
\&Address Registration
.IX rpcbind "address registration" "\fIrpcbind\fP"
.LP
Since 
.I rpcbind 
is responsible for mapping network services to network addresses, 
its address must be well known.  In the Internet domain, this problem is 
solved by always assigning 
.I rpcbind 
the port number 111.  Unfortunately, this simple solution is not acceptable
on all transports.  The name-to-address translation routines for any
particular transport should know and reserve a particular address for
.I rpcbind .
.I rpcbind 
begins each session by registering its location on each of the transports 
supported by the host upon which it finds itself running.
.LP
.I rpcbind 
is the only network service that must have such a well-known network address,
since it is responsible for registering the addresses of other network 
services and making them available to network clients, either by way of 
.I rpcinfo(1M) 
or the library routines specified in 
.I rpcbind (3N).
Thus, network services can be assigned network addresses statically or 
dynamically \(em as long as they register them with their host's 
.I rpcbind 
daemon.  Thus, RPC-based servers typically get mapped to network address at 
run time, and then they register with 
.I rpcbind ,
and neither they nor their clients can make any assumptions about what
those network addresses will be.
.LP
Delegating address-to-program mapping to 
.I rpcbind 
also automates network address administration.  Statically mapping addresses
and remote programs in a file duplicated on each client would require
updating all mapping files whenever a new remote program was introduced to
a network.  Such updating quickly becomes impossible as networks grow.  And
the alternative, placing the address-to-program mappings in a shared NFS
file, is too centralized \(em if the fileserver went down the whole network
would go down with it.
.LP
.I rpcbind 
is started whenever a machine is booted.  Both server programs and client 
programs call 
.I rpcbind 
library procedures.\**
.FS
.IX "clients and servers"
.IX servers "and clients"
Although client and server programs and client and server machines are
usually distinct, they need not be.  A server program can also be a client
program, as when an NFS server calls a
.I rpcbind 
server.  Likewise, when a client program directs a \*Qremote\*U procedure
call to its own machine, the machine acts as both client and server.
.FE
As part of its initialization, a server program calls its host's 
.I rpcbind 
daemon to register itself in the host's network-address map.  Whereas 
server programs call 
.I rpcbind 
to update network address maps, clients call them to query those maps.  
To find a remote program's network address, a client sends an RPC call 
message to a server's 
.I rpcbind 
daemon; if the remote program is supported on the server, the daemon 
returns the relevant network address in an RPC reply message.  The 
client program can then send RPC call messages to that address.  A 
client program can minimize its calls to 
.I rpcbind 
by caching the network addresses of recently called remote programs.
.SH
.I
Note that the service provided by
.I rpcbind 
is
.I inherently
stateful because a network-address map is a set of associations between 
registrant names and network address, that is, a description of a state.
.LP
.LP
The 
.I rpcbind 
protocol (for details, see the
\fI\f(LBrpcbind\fP Protocol\fR
section of the
\fIRemote Procedure Calls: Protocol Specification\fR
chapter) provides a procedure,
.I RPCBPROC_CALLIT (),
by which 
.I rpcbind 
can assist a client in making a remote procedure call.  A client program 
passes the target procedure's program number, version number and procedure 
number (for a discussion of these numbers, see the
\fIRemote Procedure Call Programming Guide\fR
chapter) and arguments in an RPC call message.
.I rpcbind 
then forks and looks up the target procedure's address in the address
map and sends an RPC call message to the target procedure including in it 
the arguments received from the client.  When the target procedure returns 
results, 
.I RPCBPROC_CALLIT() 
passes them on to the client program.  It also returns the target 
procedure's network address so the client can subsequently call it 
directly.
.LP
The RPC library provides an interface to all 
.I rpcbind 
procedures.  Some of the RPC library procedures also call 
.I rpcbind 
automatically on behalf of client and server programs.
.NH 2
\&\fBrpcinfo\fP
.LP
.I rpcinfo 
is a RPC program which reports current RPC registration information. 
It can be used (with either
.I rpcbind 
or the old version 2 portmapper) to find all the RPC services registered on
a specified host and to report their universal addresses and the transports
which they are registered under.  It can also be used to call a specific
version of a specific program on a specific host using a specific
transport, and to report whether a response is received.
.NH 1
\&Client-Side RPC Layers
.XS
    \&Client-Side RPC Layers
.XE
.LP
As is explained in detail in the 
\fIRemote Procedure Call Programming Guide\fR
chapter, there are various levels at which it is possible to interface
to the RPC library services.  Note that this material, while interesting, 
is not necessary if you plan to use 
.I rpcgen 
to generate your applications, as it largely obviates the need for you to 
understand the details of RPC.
.LP
Here, note only that there are various levels at which the programmer
can interface to RPC.  The levels and the details they hide can be seen in 
this view of client-side transport-handle creation:
.DS
.ce 24
.ft L
clnt_create(host, prog, vers, nettype)
.ft I
"Top Level" - transport is selected by network type.
.ft L
|
|
(Network Selection)
.ft I
Application controls transport selection below this point.
.ft L
|
|
clnt_tp_create(host, prog, vers, netconfig)
.ft I
"Intermediate Level" - application knows what transport it will use.
.ft L
|
|
(Name to Address Translation)
|
|
clnt_tli_create(fd, netconfig, ...)
.ft I
"Expert Level" - Application can now directly manipulate the transport code.
.ft L
|
|
-----------------------------
|                             |
|                             |
clnt_dg_create()              clnt_vc_create()
.ft I
"Bottom Level" - Only \f(BIvery\fP specialized applications need access to this level.
.ft L
.DE
.NH 1
\&Server-Side RPC Layers
.XS
    \&Server-Side RPC Layers
.XE
.LP
On the server side, a similar hierarchy of levels exists:
.DS
.ce 24
.ft L
svc_create(dispatch, prog, vers, nettype)
.ft I
"Top Level" - transport is selected by network type.
.ft L
|
|
(Network Selection)
.ft I
Application controls transport selection below this point.
.ft L
|
|
svc_tp_create (dispatch, prog, vers, netconfig)
.ft I
"Intermediate Level" - application knows what transport it will use.
.ft L
|
|
(Name to Address Translation)
|
|
svc_tli_create(fd, netconfig, ...)
.ft I
"Expert Level" - Application can now directly manipulate the transport code.
.ft L
|
|
-----------------------------
|                             |
|                             |
svc_dg_create()               svc_vc_create()
.ft I
"Bottom Level" - Only \f(BIvery\fP specialized applications need access to this level.
.ft L
.DE
The server side, you will note, is analogous to the client side.
.NH 1
\&The eXternal Data Representation
.XS
    \&The eXternal Data Representation
.XE
.LP
RPC presumes the existence of the eXternal Data Representation (XDR), a
standard for the machine-independent description and encoding of data.  XDR
is useful for transferring data between different computer architectures,
and has been used to communicate data between such diverse machines as the
Sun Workstation, VAX, IBM-PC, and Cray.  
.LP
RPC can handle arbitrary data structures, regardless of different machines' 
byte orders or structure layout conventions, by always converting them to 
a network standard called
.I "External Data Representation"
(XDR) before
sending them over the wire.  The process of converting from a particular 
machine representation to XDR format is called
.I serializing ,
and the reverse process is called
.I deserializing .
For a detailed discussion of XDR, see the
\fIExternal Data Representation Standard: Protocol Specification\fR
chapter.
.LP
