/* @(#)mandel_rpc.x	1.6 91/03/11 TIRPC 1.0 */
/*
 * file: mandel_rpc.x
 */
/* 
 *
 * MultiMandel was written by Carsten Ruseng Jakobsen, Ida Marie
 * Jensen, Thim Otskov, Claus Priisholm and Jeppe Sommer at the
 * University of Aalborg in Denmark spring 1989, and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.
 * Users may copy or modify MultiMandel without charge, but are not
 * authorized to license or distribute it to anyone else except as
 * part of a product or program developed by the user.
  
 * MultiMandel IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND
 * INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR
 * TRADE PRACTICE.
 * 
 * MultiMandel is provided with no support and without any obligation
 * on the part of the authors, to assist in its use, correction,
 * modification or enhancement.
 * 
 * THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY
 * MultiMandel OR ANY PART THEREOF.
 * 
 * In no event will the authors and/or University of Aalborg be liable
 * for any lost revenue or profits or other special, indirect and
 * consequential damages, even if the authors and/or University of
 * Aalborg has been advised of the possibility of such damages.
 * 
 * University of Aalborg
 * Strandvejen 19
 * 9000 Aalborg
 * Denmark
 */


const PIX_SIZE = 4000;

struct MandelCT
{
    int x;
    int y;
    int width;
    int height;
    int canvas_width;
    int canvas_height;
    int resolution;
    int cms_size;
    int depth;
    double zx;
    double zy;
    double zl;
};

struct PixMap
{
    int x;
    int y;
    int width;
    int height;
    int resolution;
    opaque pixels[PIX_SIZE];    /* packed array of bytes */
};

/*
 * The calc_mandel program definition
 */

program CALCPROG {
    version CALCVERS {
	PixMap
	CALCMANDEL(MandelCT) = 1;
    } = 1;
} = 0x20000303;

