/* @(#)mandel_proc.c	1.3 91/03/11 TIRPC 1.0 */
/*
 * file: mandel_proc.c
 */
/* 
 *
 * MultiMandel was written by Carsten Ruseng Jakobsen, Ida Marie
 * Jensen, Thim Otskov, Claus Priisholm and Jeppe Sommer at the
 * University of Aalborg in Denmark spring 1989, and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.
 * Users may copy or modify MultiMandel without charge, but are not
 * authorized to license or distribute it to anyone else except as
 * part of a product or program developed by the user.
  
 * MultiMandel IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND
 * INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR
 * TRADE PRACTICE.
 * 
 * MultiMandel is provided with no support and without any obligation
 * on the part of the authors, to assist in its use, correction,
 * modification or enhancement.
 * 
 * THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY
 * MultiMandel OR ANY PART THEREOF.
 * 
 * In no event will the authors and/or University of Aalborg be liable
 * for any lost revenue or profits or other special, indirect and
 * consequential damages, even if the authors and/or University of
 * Aalborg has been advised of the possibility of such damages.
 * 
 * University of Aalborg
 * Strandvejen 19
 * 9000 Aalborg
 * Denmark
 */


#include <stdio.h>
#include <rpc/rpc.h>
#include "mandel_rpc.h"

extern int errno;
extern char *malloc();

PixMap *
calcmandel_1(ct)
MandelCT *ct;
{
    register int   mj, mk, mn;
    register double ma, mb, msa, msb, mda, mdb, mu, mv, mx, my, mx2 ,my2;

    u_char *pixptr;

    PixMap  *pr;
    int ind_x;

    static PixMap res; /* must be static */


    /*
     * Free previous result
     */
#ifdef DEBUG
    fprintf(stderr," calcmandel_1 function entered\n");
#endif
#ifdef NOTDET
    if (res.pixels.pixels_val == NULL)	    /* first time thru; malloc array */
    {
	res.pixels.pixels_val = (u_char *)malloc(PIX_SIZE);
	if (res.pixels.pixels_val == NULL)  /* trouble */
	    return (NULL);
    }
#endif
    res.x= ct->x;
    res.y= ct->y;
    res.width= ct->width;
    res.height= ct->height;
    res.resolution= ct->resolution;

    ma  =        ct->zx; 
    mb  =        ct->zy; 
    msa = msb =  ct->zl;
    mda = msa/(double)ct->canvas_width;
    mdb = msb/(double)ct->canvas_height;
  
    ind_x= 0;

    for (mj=ct->x; mj<ct->x+ct->width; mj+=ct->resolution) {
	for (mk=ct->y; mk<ct->y+ct->height; mk+= ct->resolution) {
	    mu = ma+(mda*(double)mj);
	    mv = mb+(mdb*(double)mk);
	    mx2 = my2 = mx = my = 0.0;
	    for(mn=0;(mn<(ct->depth-1))&&((mx2+my2)<=4.0);mn++) {
		mx2 = mx*mx;
		my2 = my*my;
		my = mv +(2.0*mx*my);
		mx = mu +mx2-my2;
	    }
	    mn= mn%ct->cms_size;
	    res.pixels[ind_x++]= (u_char)mn;
/*	    res.pixels.pixels_val[ind_x++]= (u_char)mn; */

	}
    }
/*    res.pixels.pixels_len = ind_x; */
    /*
     * return the result
     */
#ifdef DEBUG
   fprintf(stderr," returning results from calcmandel_1 function\n");
/*
fprintf(stderr,"res.pixels.pixels_len: %d res.pixels.pixels_val[0]: %d\n",
	res.pixels.pixels_len,res.pixels.pixels_val[0]);
*/
fprintf(stderr,"res.pixels[0]: %d\n",res.pixels[0]);
#endif
    return (&res);
}


