/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user or with the express written consent of
 * Sun Microsystems, Inc.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
/*"@(#)key_prot.h 1.16 91/03/11 Copyright 1986,1990 Sun Microsystems, Inc."*/

#ifndef _RPC_KEY_PROT_H
#define  _RPC_KEY_PROT_H

/* 
 * Compiled from key_prot.x using rpcgen.
 * DO NOT EDIT THIS FILE!
 * This is NOT source code!
 */
#define PROOT 3
#define HEXMODULUS "d4a0ba0250b6fd2ec626e7efd637df76c716e22d0944b88b"
#define HEXKEYBYTES 48
#define KEYSIZE 192
#define KEYBYTES 24
#define KEYCHECKSUMSIZE 16

enum keystatus {
	KEY_SUCCESS = 0,
	KEY_NOSECRET = 1,
	KEY_UNKNOWN = 2,
	KEY_SYSTEMERR = 3,
};
typedef enum keystatus keystatus;
#ifdef __cplusplus
extern "C" bool_t xdr_keystatus(...);
#elif (__STDC__ || c_plusplus)
bool_t xdr_keystatus(...);
#else
bool_t xdr_keystatus();
#endif

#ifndef KERNEL

typedef char keybuf[HEXKEYBYTES];
#ifdef __cplusplus
extern "C" bool_t xdr_keybuf(...);
#elif (__STDC__ || c_plusplus)
bool_t xdr_keybuf(...);
#else
bool_t xdr_keybuf();
#endif

#endif

typedef char *netnamestr;
#ifdef __cplusplus
bool_t xdr_netnamestr(...);
#elif (__STDC__ || c_plusplus)
bool_t xdr_netnamestr(...);
#else
bool_t xdr_netnamestr();
#endif


struct cryptkeyarg {
	netnamestr remotename;
	des_block deskey;
};
typedef struct cryptkeyarg cryptkeyarg;
#ifdef __cplusplus
extern "C" bool_t xdr_cryptkeyarg(...);
#elif (__STDC__ || c_plusplus)
bool_t xdr_cryptkeyarg(...);
#else
bool_t xdr_cryptkeyarg();
#endif


struct cryptkeyres {
	keystatus status;
	union {
		des_block deskey;
	} cryptkeyres_u;
};
typedef struct cryptkeyres cryptkeyres;
#ifdef __cplusplus
extern "C" bool_t xdr_cryptkeyres(...);
#elif (__STDC__ || c_plusplus)
bool_t xdr_cryptkeyres(...);
#else
bool_t xdr_cryptkeyres();
#endif

#define MAXGIDS 16

struct unixcred {
	u_int uid;
	u_int gid;
	struct {
		u_int gids_len;
		u_int *gids_val;
	} gids;
};
typedef struct unixcred unixcred;
#ifdef __cplusplus
extern "C" bool_t xdr_unixcred(...);
#elif (__STDC__ || c_plusplus)
bool_t xdr_unixcred(...);
#else
bool_t xdr_unixcred();
#endif


struct getcredres {
	keystatus status;
	union {
		unixcred cred;
	} getcredres_u;
};
typedef struct getcredres getcredres;
#ifdef __cplusplus
extern "C" bool_t xdr_getcredres(...);
#elif (__STDC__ || c_plusplus)
bool_t xdr_getcredres(...);
#else
bool_t xdr_getcredres();
#endif


#define KEY_PROG ((u_long)100029)
#define KEY_VERS ((u_long)1)
#define KEY_SET ((u_long)1)
#define KEY_ENCRYPT ((u_long)2)
#define KEY_DECRYPT ((u_long)3)
#define KEY_GEN ((u_long)4)
#define KEY_GETCRED ((u_long)5)
#ifdef __cplusplus
extern "C" keystatus *key_set_1(opaque *,CLIENT *);
extern "C" cryptkeyres *key_encrypt_1(cryptkeyarg *,CLIENT *);
extern "C" cryptkeyres *key_decrypt_1(cryptkeyarg *,CLIENT *);
extern "C" des_block *key_gen_1(void *,CLIENT *);
extern "C" getcredres *key_getcred_1(netnamestr *,CLIENT *);
#elif (__STDC__ || c_plusplus)
extern keystatus *key_set_1(opaque *,CLIENT *);
extern cryptkeyres *key_encrypt_1(cryptkeyarg *,CLIENT *);
extern cryptkeyres *key_decrypt_1(cryptkeyarg *,CLIENT *);
extern des_block *key_gen_1(void *,CLIENT *);
extern getcredres *key_getcred_1(netnamestr *,CLIENT *);
#else
extern keystatus *key_set_1();
extern cryptkeyres *key_encrypt_1();
extern cryptkeyres *key_decrypt_1();
extern des_block *key_gen_1();
extern getcredres *key_getcred_1();
#endif

#endif /* _RPC_KEY_PROT_H */
