/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user or with the express written consent of
 * Sun Microsystems, Inc.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
#if !defined(lint) && defined(SCCSIDS)
static char sccsid[] = "@(#)clnt_bsoc.c 1.10 91/03/11 Copyr 1988 Sun Micro";
#endif

/*
 * clnt_bsoc.c
 * Help interface to broadcast service.
 *
 * Copyright (C) 1988, Sun Microsystems, Inc.
 *
 * the whole stuff should go away with dynamic transport specific libraries
 */

#ifdef PORTMAP
#include <rpc/rpc.h>
#include <rpc/nettype.h>
#include <rpc/pmap_prot.h>
#include <stdio.h>
#include <errno.h>
#include <sys/socket.h>
#include <netinet/in.h>

extern char *strdup();
extern int errno;

/*
 * Finds a list of broadcast addresses for the given transport tokenid
 * returns the number of such addresses found. Uses rpcbind and the
 * netdir daemon
 *
 * Returns the number of broadcast addresses found
 */
int
getbroadcastnets(fd, addrs, nconf)
	int fd;		/* Not being used currently */
	struct netbuf* addrs;
	struct netconfig *nconf;
{
#ifdef NOTDEF
	static struct sockaddr_in baddr;

	(void) memset((char *)&baddr, 0, sizeof (baddr));
	baddr.sin_family = AF_INET;
	baddr.sin_port = htons(PMAPPORT);
	/*
	 * Kludge  should try to get all ip interfaces and
	 * their broadcast addresses or have kernel support
	 * for broadcast to all interfaces
	 */
	baddr.sin_addr.s_addr = htonl(INADDR_BROADCAST);
	addrs->buf = (char *)&baddr;
#endif
	return (1);
}

/*
 * Do all the options managements stuff here. This is very protocol specific
 * and should be provided by the vendor. The following case is just for
 * socket/IP.
 * Returns 0 if succeeds else returns 1.
 */
int
negotiate_broadcast(fd, nconf)
	int fd;
	struct netconfig *nconf;
{
#ifdef NOTDEF
	struct t_optmgmt *options;
	struct t_optmgmt *optionsret;
	struct sochdr {
		struct opthdr opthdr;
		long value;
	} sochdr;
	options = (struct t_optmgmt *)t_alloc(fd, T_OPTMGMT, 0);
	if (options == (struct t_optmgmt *)NULL)
		return (1);
	optionsret = (struct t_optmgmt *)t_alloc(fd, T_OPTMGMT, T_OPT);
	if (options == (struct t_optmgmt *)NULL)
		return (1);
	sochdr.opthdr.level = SOL_SOCKET;
	sochdr.opthdr.name = SO_BROADCAST;
	sochdr.opthdr.len = 4;
	sochdr.value = 1;		/* ok to broadcast */
	options->opt.maxlen = sizeof(sochdr);
	options->opt.len = sizeof(sochdr);
	options->opt.buf =  (char *) &sochdr;
	options->flags = T_NEGOTIATE;
	if (t_optmgmt(fd, options, optionsret) == -1) {
		/*
		 * maybe shouldn't quit  if some transports just let you
		 * broadcast
		 */
	}
	options->opt.buf = 0;
	(void) t_free((char *)options, T_OPTMGMT);
	(void) t_free((char *)optionsret, T_OPTMGMT);
#endif
	return (0);
}
#endif /* PORTMAP */
