/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user or with the express written consent of
 * Sun Microsystems, Inc.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
/*
 * This is a test file to check out the name to address translation
 * routines. 
 */

#include <stdio.h>
#include <tiuser.h>
#include <sys/netconfig.h>
#include <netdir.h>
#include <sys/types.h>
#include <netinet/in.h>

char	netid[5] = "TCP",
	netdev[16] = "/dev/tcp",
	netlook[] = "tcpip.so",
	*netlookp[3];

struct netconfig tcp_config = {
	"TCP",
	NC_TPI_COTS,
	NC_VISIBLE,
	NC_INET,
	NC_TCP,
	"/dev/tcp",
	1,
	NULL,
	0,0,0,0,0,0,0,0
	};

char	*local[] = {"local.so", NULL};
	
struct netconfig local_config = {
	"LOOPBACK",
	NC_TPI_CLTS,
	NC_VISIBLE,
	NC_LOOPBACK,
	NC_NOPROTO,
	"/dev/loopback",
	1,
	(char **) &local[0],
	0,0,0,0,0,0,0,0
	};
	
main(argc, argv)
	int	argc;
	char	*argv[];

{
	struct	nd_addrlist	*nas;
	struct	netbuf		*na;
	char			host[32], service[32], *ua;
	struct	nd_hostserv	hs1,
				*hs;
	struct	nd_hostservlist	*hss;
	int			e;
	struct sockaddr_in	*sa;

	hs1.h_host = host;
	hs1.h_serv = service;
	netlookp[0] = netlook;
	netlookp[1] = NULL;
	tcp_config.nc_lookups = (char **)netlookp;

	printf("Network Directory test program.\n");
	printf("Enter hostname :");
	scanf("%s", host);
	printf("Enter service :");
	scanf("%s", service);
	printf("Lookup on : '%s'/'%s'\n", hs1.h_host, hs1.h_serv);

	e = netdir_getbyname(&tcp_config, &hs1, &nas);
	printf("netdir_getbyname returned %d\n", e);
	if (e) {
		netdir_perror("test");
		exit(1);
	} else {
		printf("Found %d answer(s).\n", nas->n_cnt);
		na = nas->n_addrs;
		sa = (struct sockaddr_in *) na->buf;
		printf("Returned address %s, port %d\n",
			inet_ntoa(sa->sin_addr.s_addr), sa->sin_port);
		ua = taddr2uaddr(&tcp_config, nas->n_addrs);
		printf("It's universal address is '%s'\n", ua);
	}

	e = netdir_getbyaddr(&tcp_config, &hss, nas->n_addrs);
	printf("netdir_getbyaddr returned %d\n",e);
	netdir_free(nas, ND_ADDRLIST);
	if (e)
		netdir_perror("test");
	else {
		printf("Found %d answer(s).\n",hss->h_cnt);
		for (hs = hss->h_hostservs, e = 0; e < hss->h_cnt; e++, hs++) 
			printf("[%2d] host = '%s', serv = '%s'\n",
						e, hs->h_host, hs->h_serv);
		netdir_free(hss, ND_HOSTSERVLIST);
	}
	
	na = uaddr2taddr(&tcp_config, ua);
	if (na) {
		printf("Converted from universal to tli and got :\n");
		sa = (struct sockaddr_in *) (na->buf);
		printf("Returned address %s, port %d\n",
			inet_ntoa(sa->sin_addr.s_addr), sa->sin_port);
		netdir_free(na, ND_ADDR);
	}
/*
 * Now check the loopback code 
 */
	printf("Loopback testing now ... \n");
	printf("Enter hostname :");
	scanf("%s", host);
	printf("Enter service :");
	scanf("%s", service);
	printf("Lookup on : '%s'/'%s'\n", hs1.h_host, hs1.h_serv);

	e = netdir_getbyname(&local_config, &hs1, &nas);
	printf("netdir_getbyname returned %d\n", e);
	if (e) {
		netdir_perror("test");
		exit(1);
	} else {
		printf("Found %d answer(s).\n", nas->n_cnt);
		na = nas->n_addrs;
		printf("addr buf has len %d, value '%s'\n",
			nas->n_addrs->len, nas->n_addrs->buf);
		ua = taddr2uaddr(&local_config, nas->n_addrs);
		printf("It's universal address is '%s'\n", ua);
	}

	e = netdir_getbyaddr(&local_config, &hss, nas->n_addrs);
	printf("netdir_getbyaddr returned %d\n",e);
	netdir_free(nas, ND_ADDRLIST);
	if (e)
		netdir_perror("test");
	else {
		printf("Found %d answer(s).\n",hss->h_cnt);
		for (hs = hss->h_hostservs, e = 0; e < hss->h_cnt; e++, hs++) 
			printf("[%2d] host = '%s', serv = '%s'\n",
						e, hs->h_host, hs->h_serv);
		netdir_free(hss, ND_HOSTSERVLIST);
	}
	
	na = uaddr2taddr(&local_config, ua);
	if (na) {
		/* Hmmm */
		printf("Converted from universal to tli and got :\n");
		printf("addr buf has len %d, value '%s'\n",
			na->len, na->buf);
		netdir_free(na, ND_ADDR);
	}
	exit(0);
}
