/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user or with the express written consent of
 * Sun Microsystems, Inc.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
#ifndef lint
static        char sccsid[] = "@(#)rstat_proc.c	1.8 91/03/11";
#endif

/*
 * Copyright (c) 1984 by Sun Microsystems, Inc.
 */


/*
 * rstat service:  built with rstat.x and derived from rpc.rstatd.c
 */

#include <signal.h>
#include <stdio.h>
#include <rpc/rpc.h>
#include <sys/socket.h>
#include <nlist.h>
#include <kvm.h>
#include <sys/dk.h>
#include <sys/errno.h>
#include <sys/vmmeter.h>
#include <net/if.h>
#include "rstat.h"

struct nlist nl[] = {
#define	X_CPTIME	0
	{ "_cp_time" },
#define	X_SUM		1
	{ "_sum" },
#define	X_IFNET		2
	{ "_ifnet" },
#define	X_DKXFER	3
	{ "_dk_xfer" },
#define	X_BOOTTIME	4
	{ "_boottime" },
#define	X_AVENRUN	5
	{ "_avenrun" },
#define X_HZ		6
	{ "_hz" },
	"",
};
kvm_t *kernel;
int firstifnet, numintfs;	/* chain of ethernet interfaces */
int stats_service();

/*
 *  Define EXIT_WHEN_IDLE if you are able to have this program invoked
 *  automatically on demand (as from inetd).  When defined, the service
 *  will terminated after being idle for 20 seconds.
 */
int sincelastreq = 0;		/* number of alarms since last request */
#ifdef EXIT_WHEN_IDLE
#define CLOSEDOWN 20		/* how long to wait before exiting */
#endif /* def EXIT_WHEN_IDLE */

union {
    struct stats s1;
    struct statsswtch s2;
    struct statstime s3;
} stats_all;

statsvar stats_s4;

void updatestat();
static stat_is_init = 0;
extern int errno;

#ifndef FSCALE
#define FSCALE (1 << 8)
#endif

stat_init()
{
	stat_is_init = 1;
	setup();
	updatestat();
	alarm(1);
	signal(SIGALRM, updatestat);
	sleep(1);               /* allow for one wake-up */
}

statsvar *
rstatproc_stats_4()
{
    if (! stat_is_init)
        stat_init();
    sincelastreq = 0;
    return(&stats_s4);
}

statstime *
rstatproc_stats_3()
{
    if (! stat_is_init)
        stat_init();
    sincelastreq = 0;
    return(&stats_all.s3);
}

statsswtch *
rstatproc_stats_2()
{
    if (! stat_is_init)
        stat_init();
    sincelastreq = 0;
    return(&stats_all.s2);
}

stats *
rstatproc_stats_1()
{
    if (! stat_is_init)
        stat_init();
    sincelastreq = 0;
    return(&stats_all.s1);
}

u_int *
rstatproc_havedisk_4()
{
    return(rstatproc_havedisk_3());
}

u_int *
rstatproc_havedisk_3()
{
	static u_int have;

	if (! stat_is_init)
		stat_init();
	sincelastreq = 0;
	have = havedisk();
	return(&have);
}

u_int *
rstatproc_havedisk_2()
{
    return(rstatproc_havedisk_3());
}

u_int *
rstatproc_havedisk_1()
{
    return(rstatproc_havedisk_3());
}

void
updatestat()
{
	int off, i, hz;
	struct vmmeter sum;
	struct ifnet ifnet;
	double avrun[3];
	struct timeval tm, btm;

#ifdef DEBUG
	fprintf(stderr, "entering updatestat\n");
#endif
#ifdef EXIT_WHEN_IDLE
	if (sincelastreq >= CLOSEDOWN) {
#ifdef DEBUG
	fprintf(stderr, "about to closedown\n");
#endif
		exit(0);
	}
	sincelastreq++;
#endif /* def EXIT_WHEN_IDLE */
	if (kvm_read(kernel, nl[X_HZ].n_value, (char *)&hz,
			sizeof hz) != sizeof hz) {
		fprintf(stderr, "rstatd: can't read hz from kernel\n");
		exit(1);
	}
	if (kvm_read(kernel, nl[X_CPTIME].n_value,
		(char *)stats_all.s1.cp_time, sizeof (stats_all.s1.cp_time))
		!= sizeof (stats_all.s1.cp_time)) {
		fprintf(stderr, "rstatd: can't read cp_time from kernel\n");
		exit(1);
	}
	stats_s4.cp_time.cp_time_len = CPUSTATES;
	if (stats_s4.cp_time.cp_time_val == NULL)
	    stats_s4.cp_time.cp_time_val =
		(int *)malloc(CPUSTATES * sizeof (int));
	bcopy(stats_all.s1.cp_time, stats_s4.cp_time.cp_time_val,
	    CPUSTATES*sizeof (int));

#ifdef vax
	if (lseek(kmem, (long)nl[X_AVENRUN].n_value, 0) ==-1) {
		fprintf(stderr, "rstatd: can't seek in kmem\n");
		exit(1);
	}
 	if (read(kmem, (char *)avrun, sizeof (avrun)) != sizeof (avrun)) {
		fprintf(stderr, "rstatd: can't read avenrun from kmem\n");
		exit(1);
	}
	stats_s4.avenrun[0] = stats_all.s2.avenrun[0] = avrun[0] * FSCALE;
	stats_s4.avenrun[1] = stats_all.s2.avenrun[1] = avrun[1] * FSCALE;
	stats_s4.avenrun[2] = stats_all.s2.avenrun[2] = avrun[2] * FSCALE;
#endif
#ifdef sun
	if (kvm_read(kernel, nl[X_AVENRUN].n_value, stats_all.s2.avenrun,
		sizeof (stats_all.s2.avenrun))
		!= sizeof (stats_all.s2.avenrun)) {
		fprintf(stderr, "rstatd: can't read avenrun from kernel\n");
		exit(1);
	}
	stats_s4.avenrun[0] = stats_all.s2.avenrun[0];
	stats_s4.avenrun[1] = stats_all.s2.avenrun[1];
	stats_s4.avenrun[2] = stats_all.s2.avenrun[2];
#endif
	if (kvm_read(kernel, nl[X_BOOTTIME].n_value, (char *)&btm,
		sizeof (stats_all.s2.boottime))
		!= sizeof (stats_all.s2.boottime)) {
		fprintf(stderr, "rstatd: can't read boottime from kernel\n");
		exit(1);
	}
	stats_s4.boottime.tv_sec = stats_all.s2.boottime.tv_sec = btm.tv_sec;
	stats_s4.boottime.tv_usec= stats_all.s2.boottime.tv_usec = btm.tv_usec;

#ifdef DEBUG
	fprintf(stderr, "%d %d %d %d\n", stats_all.s1.cp_time[0],
		stats_all.s1.cp_time[1], stats_all.s1.cp_time[2],
		stats_all.s1.cp_time[3]);
#endif

	if (kvm_read(kernel, nl[X_SUM].n_value, (char *)&sum, sizeof sum)
		!= sizeof sum) {
		fprintf(stderr, "rstatd: can't read sum from kernel\n");
		exit(1);
	}
	stats_s4.v_pgpgin = stats_all.s1.v_pgpgin = sum.v_pgpgin;
	stats_s4.v_pgpgout = stats_all.s1.v_pgpgout = sum.v_pgpgout;
	stats_s4.v_pswpin = stats_all.s1.v_pswpin = sum.v_pswpin;
	stats_s4.v_pswpout = stats_all.s1.v_pswpout = sum.v_pswpout;
	stats_all.s1.v_intr = sum.v_intr;
	gettimeofday(&tm, (struct timezone *) 0);
	stats_all.s1.v_intr -= hz*(tm.tv_sec - btm.tv_sec) +
	    hz*(tm.tv_usec - btm.tv_usec)/1000000;
	stats_s4.v_intr = stats_all.s1.v_intr;
	stats_s4.v_swtch = stats_all.s2.v_swtch = sum.v_swtch;

	if (kvm_read(kernel, nl[X_DKXFER].n_value,
		(char *)stats_all.s1.dk_xfer, sizeof (stats_all.s1.dk_xfer))
		!= sizeof (stats_all.s1.dk_xfer)) {
		fprintf(stderr, "rstatd: can't read dk_xfer from kernel\n");
		exit(1);
	}

	stats_s4.dk_xfer.dk_xfer_len = DK_NDRIVE;
	if (stats_s4.dk_xfer.dk_xfer_val == NULL)
	    stats_s4.dk_xfer.dk_xfer_val =
		(int *)malloc(DK_NDRIVE * sizeof (int));
	bcopy(stats_all.s1.dk_xfer, stats_s4.dk_xfer.dk_xfer_val,
	    DK_NDRIVE*sizeof (int));

	stats_all.s1.if_ipackets = 0;
	stats_all.s1.if_opackets = 0;
	stats_all.s1.if_ierrors = 0;
	stats_all.s1.if_oerrors = 0;
	stats_all.s1.if_collisions = 0;
	for (off = firstifnet, i = 0; off && i < numintfs; i++) {
		if (kvm_read(kernel, off, (char *)&ifnet, sizeof ifnet)
			!= sizeof ifnet) {
			fprintf(stderr,
				"rstatd: can't read ifnet from kernel\n");
			exit(1);
		}
		stats_all.s1.if_ipackets += ifnet.if_ipackets;
		stats_all.s1.if_opackets += ifnet.if_opackets;
		stats_all.s1.if_ierrors += ifnet.if_ierrors;
		stats_all.s1.if_oerrors += ifnet.if_oerrors;
		stats_all.s1.if_collisions += ifnet.if_collisions;
		off = (int) ifnet.if_next;
	}
	stats_s4.if_ipackets = stats_all.s1.if_ipackets;
	stats_s4.if_opackets = stats_all.s1.if_opackets;
	stats_s4.if_ierrors = stats_all.s1.if_ierrors;
	stats_s4.if_oerrors = stats_all.s1.if_oerrors;
	stats_s4.if_collisions = stats_all.s1.if_collisions;
	gettimeofday((struct timeval *)&stats_all.s3.curtime,
		(struct timezone *) 0);
	stats_s4.curtime = stats_all.s3.curtime;
	alarm(1);
}

static 
setup()
{
	struct ifnet ifnet;
	unsigned long addr;
	int num;

	kernel = kvm_open(NULL, NULL, NULL, O_RDONLY, "rstatd");
	if (kernel == NULL) {
		fprintf(stderr,"rstatd: could not access kernel structures\n");
		exit (1);
	}
#ifdef DEBUG
	fprintf(stderr,"kvm_open returns: %x\n", kernel);
#endif
	num = kvm_nlist(kernel, nl);
	if (num != 0) {
		fprintf(stderr,
			"rstatd: Variables missing from namelist (%d)\n", num);
		exit (1);
	}
#ifdef DEBUG
	fprintf(stderr,"kvm_nlist returns: %d\n", num);
	for (num = 0; num < (sizeof (nl)/sizeof (struct nlist)); num++) {
	    if (nl[num].n_name != NULL) {
		fprintf(stderr, "&n_name: %x n_value: %x n_type: %x\n",
			nl[num].n_name, nl[num].n_value, nl[num].n_type);
		fprintf(stderr, "n_name: %s n_value: %x n_type: %x\n",
			nl[num].n_name, nl[num].n_value, nl[num].n_type);
	    }
	    else
		fprintf(stderr, "n_name: NULL n_value: %x n_type: %x\n",
			nl[num].n_name, nl[num].n_value, nl[num].n_type);
	}
#endif
	if (kvm_read(kernel, nl[X_IFNET].n_value, (char *)&firstifnet,
			sizeof(int)) != sizeof (int)) {
		fprintf(stderr,"rstatd: can't read firstifnet from kmem\n");
		exit(1);
	}
#ifdef DEBUG
	fprintf(stderr,"kvm_read(IFNET) is: %x\n", firstifnet);
#endif
	numintfs = 0;
	for (addr = firstifnet; addr;) {
		if (kvm_read(kernel, addr, (char *)&ifnet,
				sizeof (ifnet)) != sizeof (ifnet)) {
			fprintf(stderr,
			"rstatd: can't read net interface info from kernel\n");
			exit(1);
		}
		numintfs++;
		addr = (int) ifnet.if_next;
	}
#ifdef DEBUG
	fprintf(stderr,"numintfs: %d\n", numintfs);
#endif
}

/*
 * returns true if have a disk
 */
static
havedisk()
{
	int i, cnt;
	long  xfer[DK_NDRIVE];

	if (kvm_read(kernel, nl[X_DKXFER].n_value, (char *)xfer,
			sizeof xfer)!= sizeof xfer) {
		fprintf(stderr,"rstatd: can't read disk info from kernel\n");
		exit(1);
	}
	cnt = 0;
	for (i=0; i < DK_NDRIVE; i++)
		cnt += xfer[i];
	return (cnt != 0);
}
