/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user or with the express written consent of
 * Sun Microsystems, Inc.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
#if !defined(lint) && defined(SCCSIDS)
static  char sccsid[] = "@(#)tcpip_nis.c	1.13 91/03/11 TIRPC 1.0";
#endif

/*
 * Copyright (c) 1989, 1990 by Sun Microsystems, Inc.
 */

#include <stdio.h>
#include <rpc/rpc.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <string.h>
#include <rpcsvc/yp_prot.h>

/*
 * NIS based gethostent routines ...
 *
 * NOTE: Only four routines in this file are not static:
 *	_tcpip_gethostbyname(),_tcpip_gethostbyaddr(),_tcpip_getservbyname(),
 *	_tcpip_getservbyport()
 *
 *  These routines are called from the transport specific routines in
 *  tcpip.c.
 */

extern char	*malloc(), *calloc(), *index();

#define HOSTMAP_BYNAME "hosts.byname"
#define HOSTMAP_BYADDR "hosts.byaddr"
#define SERVMAP_BYNAME "services.byname"    /* XXX  map is actually byport */

#define MAXTOKENS   64	    /* how many aliases can there be, anyway? */

static void parse_host_match();
static void parse_serv_match();


static struct HostData {
		long hostaddr;
		long *hostaddrp[2];
		struct hostent	host;
		char *local_domain;
		char *match_tmp;
		} *_gethostdata();

static struct HostData *
_gethostdata()
{

static struct HostData *hostdata;

	if (hostdata)
		return hostdata;

	hostdata = (struct HostData *)calloc(1, sizeof(struct HostData));
	hostdata->host.h_aliases = (char **)malloc(MAXTOKENS*sizeof (char *));

	if (hostdata == NULL || hostdata->host.h_aliases == NULL) {
	    return (NULL);
	}
	hostdata->hostaddr = NULL;
	hostdata->hostaddrp[0] = &(hostdata->hostaddr);
	hostdata->hostaddrp[1] = NULL;
	hostdata->host.h_addr_list = (char **)(hostdata->hostaddrp);
	hostdata->match_tmp = NULL;
	if (yp_get_default_domain(&hostdata->local_domain) != 0)
	    hostdata->local_domain = NULL;

	return hostdata;
}

static
sethostent()
{
	struct HostData *hd = _gethostdata();

	if (hd == NULL)
	    return (-1);
	if (hd->local_domain == NULL)
	    return (-1);
	if (hd->match_tmp != NULL) { /* free previous result */
            free(hd->match_tmp);
	    hd->match_tmp = NULL;
	}
	return (0);
}

struct hostent *
_tcpip_gethostbyname(name)
	char	*name;
{
	struct HostData *hd = _gethostdata();
	int match_len;

	if (sethostent() == -1)
	    return (NULL);
	if (yp_match(hd->local_domain, HOSTMAP_BYNAME, name,
		strlen(name), &hd->match_tmp, &match_len) != 0) {
	    return (NULL);
	}
	parse_host_match(hd->match_tmp, &hd->host);
	return (&hd->host);
}

struct hostent *
_tcpip_gethostbyaddr(addr, len, type)
	char	*addr;
	int	len, type;
{
	struct HostData *hd;
	int match_len;
	char *addr_str;

	/* Don't know about anything but inet yet */
	if ((len != 4) || (type != AF_INET))
		return NULL;
	hd = _gethostdata();
	if (sethostent() == -1)
	    return (NULL);
	addr_str = (char *)inet_ntoa((struct in_addr *)addr);

	if (yp_match(hd->local_domain, HOSTMAP_BYADDR, addr_str,
		strlen(addr_str), &hd->match_tmp, &match_len) != 0) {
	    return (NULL);
	}
	parse_host_match(hd->match_tmp, &hd->host);
	return (&hd->host);
}

static void
parse_host_match(field, he)
    char *field;
    struct hostent *he;
{
    char *bp;
    char **ap;

    bp = strtok(field, " \t");	    /* IP address */
    *(unsigned long *)he->h_addr_list[0] = inet_addr(bp);
    he->h_length = 4;
    he->h_name = strtok(NULL, " \t\n");	/* XXX check for null? */
    ap = he->h_aliases;
    do {
	bp = strtok(NULL, " \t\n");
	if (bp != NULL) {
	    if (*bp == '#') {
		bp = NULL;	    /* comment character; we're done */
	    }
	}
	*ap++ = bp;
    } while (bp != NULL);
}


static struct ServData {
		CLIENT *cl;
		struct servent	serv;
		char *local_domain;
		char *key_tmp;
		char *match_tmp;
		char token_tmp[YPMAXRECORD];
		} *_getservdata();

static struct ServData *
_getservdata()
{
static struct ServData *servdata;

	if (servdata)
		return servdata;

	servdata = (struct ServData *)calloc(1, sizeof(struct ServData));
	servdata->serv.s_aliases = (char **)malloc(MAXTOKENS*sizeof (char *));

	if (servdata == NULL || servdata->serv.s_aliases == NULL) {
	    return (NULL);
	}
	servdata->match_tmp = servdata->key_tmp = NULL;
	if (yp_get_default_domain(&servdata->local_domain) != 0)
	    servdata->local_domain = NULL;
	return servdata;
}

static setservent()
{
	struct ServData *sd = _getservdata();

	if (sd == NULL)
	    return (-1);
	if (sd->local_domain == NULL)
	    return (-1);
        if (sd->match_tmp != NULL) {	/* free previous match data */
	    free(sd->match_tmp);
            sd->match_tmp = NULL;
	}
        if (sd->key_tmp != NULL) {	/* free previous key data */
	    free(sd->key_tmp);
	    sd->key_tmp = NULL;
	}
	return  (0);
}


struct servent *
_tcpip_getservbyname(name, proto)
	char	*name;
	char	*proto;
{
	struct ServData *sd = _getservdata();
	int keylen, matchlen;
	char *last_key;
	char *bp;
	struct servent *se;

	if (setservent() == -1)
	    return (NULL);
	se = &sd->serv;

	if (yp_first(sd->local_domain, SERVMAP_BYNAME,
		&last_key, &keylen, &sd->match_tmp, &matchlen) != 0) {
	    return (NULL);
	}
	sd->key_tmp = strdup(last_key);
	do {
	    strcpy(sd->token_tmp, sd->match_tmp);
	    bp = strtok(sd->token_tmp, " \t");	/* official name */
	    bp = strtok(NULL, "/");	    /* eat the port field */
	    bp = strtok(NULL, " \t\n");	    /* check protocol */
	    if (proto != NULL && strcmp(bp, proto) != 0) {
		goto next;
	    }
	    if (strcmp(name, sd->token_tmp) == 0) {
	        parse_serv_match(sd->match_tmp, se);
		free(last_key);
	        return (se);
	    }
	    /* go through the aliases, if any */
	    while ((bp = strtok(NULL, " \t\n")) != NULL) {
		if (*bp == '#') {
		    break;	    /* comment character; we're done */
		}
		if (strcmp(name, bp) == 0) {
		    parse_serv_match(sd->match_tmp, se);
		    free(last_key);
		    return (se);
		}
	    }
next:	    free(last_key);
	    last_key = sd->key_tmp;
	    free(sd->match_tmp);
	} while (yp_next(sd->local_domain, SERVMAP_BYNAME, last_key, keylen,
		&sd->key_tmp, &keylen, &sd->match_tmp, &matchlen) == 0);
	free(last_key);
	sd->key_tmp = sd->match_tmp = NULL;
	return (NULL);
}

struct servent *
_tcpip_getservbyport(port, proto)
	int port;
	char *proto;
{
	struct ServData *sd = _getservdata();
	char servport[64];
	int keylen, matchlen;
	char *last_key;
	char *bp;

	struct servent *se;

	if (setservent() == -1)
	    return (NULL);

	se = &sd->serv;

	if (proto != NULL) {
	    sprintf(servport, "%d/%s", port, proto);
	    if (yp_match(sd->local_domain, SERVMAP_BYNAME, servport,
		    strlen(servport), &sd->match_tmp, &matchlen) != 0) {
		return (NULL);
	    } else {
		parse_serv_match(sd->match_tmp, se);
		return (se);
	    }
	}
	else {
	    if (yp_first(sd->local_domain, SERVMAP_BYNAME,
		    &last_key, &keylen, &sd->match_tmp, &matchlen) != 0) {
		return (NULL);
	    }
	    sd->key_tmp = strdup(last_key);
	    do {
		strcpy(sd->token_tmp, sd->match_tmp);
		bp = index(sd->token_tmp, '/');
		if (bp == NULL) {
		    goto nextkey;		/* bad key! */
		}
		*bp = '\0';
		if (atoi(sd->token_tmp) != port) {
		    goto nextkey;
		} else {
		    parse_serv_match(sd->match_tmp, se);
		    free(last_key);
		    return (se);
		}
nextkey:
		free(last_key);
		last_key = sd->key_tmp;
		free(sd->match_tmp);
	    } while (yp_next(sd->local_domain, SERVMAP_BYNAME,
		    last_key, keylen, &sd->key_tmp, &keylen,
		    &sd->match_tmp, &matchlen) == 0);
	    free(last_key);
	    sd->key_tmp = sd->match_tmp = NULL;
	}
	return (NULL);
}

static void
parse_serv_match(field, se)
char *field;
struct servent *se;
{
    char *bp;
    char **ap;

    se->s_name = strtok(field, " \t");
    bp = strtok(NULL, "/");
    se->s_port = atoi(bp);
    se->s_proto = strtok(NULL, " \t\n");
    ap = se->s_aliases;
    do {
	bp = strtok(NULL, " \t\n");
	if (bp != NULL) {
	    if (*bp == '#') {
		bp = NULL;	    /* comment character; we're done */
	    }
	}
	*ap++ = bp;
    } while (bp != NULL);
}
