/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user or with the express written consent of
 * Sun Microsystems, Inc.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
#if !defined(lint) && defined(SCCSIDS)
static  char sccsid[] = "@(#)tcpip_file.c	1.13 91/03/11 Copyright 1989,1990 Sun Microsystems";
#endif

/*
 * Copyright (c) 1989, 1990 by Sun Microsystems, Inc.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <string.h>
#include "table.h"

/*
 * table based gethostent routines ...
 *
 * NOTE: Only four routines in this file are not static:
 *	_tcpip_gethostbyname(),_tcpip_gethostbyaddr(),_tcpip_getservbyname(),
 *	_tcpip_getservbyport()
 *
 *  These routines are called from the transport specific routines in
 *  tcpip.c.
 *
 *  They use a generic table parsing facility.  See ../Tables
 */


extern char	*calloc();

static int parse_addr(), parse_name(), parse_port(),
	   compare(), compare_list(), compare_addr();

/*
 *  Routines for searching the services file.
 */

#define HOSTDB "/etc/hosts"

static struct HostData {
		long	ipdata;
		long	*addrptrs[2];
		FIELD	host_fields[3];
		TABLE	host_table;
		struct hostent	host;
		} *hostdata, *_gethostdata();

static struct HostData *
_gethostdata()
{
	if (hostdata)
		return hostdata;

	hostdata = (struct HostData *)calloc(1, sizeof(struct HostData));
	if (!hostdata) {
		return NULL;
	}
	hostdata->addrptrs[0] = &(hostdata->ipdata);
	hostdata->host.h_addr_list = (char **)(hostdata->addrptrs);

	/* The fields */
	strcpy(hostdata->host_fields[0].name, "address");
	hostdata->host_fields[0].index = 0;
	hostdata->host_fields[0].parse = parse_addr;
	hostdata->host_fields[0].result = (void *) &(hostdata->ipdata);
	strcpy(hostdata->host_fields[1].name, "Hostname");
	hostdata->host_fields[1].index = 1;
	hostdata->host_fields[1].parse = parse_name;
	hostdata->host_fields[1].result = (void *)(&(hostdata->host.h_name));
	strcpy(hostdata->host_fields[2].name, "Aliases");
	hostdata->host_fields[2].index = 2;
	hostdata->host_fields[2].parse = parse_name;
	hostdata->host_fields[2].result = (void *)(&(hostdata->host.h_aliases));

	/* The table */
	strcpy(hostdata->host_table.file, HOSTDB);
	strcpy(hostdata->host_table.brk, " \t,");
	hostdata->host_table.flags = TBF_MULTIVALUE,
	hostdata->host_table.n_fields = 2;
	hostdata->host_table.fields = hostdata->host_fields;

	return hostdata;
}

static sethostent(f)
	int	f;
{
	struct HostData *hd = _gethostdata();

	opentable(&(hd->host_table), f);
	return  0;
}

static struct hostent *
gethostent()
{
	struct HostData *hd = _gethostdata();

	if (readtable(&(hd->host_table)))
		return NULL;
	else
		return &(hd->host);
}

static endhostent()
{
	struct HostData *hd = _gethostdata();

	closetable(&(hd->host_table));
}

struct hostent *
_tcpip_gethostbyname(name)
	char	*name;
{
	struct hostent *he;
	char **aliases;

	sethostent(0);

	while ((he=gethostent()) != NULL) {
	    if (strcmp(he->h_name, name) == 0) {
		break;
	    }
	    for (aliases=he->h_aliases; *aliases != NULL; aliases++) {
		if (strcmp(*aliases, name) == 0)
		    goto foundit;
	    }
	}
foundit:
	endhostent();
	return (he);
}

struct hostent *
_tcpip_gethostbyaddr(addr, len, type)
	char	*addr;
	int	len, type;
{
	struct hostent *he;

	/* Don't know about anything but inet yet */
	if ((len != 4) || (type != AF_INET))
		return NULL;

	sethostent(0);

	while ((he=gethostent()) != NULL) {	/* XXX must check addr_list */
	    if (bcmp(he->h_addr, addr, 4) == 0)
		break;
	}
	endhostent();
	return (he);
}

/*
 * The support routines needed for the host table
 */

static int
parse_addr(data, deflt, result)
	char	*data;
	long 	*deflt;
	long 	*result;
{
	struct HostData *hd = _gethostdata();
	long	*addr;
	/* parsing and address */
	/* They aren't part of the host table yet, so we just initialize them */
	hd->host.h_length = 4;
	hd->host.h_addrtype = AF_INET;
	*result = inet_addr(data);
	return (*result != 0);
}

static int
parse_name(data, deflt, result)
	char	*data;
	char 	**deflt;
	char	**result;
{
	*result = data;
	return 1;
}


/*
 *  Routines for searching the services file.
 */

#define SERVDB "/etc/services"

static struct ServData {
		FIELD	serv_fields[3];
		TABLE	serv_table;
		struct servent	serv;
		} *servdata, *_getservdata();

static struct ServData *
_getservdata()
{
	if (servdata)
		return servdata;

	servdata = (struct ServData *)calloc(1, sizeof(struct ServData));
	if (!servdata) {
		return NULL;
	}

	/* The fields */
	strcpy(servdata->serv_fields[0].name, "Servicename");
	servdata->serv_fields[0].index = 0;
	servdata->serv_fields[0].parse = parse_name;
	servdata->serv_fields[0].result = (void *)(&(servdata->serv.s_name));
	strcpy(servdata->serv_fields[1].name, "port");
	servdata->serv_fields[1].index = 1;
	servdata->serv_fields[1].parse = parse_port;
	servdata->serv_fields[1].result = (void *) &(servdata->serv.s_port);
	strcpy(servdata->serv_fields[2].name, "protocol");
	servdata->serv_fields[2].index = 2;
	servdata->serv_fields[2].parse = parse_name;
	servdata->serv_fields[2].result = (void *) &(servdata->serv.s_proto);
	strcpy(servdata->serv_fields[3].name, "Aliases");
	servdata->serv_fields[3].index = 3;
	servdata->serv_fields[3].parse = parse_name;
	servdata->serv_fields[3].result= (void *)(&(servdata->serv.s_aliases));

	/* The table */
	strcpy(servdata->serv_table.file, SERVDB);
	strcpy(servdata->serv_table.brk, " \t,/");
	servdata->serv_table.flags = TBF_MULTIVALUE,
	servdata->serv_table.n_fields = 3;
	servdata->serv_table.fields = servdata->serv_fields;

	return servdata;
}

static setservent(f)
	int	f;
{
	struct ServData *hd = _getservdata();

	opentable(&(hd->serv_table), f);
	return  0;
}

static struct servent *
getservent()
{
	struct ServData *sd = _getservdata();

	if (readtable(&(sd->serv_table)))
		return NULL;
	else
		return &(sd->serv);
}

static endservent()
{
	struct ServData *sd = _getservdata();

	closetable(&(sd->serv_table));
}

struct servent *
_tcpip_getservbyname(name, proto)
	char	*name;
	char 	*proto;
{
	struct servent *se;
	char **aliases;

	setservent(0);

	while ((se=getservent()) != NULL) {
	    if (proto != NULL) {
		if (strcmp(se->s_proto, proto) != 0)
		    continue;
	    }
	    if (strcmp(se->s_name, name) == 0) {
		break;
	    }
	    for (aliases=se->s_aliases; *aliases != NULL; aliases++) {
		if (strcmp(*aliases, name) == 0)
		    goto foundsrv;
	    }
	}
foundsrv:
	endservent();
	return (se);
}

struct servent *
_tcpip_getservbyport(port, proto)
	int	port;
	char	*proto;
{
	struct servent *se;

	setservent(0);

	while ((se=getservent()) != NULL) {
	    if (proto != NULL) {
		if (strcmp(se->s_proto, proto) != 0)
		    continue;
	    }
	    if (se->s_port == port)
		    break;
	}
	endservent();
	return (se);
}


static int
parse_port(data, deflt, result)
	char	*data;
	char 	**deflt;
	int	*result;
{
	*result = atoi(data);
	return 1;
}
