/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user or with the express written consent of
 * Sun Microsystems, Inc.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
#if !defined(lint) && defined(SCCSIDS)
static  char sccsid[] = "@(#)tcpip.c	1.12 91/03/11 Copyright 1989,1990 Sun Microsystems";
#endif

/*
 * Copyright (c) 1989, 1990 by Sun Microsystems, Inc.
 */

/*
 * TCP/IP name to address translation routines. These routines are written
 * to the getXXXbyYYY() interface that the BSD routines use. (See the end of
 * this file.) This allows us to simply rewrite those routines to get
 * various flavors of translation routines. Thus while they look like they
 * have socket dependencies (the sockaddr_in structures) in fact this is
 * simply the internal netbuf representation that the TCP and UDP transport
 * providers use.
 */

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/sockio.h>
#include <netinet/in.h>
#include <netdb.h>
#include <tiuser.h>
#include <netconfig.h>
#include <netdir.h>
#include <string.h>
#include <fcntl.h>
#include <sys/param.h>
#include <sys/errno.h>
#include <sys/utsname.h>
#include <net/if.h>
#include <stropts.h>
#include <sys/ioctl.h>
#ifdef SYSLOG
#include <sys/syslog.h>
#else
#define LOG_ERR 3
#endif /* SYSLOG */

#ifndef TRUE
#define TRUE 1
#endif

/*
 * This is a gross way to determine whether we're on SunOS 4.1 or SVR4.
 */
#ifdef _nettli_tiuser_h		/* SunOS 4.1 */
#include <nettli/udp_tli.h>
#endif

extern char	*malloc(), *calloc();
static char	*print_addr();
extern struct in_addr inet_makeaddr();
extern int	_nderror;

static char 	*localaddr[] = {"\000\000\000\000", NULL};

static struct hostent localent = {
		"Localhost",
		NULL,
		AF_INET,
		4,
		localaddr
};
#define MAXBCAST	10

#ifdef undef
/*
 * XXX: May return more than one address. INADDR_BROADCAST used here
 */
static char 	*broadaddr[] = {"\377\377\377\377", NULL};

static struct hostent broadent = {
		"broadcast",
		NULL,
		AF_INET,
		4,
		broadaddr
};
#endif

/*
 * This file is linked with an address resolver file which will do the
 * name lookup.  The routines called below invoke the resolver routine
 * to which we're linked.
 */

extern struct hostent *_tcpip_gethostbyname(), *_tcpip_gethostbyaddr();
extern struct servent *_tcpip_getservbyname(), *_tcpip_getservbyport();

/*
 * This routine is the "internal" TCP/IP routine that will build a
 * host/service pair into one or more netbufs depending on how many
 * addresses the host has in the host table.
 * If the hostname is HOST_SELF, we return 0.0.0.0 so that the
 * binding can be contacted through all interfaces.
 * If the hostname is HOST_ANY, we return no addresses because IP doesn't
 * know how to specify a service without a host.
 * And finally if we specify HOST_BROADCAST then we ask a tli fd to tell
 * us what the broadcast addresses are for any udp interfaces on this
 * machine.
 */
struct nd_addrlist *
#ifdef SHARED_LIBS
_netdir_getbyname(tp, serv)
#else
tcp_netdir_getbyname(tp, serv)
#endif
	struct netconfig *tp;
	struct nd_hostserv *serv;
{
	struct hostent	*he;
	struct hostent	h_broadcast;
	struct nd_addrlist *result;
	struct netbuf	*na;
	char		**t;
	struct sockaddr_in	*sa;
	int		num;
	int		server_port;
	char		*baddrlist[MAXBCAST + 1];
	struct in_addr	inaddrs[MAXBCAST];

	fprintf(stderr, "");

	if (!serv || !tp) {
		_nderror = ND_BADARG;
		return (NULL);
	}

	_nderror = ND_OK;	/* assume success */

	/* NULL is not allowed, that returns no answer */
	if (! (serv->h_host)) {
		_nderror = ND_NOHOST;
		return (NULL);
	}

	if (strcmp(serv->h_host, HOST_ANY) == 0) {
		result = (struct nd_addrlist *)
			(malloc(sizeof (struct nd_addrlist)));
		result->n_cnt = 0;
		result->n_addrs = NULL;
		return (result);
	}

	/*
	 * Find the port number for the service. If the service is
	 * not found, check for some special cases. These are :
	 * 	NULL - 0 port number.
	 *	rpcbind - The portmapper's address
	 *	A number - We don't have a name just a number so use it
	 */
	if (!(serv->h_serv)) {
		server_port = htons(0);
	} else if (strcmp(serv->h_serv, "rpcbind") == 0) {
#ifdef DEBUG
fprintf(stderr, "n2a: service is rpcbind\n");
#endif
		server_port = htons(111);	/* Hard coded */
	} else if (strspn(serv->h_serv, "0123456789")
			== strlen(serv->h_serv)) {
		/* It's a port number */
		server_port = htons(atoi(serv->h_serv));
	} else {
		struct servent	*se;

#ifdef DEBUG
fprintf(stderr, "n2a: service lookup for %s\n", serv->h_serv);
#endif
		se = _tcpip_getservbyname(serv->h_serv,
			(strcmp(tp->nc_proto, NC_TCP) == 0) ? "tcp" : "udp");

		if (!se) {
			_nderror = ND_NOSERV;
			return (NULL);
		}
		server_port = se->s_port;
	}


	if (!strcmp(serv->h_host, HOST_SELF)) {
		he = &localent;
	} else if ((strcmp(serv->h_host, HOST_BROADCAST) == 0)) {
		int bnets, i;

		memset((char *)inaddrs, 0, sizeof(struct in_addr) * MAXBCAST);
		bnets = getbroadcastnets(tp, inaddrs);
		if (bnets == 0) {
			/* _nderror is set by the routine getbroadcastnets */
			return (NULL);
		}
		he = &h_broadcast;
		he->h_name = "broadcast";
		he->h_aliases = NULL;
		he->h_addrtype = AF_INET;
		he->h_length = 4;
		for (i = 0; i < bnets; i++)
			baddrlist[i] = (char *)&inaddrs[i];
		baddrlist[i] = NULL;
		he->h_addr_list = baddrlist;
	} else {
		he = (struct hostent *)_tcpip_gethostbyname(serv->h_host);
	}

	if (!he) {
		_nderror = ND_NOHOST;
		return (NULL);
	}

	result = (struct nd_addrlist *)(malloc(sizeof (struct nd_addrlist)));
	if (!result) {
		_nderror = ND_NOMEM;
		return (NULL);
	}

	/* Count the number of addresses we have */
	for (num = 0, t = he->h_addr_list; *t; t++, num++)
			;

	result->n_cnt = num;
	result->n_addrs = (struct netbuf *)
				(calloc(1, num * sizeof(struct netbuf)));
	if (!result->n_addrs) {
		free(result);
		_nderror = ND_NOMEM;
		return (NULL);
	}

	/* build up netbuf structs for all addresses */
	for (na = result->n_addrs, t = he->h_addr_list; *t; t++, na++) {
		sa = (struct sockaddr_in *)calloc(1, sizeof (*sa));
		if (!sa) {
			for (--na; na > result->n_addrs; --na)
			    free(na->buf);
			free(result->n_addrs);
			free(result);
			_nderror = ND_NOMEM;
			return (NULL);
		}
		/* Vendor specific, that is why it's here and hard coded */
		na->maxlen = sizeof (struct sockaddr_in);
		na->len = sizeof (struct sockaddr_in);
		na->buf = (char *)sa;
		sa->sin_family = AF_INET;
		sa->sin_port = server_port;
		sa->sin_addr = *((struct in_addr *)(*t));
	}

	return (result);
}

/*
 * This routine is the "internal" TCP/IP routine that will build a
 * host/service pair from the netbuf passed. Currently it only
 * allows one answer, it should, in fact allow several.
 */
struct nd_hostservlist *
#ifdef SHARED_LIBS
_netdir_getbyaddr(tp, addr)
#else
tcp_netdir_getbyaddr(tp, addr)
#endif
	struct netconfig	*tp;
	struct netbuf		*addr;
{
	struct sockaddr_in	*sa;		/* TCP/IP temporaries */
	struct servent		*se;
	struct hostent		*he;
	struct nd_hostservlist	*result;	/* Final result		*/
	struct nd_hostserv	*hs;		/* Pointer to the array */
	int			servs, hosts;	/* # of hosts, services */
	char			**hn, **sn;	/* host, service names */
	int			i, j;		/* some counters	*/

	if (!addr || !tp) {
		_nderror = ND_BADARG;
		return (NULL);
	}

	_nderror = ND_OK; /* assume success */

	/* XXX how much should we trust this ? */
	sa = (struct sockaddr_in *)(addr->buf);

	/* first determine the host */
	if (bcmp(&sa->sin_addr, localent.h_addr_list[0],
		sizeof (struct in_addr)) == 0) {
	    he = &localent;
	} else {
	    he = _tcpip_gethostbyaddr(&(sa->sin_addr.s_addr),
			4, sa->sin_family);
	    if (!he) {
		_nderror = ND_NOHOST;
		return (NULL);
	    }
	}
	/* Now determine the service */
	if (sa->sin_port == 0) {
		/*
		 * The port number 0 is a reserved port for both UDP & TCP.
		 * We are assuming that this is used to just get
		 * the host name and to bypass the service name.
		 */
		servs = 1;
		se = NULL;
	} else {
		se = _tcpip_getservbyport(sa->sin_port,
			(strcmp(tp->nc_proto, NC_TCP) == 0) ? "tcp" : "udp");
		if (!se) {
			/* It is not a well known service */
			servs = 1;
		}
	}

	/* now build the result for the client */
	result = (struct nd_hostservlist *)
			malloc(sizeof(struct nd_hostservlist));
	if (!result) {
		_nderror = ND_NOMEM;
		return (NULL);
	}

	/* 
	 * We initialize the counters to 1 rather than zero because
	 * we have to count the "official" name as well as the aliases.
	 */
	for (hn = he->h_aliases, hosts = 1; hn && *hn; hn++, hosts++)
		;

	if (se)
		for (sn = se->s_aliases, servs = 1; sn && *sn; sn++, servs++)
			;

	hs = (struct nd_hostserv *)calloc(hosts * servs,
		sizeof(struct nd_hostserv));
	if (!hs) {
		_nderror = ND_NOMEM;
		free((char *)result);
		return (NULL);
	}

	result->h_cnt	= servs * hosts;
	result->h_hostservs = hs;

	/* Now build the list of answers */

	for (i = 0, hn = he->h_aliases; i < hosts; i++) {
		sn = se ? se->s_aliases : NULL;

		for (j = 0; j < servs; j++) {
			if (! i)
				hs->h_host = strdup(he->h_name);
			else
				hs->h_host = strdup(*hn);
			if (! j) {
				if (se) {
					hs->h_serv = strdup(se->s_name);
				} else {
					/* Convert to a number string */
					char stmp[16];

					sprintf(stmp, "%d", sa->sin_port);
					hs->h_serv = strdup(stmp);
				}
			} else {
				hs->h_serv = strdup(*sn++);
			}

			if (!(hs->h_host) || !(hs->h_serv)) {
				_nderror = ND_NOMEM;
				free((char *)result->h_hostservs);
				free((char *)result);
				return (NULL);
			}
			hs ++;
		}
		if (i)
			hn++;
	}

	return (result);
}

/*
 * This internal routine will merge one of those "universal" addresses
 * to the one which will make sense to the remote caller.
 */
static char *
_netdir_mergeaddr(tp, ruaddr, uaddr)
	struct netconfig	*tp;	/* the transport provider */
	char			*ruaddr;/* remote uaddr of the caller */
	char			*uaddr;	/* the address */
{
	static char		**addrlist = NULL;
	char			tmp[32], nettmp[32];
	char			*hptr, *netptr, *portptr;
	int			i;
	int			index = 0, level = 0;

#define	MAXIFS			32	/* maximum # of interfaces */

	if (!uaddr || !ruaddr || !tp) {
		_nderror = ND_BADARG;
		return ((char *)NULL);
	}
#ifdef DEBUG
fprintf(stderr, "\nruaddr: %s uaddr: %s tp->netid: %s\n", ruaddr, uaddr,
    tp->nc_netid);
#endif
	if (strncmp(ruaddr, "0.0.0.0.", sizeof ("0.0.0.0.") - 1) == 0) {
		/* that's me: return the way it is */
		_nderror = ND_OK;
		return (strdup(uaddr));
	}
	if (addrlist == (char **)NULL) {
		struct ifreq		iface_buf[MAXIFS];
		struct ifreq		*ifaces;
		struct ifconf		iface_config;
		struct sockaddr_in	*iface_sin;
		int	n, s;

		if ((s = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
			_nderror = ND_SYSTEM;
			return ((char *)NULL);
		}
		iface_config.ifc_buf = (caddr_t)&iface_buf[0];
		iface_config.ifc_len = sizeof (iface_buf);

		if (ioctl(s, SIOCGIFCONF, (caddr_t)&iface_config) < 0) {
			_nderror = ND_SYSTEM;
			return ((char *)NULL);
		}
		/* make a list of all the legal host addrs */
		i = iface_config.ifc_len / sizeof (struct ifreq);
		if (i == 0) {
			_nderror = ND_NOHOST;
			return ((char *)NULL);
		}
		addrlist = (char **)malloc(sizeof (char *) * (i + 1));
		if (addrlist == NULL) {
			_nderror = ND_NOMEM;
			return ((char *)NULL);
		}
		addrlist[i--] = NULL;
		for (n = 0, ifaces=iface_config.ifc_req; n < i;
				n++, ifaces++) {
			iface_sin = (struct sockaddr_in *) &ifaces->ifr_addr;
			addrlist[n] = strdup(inet_ntoa(iface_sin->sin_addr));
#ifdef DEBUG
fprintf(stderr, "addrlist[%d]: %s\n", n, addrlist[n]);
#endif
		}
		close(s);
	}

	if (addrlist[1] == NULL) {
		/* Only one address. So, dont compare */
		index = 0;
		goto reply;
	}
	/* Get the host part of the remote uaddress assuming h.h.h.h.p.p */
	/* XXX: May be there is a better way of doing all this */
	(void) strcpy(tmp, ruaddr);
	for (hptr = tmp, i = 0; i < 4; i++) {
		hptr = strchr(hptr, '.');
		hptr++;
	}
	*(hptr - sizeof (char)) = NULL;

	/* class C networks - for gateways the common address is h.h.h */
	/* class B networks - for gateways the common address is h.h */
	/* class A networks - for gateways the common address is h */
	(void) strcpy(nettmp, tmp);
	netptr = strrchr(nettmp, '.');
	*netptr = NULL;
	netptr = nettmp;

	/* Compare and get the right one */
	for (i = 0; addrlist[i]; i++) {
		char *t1, *t2;

		if (strcmp(tmp, addrlist[i]) == 0) {
#ifdef DEBUG
fprintf(stderr, "merge: returning uaddr: %s\n", uaddr);
#endif
			return (strdup(uaddr)); /* the same one */
		}
		if (strncmp(netptr, addrlist[i], strlen(netptr)) == 0) {
			index = i;
			level = 3;
			break; /* A hit */
		}
		t1 = strrchr(netptr, '.');
		*t1 = NULL;
		if (strncmp(netptr, addrlist[i], strlen(netptr)) == 0) {
			index = i;
			level = 2;
			*t1 = '.';
			continue; /* A partial hit */
		}
		t2 = strrchr(netptr, '.');
		*t2 = NULL;
		if (strncmp(netptr, addrlist[i], strlen(netptr)) == 0) {
			if (level < 1) {
				index = i;
				level = 1;
			}
			*t1 = '.';
			*t2 = '.';
			continue; /* A partial hit */
		}
		*t1 = '.';
		*t2 = '.';
	}
reply:
	/* Get the port number */
	for (portptr = uaddr, i = 0; i < 4; i++) {
		portptr = strchr(portptr, '.');
		portptr++;
	}
	sprintf(tmp, "%s.%s", addrlist[index], portptr);
	_nderror = ND_OK;
#ifdef DEBUG
fprintf(stderr, "merge: returning: %s\n", tmp);
#endif
	return (strdup(tmp));
}

int
#ifdef SHARED_LIBS
_netdir_options(tp, opts, fd, par)
#else
tcp_netdir_options(tp, opts, fd, par)
#endif
	struct netconfig *tp;
	int opts;
	int fd;
	char *par;
{
	struct t_optmgmt *options;
	struct t_optmgmt *optionsret;
#ifdef _nettli_tiuser_h		/* SunOS 4.1 */
	struct tt_soopt *udpopt;
#endif /* _nettli_tiuser_h */
	struct nd_mergearg *ma;

	switch (opts) {
	case ND_SET_BROADCAST:
		/* enable for broadcasting */
	    options = (struct t_optmgmt *)t_alloc(fd, T_OPTMGMT, 0);
	    if (options == (struct t_optmgmt *)NULL) {
		_nderror = ND_NOMEM;
		return (1);
	    }
	    optionsret = (struct t_optmgmt *)t_alloc(fd, T_OPTMGMT, T_OPT);
	    if (options == (struct t_optmgmt *)NULL) {
		_nderror = ND_NOMEM;
		return (1);
	    }
#ifdef _nettli_tiuser_h
	    options->opt.len = 0;
	    options->opt.buf = NULL;
	    options->flags = T_DEFAULT;
	    if (t_optmgmt(fd, options, optionsret) == -1) {
		return(_nderror = ND_SYSTEM);
	    }
	    udpopt = (struct tt_soopt *)optionsret->opt.buf;
	    udpopt->tts_broadcast = TRUE;   /* enbable broadcasts */
	    options->opt.buf = (char *)udpopt;
	    options->opt.len = sizeof (struct tt_soopt);
	    options->flags = T_NEGOTIATE;
	    if (t_optmgmt(fd, options, optionsret) == -1) {
		/*
		 * maybe shouldn't quit  if some transports just let you
		 * broadcast.
		 */
	    }
#endif /* _nettli_tiuser_h */
	    options->opt.buf = 0;
	    (void) t_free((char *)options, T_OPTMGMT);
	    (void) t_free((char *)optionsret, T_OPTMGMT);
	    return (_nderror = ND_OK);
	case ND_SET_RESERVEDPORT:	/* bind to a resered port */
		return (bindresvport(fd, (struct netbuf *)par));
	case ND_CHECK_RESERVEDPORT:	/* check if reserved prot */
		return (checkresvport((struct netbuf *)par));
	case ND_MERGEADDR:	/* Merge two addresses */
		ma = (struct nd_mergearg *)(par);
		ma->m_uaddr = _netdir_mergeaddr(tp, ma->c_uaddr, ma->s_uaddr);
		return(_nderror);
	default:
		return (_nderror = ND_NOCTRL);
	}
}

	
/* 
 * This internal routine will convert a TCP/IP internal format address
 * into a "universal" format address. In our case it prints out the
 * decimal dot equivalent. h1.h2.h3.h4.p1.p2 where h1-h4 are the host
 * address and p1-p2 are the port number.
 */
char *
#ifdef SHARED_LIBS
_taddr2uaddr(tp, addr)
#else
tcp_taddr2uaddr(tp, addr)
#endif
	struct netconfig	*tp;	/* the transport provider */
	struct netbuf		*addr;	/* the netbuf struct */
{
	struct sockaddr_in	*sa;	/* our internal format */
	char			tmp[32];
	unsigned short		myport;

	if (!addr || !tp) {
		_nderror = ND_BADARG;
		return (NULL);
	}
	sa = (struct sockaddr_in *)(addr->buf);
	myport = ntohs(sa->sin_port);
	sprintf(tmp,"%s.%d.%d", print_addr((long)sa->sin_addr.s_addr),
			myport >> 8, myport & 255);
	_nderror = ND_OK;
	return (strdup(tmp));
}

/* 
 * This internal routine will convert one of those "universal" addresses
 * to the internal format used by the Sun TLI TCP/IP provider. 
 */

struct netbuf *
#ifdef SHARED_LIBS
_uaddr2taddr(tp, addr)
#else
tcp_uaddr2taddr(tp, addr)
#endif
	struct netconfig	*tp;	/* the transport provider */
	char			*addr;	/* the address 		 */
{
	struct sockaddr_in	*sa;
	unsigned long		inaddr;
	unsigned short		inport;
	int			h1, h2, h3, h4, p1, p2;
	struct netbuf		*result;

	if (!addr || !tp) {
		_nderror = ND_BADARG;
		return (0);
	}
	result = (struct netbuf *) malloc(sizeof(struct netbuf));
	if (!result) {
		_nderror = ND_NOMEM;
		return (0);
	}

	sa = (struct sockaddr_in *)calloc(1, sizeof (*sa));
	if (!sa) {
		free((char *)result);		/* free previous result */
		_nderror = ND_NOMEM;
		return (0);
	}
	result->buf = (char *)(sa);
	result->maxlen = sizeof (struct sockaddr_in);
	result->len = sizeof (struct sockaddr_in);

	/* XXX there is probably a better way to do this. */
	sscanf(addr,"%d.%d.%d.%d.%d.%d", &h1, &h2, &h3, &h4, &p1, &p2);
	
	/* convert the host address first */
	inaddr = (h1 << 24) + (h2 << 16) + (h3 << 8) + h4;
	sa->sin_addr.s_addr = htonl(inaddr);
	
	/* convert the port */
	inport = (p1 << 8) + p2;
	sa->sin_port = htons(inport);

	sa->sin_family = AF_INET;
	
	_nderror = ND_OK;
	return (result);
}

static char *
print_addr(a)
	long	a;
{
	int	i, h[4];
	long	foo;
	static char	buf[30];

	foo = htonl(a);
	for (i=0; i<4; i++) {
		h[i] = 0xff & (foo >> ((3-i) * 8));
	}

	sprintf(buf, "%d.%d.%d.%d", h[0], h[1], h[2], h[3]);
	return (buf);
}


#define UDPMSGSIZE       8800    /* rpc imposed limit on udp msg size */

static int
getbroadcastnets(tp, addrs)
	struct netconfig *tp;
	struct in_addr *addrs;
{
	struct ifconf ifc;
	struct ifreq ifreq, *ifr;
	struct sockaddr_in *sin;
	int sock;
    	int n, i;
    	char buf[UDPMSGSIZE];

	_nderror = ND_SYSTEM;
	sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
	if (sock < 0) {
		(void) syslog(LOG_ERR, "broadcast: ioctl (get socket): %m");
		return (0);
	}
	ifc.ifc_len = UDPMSGSIZE;
	ifc.ifc_buf = buf;
	if (ioctl(sock, SIOCGIFCONF, (char *)&ifc, UDPMSGSIZE) < 0) {
		(void) syslog(LOG_ERR, "broadcast: ioctl (get interface configuration): %m");
		(void)close(sock);
		return (0);
	}
	ifr = ifc.ifc_req;
	for (i = 0, n = ifc.ifc_len/sizeof (struct ifreq);
		n > 0 && i < MAXBCAST; n--, ifr++) {
		ifreq = *ifr;
		if (ioctl(sock, SIOCGIFFLAGS, (char *)&ifreq) < 0) {
			(void) syslog(LOG_ERR, "broadcast: ioctl (get interface flags): %m");
			continue;
		}
		if ((ifreq.ifr_flags & IFF_BROADCAST) &&
		    (ifreq.ifr_flags & IFF_UP) &&
		    (ifr->ifr_addr.sa_family == AF_INET)) {
			sin = (struct sockaddr_in *)&ifr->ifr_addr;
			if (ioctl(sock, SIOCGIFBRDADDR, (char *)&ifreq) < 0) {
				/* May not work with other implementation */
				addrs[i++] = inet_makeaddr(inet_netof
					(sin->sin_addr.s_addr), INADDR_ANY);
			} else {
				addrs[i++] = ((struct sockaddr_in*)
						&ifreq.ifr_addr)->sin_addr;
			}
		}
	}
	(void)close(sock);
	if (i)
		_nderror = ND_OK;
	return (i);
}

static
bindresvport(fd, addr)
	int fd;
	struct netbuf *addr;
{
	int res;
	static short port;
	struct sockaddr_in myaddr;
	struct sockaddr_in *sin;
	extern int errno;
	extern int t_errno;
	int i;
	struct t_bind *tbind, *tres;

#define STARTPORT 600
#define ENDPORT (IPPORT_RESERVED - 1)
#define NPORTS	(ENDPORT - STARTPORT + 1)

	if (geteuid()) {
		errno = EACCES;
		return (_nderror = ND_SYSTEM);
	}
	if ((i = t_getstate(fd)) != T_UNBND) {
		if (t_errno == TBADF)
			errno = EBADF;
		if (i != -1)
			errno = EISCONN;
		return (_nderror = ND_SYSTEM);
	}
	if (addr == NULL) {
		sin = &myaddr;
		(void)memset((char *)sin, 0, sizeof (*sin));
		sin->sin_family = AF_INET;
	} else {
		sin = (struct sockaddr_in *)addr->buf;
		if (sin->sin_family != AF_INET) {
			errno = EPFNOSUPPORT;
			return (_nderror = ND_SYSTEM);
		}
	}
	if (port == 0)
		port = (getpid() % NPORTS) + STARTPORT;
	res = -1;
	errno = EADDRINUSE;
	/* Transform sockaddr_in to netbuf */
	tbind = (struct t_bind *)t_alloc(fd, T_BIND, T_ADDR);
	if (tbind == NULL) {
		if (t_errno == TBADF)
			errno = EBADF;
		return (_nderror = ND_NOMEM);
	}
	tres = (struct t_bind *)t_alloc(fd, T_BIND, T_ADDR);
	if (tres == NULL) {
		(void) t_free((char *)tbind, T_BIND);
		return (_nderror = ND_NOMEM);
	}

	/*
	 * XXX: Always qlen of 0; user should change if he wants to
	 * and t_unbind and t_bind again with the same address.
	 */
	tbind->qlen = 0;
	(void) memcpy(tbind->addr.buf, (char *)sin, (int)tbind->addr.maxlen);
	tbind->addr.len = tbind->addr.maxlen;
	sin = (struct sockaddr_in *)tbind->addr.buf;

	for (i = 0; i < NPORTS && errno == EADDRINUSE; i++) {
		sin->sin_port = htons(port++);
		if (port > ENDPORT)
			port = STARTPORT;
		res = t_bind(fd, tbind, tres);
		if ((res == 0) && (memcmp(tbind->addr.buf, tres->addr.buf,
					(int)tres->addr.len) == 0))
			break;
	}

	(void) t_free((char *)tbind, T_BIND);
	(void) t_free((char *)tres, T_BIND);
	if (i != NPORTS) {
		return (_nderror = ND_OK);
	} else {
		return (_nderror = ND_FAILCTRL);
	}
}

static
checkresvport(addr)
	struct netbuf *addr;
{
	struct sockaddr_in *sin;

	if (addr == NULL) {
		return (_nderror = ND_FAILCTRL);
	}
	sin = (struct sockaddr_in *)addr->buf;
	if (sin->sin_port < IPPORT_RESERVED)
		return (_nderror = ND_OK);
	/*
	 * XXX ND_FAILCTRL is now overloaded.  Ideally, there should be a
	 * different return number.
	 */
	return (_nderror = ND_FAILCTRL);
}


