%/*
% * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
% * unrestricted use provided that this legend is included on all tape
% * media and as a part of the software program in whole or part.  Users
% * may copy or modify Sun RPC without charge, but are not authorized
% * to license or distribute it to anyone else except as part of a product or
% * program developed by the user or with the express written consent of
% * Sun Microsystems, Inc.
% *
% * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
% * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
% * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
% *
% * Sun RPC is provided with no support and without any obligation on the
% * part of Sun Microsystems, Inc. to assist in its use, correction,
% * modification or enhancement.
% *
% * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
% * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
% * OR ANY PART THEREOF.
% *
% * In no event will Sun Microsystems, Inc. be liable for any lost revenue
% * or profits or other special, indirect and consequential damages, even if
% * Sun has been advised of the possibility of such damages.
% *
% * Sun Microsystems, Inc.
% * 2550 Garcia Avenue
% * Mountain View, California  94043
% */
/* @(#)whoami.x	2.4 91/03/11 4.0 RPCSRC */

const WHOAMI_NGROUPS = 16;

typedef string  name<MAXNETNAMELEN>;

struct remote_identity {
    bool authenticated;     /* TRUE if the server authenticates us */
    name remote_username;   /* login name */
    name remote_realname;   /* gcos-field name (long name) */
    int uid;
    int gid;
    int gids<WHOAMI_NGROUPS>;
};

program WHOAMI {
    version WHOAMI_V1 {
        /*
         * Report on the server's notion of the client's identity.
         * Will respond to AUTH_DES only.
         */
        remote_identity
        WHOAMI_IASK(void) = 1;
        /*
         * Return server's netname. AUTH_NONE is okay.
         * This routine allows this server to be started under any uid,
         * and the client can ask it its netname for use in authdes_create().
         */
        name
        WHOAMI_WHORU(void) = 2;

    } = 1;
} = 0x20080955;
