/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user or with the express written consent of
 * Sun Microsystems, Inc.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
#if defined(LIBC_SCCS) && !defined(lint)
static char sccsid[] = 	"@(#)rme.c	2.5 91/03/11 1.0 TIRPC";
#endif
/*
 * rme.c: secure identity verifier and reporter: client side
 */
#include <rpc/rpc.h>
#include <stdio.h>
#include "whoami.h"

/*
 * Before running this program, the user must have a key in the publickey
 * database, and must have logged in with a password (or used keylogin).
 * The user's machine and the server's machine must both be running keyserv.
 */

main(argc, argv)
	int argc;
	char *argv[];
{
	CLIENT *cl;
	char *server;
	remote_identity *remote_me;
	name *servername;
	void *nullp;

	if (argc != 2) {
		fprintf(stderr, "usage: %s host\n", argv[0]);
		exit(1);
	}

	/*
	 * Remember what our command line argument refers to
	 */
	server = argv[1];

	/*
	 * Create client "handle" used for calling WHOAMI on the
	 * server designated on the command line. We tell the rpc package
	 * to use any visible datagram protocol when contacting the server.
	 */
	cl = clnt_create(server, WHOAMI, WHOAMI_V1, "datagram_v");
	if (cl == NULL) {
		/*
		 * Couldn't establish connection with server.
		 * Print error message and die.
		 */
		clnt_pcreateerror(server);
		exit(1);
	}
    /*
     * Get network identifier for server machine.
     */
    servername = whoami_whoru_1(nullp, cl);
    if (servername == NULL)
    {
        fprintf(stderr, "Trouble communicating with %s\n",
            clnt_sperror(cl, server));
        exit(1);
    }
    else if (*servername[0] == '\0')
    {
        fprintf(stderr, "Could not determine netname of WHOAMI server.\n");
        exit(1);
    }
    printf("Server's netname is: %s\n", *servername);

    /*
     * A wide window and no synchronization is used.  Client and server
     * clock must be with five minutes of each other.
     */
    if ((cl->cl_auth = authdes_create(*servername, 300, NULL, NULL)) == NULL)
    {
        fprintf(stderr, "Could not establish DES credentials of netname %s\n",
            servername);
        exit(1);
    }

    /*
     *  Find out who I am, in the server's point of view.
     */
    remote_me = whoami_iask_1(nullp, cl);
    if (remote_me == NULL)
    {
        fprintf(stderr, "Trouble getting my identity from %s\n",
            clnt_sperror(cl, server));
        exit(1);
    }
    /*
     * Print out my identity.
     */
    printf("My remote user name: %s\n", remote_me->remote_username);
    printf("My remote real name: %s\n", remote_me->remote_realname);

    exit(0);
}
