/* @(#)mandel_init.c	1.4 91/03/11 TIRPC 1.0 */
/*
 * file : mandel_init.c
 */
/* 
 *
 * MultiMandel was written by Carsten Ruseng Jakobsen, Ida Marie
 * Jensen, Thim Otskov, Claus Priisholm and Jeppe Sommer at the
 * University of Aalborg in Denmark spring 1989, and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.
 * Users may copy or modify MultiMandel without charge, but are not
 * authorized to license or distribute it to anyone else except as
 * part of a product or program developed by the user.
  
 * MultiMandel IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND
 * INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR
 * TRADE PRACTICE.
 * 
 * MultiMandel is provided with no support and without any obligation
 * on the part of the authors, to assist in its use, correction,
 * modification or enhancement.
 * 
 * THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY
 * MultiMandel OR ANY PART THEREOF.
 * 
 * In no event will the authors and/or University of Aalborg be liable
 * for any lost revenue or profits or other special, indirect and
 * consequential damages, even if the authors and/or University of
 * Aalborg has been advised of the possibility of such damages.
 * 
 * University of Aalborg
 * Strandvejen 19
 * 9000 Aalborg
 * Denmark
 */

#include <stdio.h>
#include <math.h>

#include <sys/fcntl.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <memory.h>

#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <suntool/panel.h>
#include <suntool/icon.h>
#include <pixrect/pixrect_hs.h>

#include <rpc/rpc.h>
#include "mandel_rpc.h"
#include "mandel_init.h"

/*
Icon icon;
static short icon_image[] = {
#include "mandel_icon"
};
mpr_static(icon_mandel, 64, 64, 1, icon_image);
*/

static void repaint_mandel(),
    reset_proc(),
    draw_proc(), 
    cycle_proc(),
    resolution_proc(),
    zoom_mode_proc(),
    cycle_mode_proc(),
    zoom_factor_proc(),
    zoom_proc(),
    depth_mode_proc(),
    quit_proc();


Task task[MAX_SVR];
Reply r_buf;
Assignment a_buf; 

Window frame, panel;
Canvas canvas;
Panel_item fname_item;
Pixfont *small_font[2];

u_char red[MAX_CELLS], green[MAX_CELLS], blue[MAX_CELLS];

Pixrect *all_pr;
Pixwin *pw;
MandelCT gct, job_table[MAX_JOBS];

double zoom_factor = 5.0;
int zoom_in= TRUE;
int cycle_in= TRUE;
Server server_table[MAX_SVR];
int no_servers;
int recalc;

extern int errno;

main(argc,argv)
char **argv;
int argc;
{
    register int i;
    int r, g, b;
    char line[80];
    FILE *name_fp, *fp, *fopen();
    
    if( argc!= 2)
    {
	fprintf(stderr,"usage: %s listfile\n",argv[0]);
	exit(1);
    }
    
    if( (name_fp = fopen(argv[1],"r"))== NULL)
    {
	fprintf(stderr,"File %s does not exist!\n",argv[1]);
	exit(1);
    }
    
    no_servers= 0;
    
    while(fscanf(name_fp,"%s \n",server_table[no_servers++].name)!= EOF) ;
    close(name_fp);
    --no_servers;
    
    reset_proc();

    if( (small_font[0]= pf_open(SMALL_FONT)) == NULL)
    {
	fprintf(stderr,"Cant locate font %s\n",SMALL_FONT);
	exit(1);
    }
    if( (small_font[1]= pf_open(MEDIUM_FONT)) == NULL)
    {
	fprintf(stderr,"Cant locate font %s\n",MEDIUM_FONT);
	exit(1);
    }


/*
    icon= icon_create(ICON_IMAGE, &icon_mandel, 0);
*/
    frame = window_create(NULL,FRAME,
			  FRAME_ARGS,argc,argv,
			  FRAME_LABEL,"Mandel - S8D Gr. 303 1989",
			/*FRAME_ICON, icon,*/
			  WIN_HEIGHT, MANDEL_SIZE+100,
			  WIN_WIDTH, MANDEL_SIZE+10,
			  0);

    panel = window_create(frame,PANEL,0);
    create_panel_items();
    
    canvas = window_create(frame,CANVAS,
			   WIN_HEIGHT, MANDEL_SIZE,
			   WIN_WIDTH,  MANDEL_SIZE,
			   CANVAS_RETAINED, FALSE,
			   CANVAS_FIXED_IMAGE, FALSE,
			   CANVAS_REPAINT_PROC, repaint_mandel,
			   0);
    window_set(canvas,
	       CANVAS_AUTO_SHRINK, TRUE,
	       CANVAS_AUTO_EXPAND, TRUE,
	       0);
    
    pw = canvas_pixwin(canvas);

    /*
     * Open a memory image for storing total window.
     */
    recalc= TRUE;
    if(gct.cms_size== 2)
	/* Monochrome monitor */
	all_pr = mem_create(gct.width,gct.height, 1);
    else
	/* Less monochrome monitor */
	all_pr = mem_create(gct.width,gct.height, 8);

    if(pw->pw_pixrect->pr_depth >1)
    {
	if((fp=fopen("./rgb.txt","r"))==NULL) {
	    fprintf(stderr,"Can't open ./rgb.txt");
	    exit(1);
	}
	gct.cms_size= 0;
	
	while(fgets(line,sizeof(line),fp)) {
	    sscanf(line,"%d %d %d \n", &r,&g,&b);
	    red[gct.cms_size]= (u_char)r;
	    green[gct.cms_size]= (u_char)g;
	    blue[gct.cms_size]= (u_char)b;
	    ++gct.cms_size;
	}
	fclose(fp);
    }
    else 
    {
	red[0]= green[0]= blue[0]= 0;
	red[1]= green[1]= blue[1]= 256;
	gct.cms_size= 2;
    }
    
    pw_setcmsname(pw,"mandelcolor");
    pw_putcolormap(pw,0,gct.cms_size,red,green,blue);
/*
    pw_blackonwhite(pw,0,gct.cms_size-1);
*/
    
    create_children(no_servers);

    open_account_file();

    window_main_loop(frame);

    kill_children(no_servers);

    pr_close(all_pr);

    close_account_file();
    
    exit(0);
}

create_panel_items()
{
    panel_create_item(panel,PANEL_CHOICE,
		      PANEL_LABEL_STRING, "Resolution: ",
		      PANEL_CHOICE_STRINGS, "1","2","5","10",0,
		      PANEL_VALUE, 3,
		      PANEL_NOTIFY_PROC, resolution_proc,
		      0);
    panel_create_item(panel,PANEL_CYCLE,
		      PANEL_LABEL_STRING, "Iterations:",
		      PANEL_CHOICE_STRINGS, "256","512","1024","2048",0,
		      PANEL_ITEM_X, 295,
		      PANEL_VALUE, 1,
		      PANEL_NOTIFY_PROC, depth_mode_proc,
		      0);
    panel_create_item(panel,PANEL_CYCLE,
		      PANEL_LABEL_STRING, "Cycle Mode:",
		      PANEL_CHOICE_STRINGS, "In","Out",0,
		      PANEL_ITEM_X, 450,
		      PANEL_NOTIFY_PROC, cycle_mode_proc,
		      0);
    panel_create_item(panel,PANEL_CHOICE,
		      PANEL_LABEL_STRING, "Zoom Factor:",
		      PANEL_CHOICE_STRINGS, "x2","x3","x4","x5",0,
		      PANEL_ITEM_X, ATTR_COL(0),
		      PANEL_ITEM_Y, ATTR_ROW(1),
		      PANEL_VALUE, 3,
		      PANEL_NOTIFY_PROC, zoom_factor_proc,
		      0);
    panel_create_item(panel,PANEL_CYCLE,
		      PANEL_LABEL_STRING, "Zoom Mode: ",
		      PANEL_CHOICE_STRINGS, "In","Out",0,
		      PANEL_ITEM_X,  450,
		      PANEL_NOTIFY_PROC, zoom_mode_proc,
		      0);
    panel_create_item(panel,PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,panel_button_image(panel,"Reset",5,0),
		      PANEL_ITEM_X, ATTR_COL(0),
		      PANEL_ITEM_Y, 50,
		      PANEL_NOTIFY_PROC,reset_proc,
		      0);
    panel_create_item(panel,PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,panel_button_image(panel,"Draw",5,0),
		      PANEL_NOTIFY_PROC,draw_proc,
		      0);
    panel_create_item(panel,PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,panel_button_image(panel,"Cycle",5,0),
		      PANEL_NOTIFY_PROC,cycle_proc
		      ,0);
    panel_create_item(panel,PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,panel_button_image(panel,"Zoom",5,0),
		      PANEL_NOTIFY_PROC,zoom_proc,
		      0);
    panel_create_item(panel,PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,panel_button_image(panel,"Quit",5,0),
		      PANEL_ITEM_X,  540,
		      PANEL_NOTIFY_PROC,quit_proc,
		      0);
    
    window_fit_height(panel);
    
}

static void
cycle_proc()
{
    register int i,j;
    unsigned int usec= 50000;
    u_char tmp_red[MAX_CELLS],tmp_green[MAX_CELLS], tmp_blue[MAX_CELLS];
    u_char tmp_r,tmp_g,tmp_b;
    
    for(j=0; j<gct.cms_size; j++)
    {
	tmp_red[j]= red[j];
	tmp_green[j]= green[j];
	tmp_blue[j]= blue[j];
    }

    if(cycle_in)
    {
	
	for(i=0; i<gct.cms_size-1; i++) 
	{
	    tmp_r= tmp_red[0];
	    tmp_g= tmp_green[0];
	    tmp_b= tmp_blue[0];
	
	    for(j=0; j<gct.cms_size-2; j++)
	    {
		tmp_red[j]= tmp_red[j+1];
		tmp_green[j]= tmp_green[j+1];
		tmp_blue[j]= tmp_blue[j+1];
	    }
	    tmp_red[j]= tmp_r;
	    tmp_green[j]= tmp_g;
	    tmp_blue[j]= tmp_b;
	    pw_putcolormap(pw,0,gct.cms_size,tmp_red,tmp_green,tmp_blue);
	    usleep(usec);
	}
    }
    else
    {
	for(i=gct.cms_size-1; i>0; i--) 
	{
	    tmp_r= tmp_red[gct.cms_size-2];
	    tmp_g= tmp_green[gct.cms_size-2];
	    tmp_b= tmp_blue[gct.cms_size-2];
	
	    for(j=gct.cms_size-2; j>0; j--)
	    {
		tmp_red[j]= tmp_red[j-1];
		tmp_green[j]= tmp_green[j-1];
		tmp_blue[j]= tmp_blue[j-1];
	    }
	    tmp_red[0]= tmp_r;
	    tmp_green[0]= tmp_g;
	    tmp_blue[0]= tmp_b;
	    pw_putcolormap(pw,0,gct.cms_size,tmp_red,tmp_green,tmp_blue);
	    usleep(usec);
	}
	
    }
    
    pw_putcolormap(pw,0,gct.cms_size,red,green,blue);
    

}


static void
draw_proc()
{
    recalc= TRUE;
    draw_splited(NO_SPLIT);
    
}


static void
reset_proc()
{
    gct.width= gct.height= MANDEL_SIZE;
    gct.x= gct.y= 0;
    gct.resolution = 10;
    gct.depth= 256;
    gct.zx = MANDEL_A;
    gct.zy = MANDEL_B;
    gct.zl = MANDEL_L;
}    


static void quit_proc()
{
    window_destroy(frame);
}

static void
depth_mode_proc(item,value,event)
Panel_item item;
int value;
Event *event;
{
    switch(value)
    {
    case 0:
	gct.depth= 256;
	break;
    case 1:
	gct.depth= 512;
	break;
    case 2:
	gct.depth= 1024;
	break;
    case 3:
	gct.depth= 2048;
	break;
    }
    
    
}

static void
resolution_proc(item,value,event)
Panel_item item;
int value;
Event *event;
{
    switch(value)
    {
    case 0:
	gct.resolution= 1;
	break;
    case 1:
	gct.resolution= 2;
	break;
    case 2:
	gct.resolution= 5;
	break;
    case 3:
	gct.resolution= 10;
	break;
    }
    
    
}

static void
zoom_factor_proc(item,value,event)
Panel_item item;
int value;
Event *event;
{
    zoom_factor= (double)(value+2);
    
}


static void
zoom_mode_proc(item,value,event)
Panel_item item;
int value;
Event *event;
{
    if(value== 0)
	zoom_in= TRUE; 
    else
	zoom_in= FALSE;
    
}

static void
cycle_mode_proc(item,value,event)
Panel_item item;
int value;
Event *event;
{
    if(value== 0)
	cycle_in= TRUE; 
    else
	cycle_in= FALSE;
    
}


static void
zoom_proc()
{
    int window_read_event();
    Event event;
    
    do {
	if(window_read_event(canvas,&event)== -1)
	    fprintf(stderr,"Error in reading event\n");
    }
    while(event_action(&event)!= MS_LEFT);

    gct.zx+= 
	((double)(event_x(&event))/(double)gct.canvas_width)*gct.zl;
    gct.zy+= 
	((double)(event_y(&event))/(double)gct.canvas_height)*gct.zl;

    if(zoom_in)
	gct.zl/= zoom_factor;
    else
	gct.zl*= zoom_factor;
    gct.zx-= gct.zl/2.0;
    gct.zy-= gct.zl/2.0;

    recalc= TRUE;
    draw_splited(NO_SPLIT);
    
}


static void
repaint_mandel(canvas,pw,repaint_area)
Canvas canvas;
Pixwin *pw;
Rectlist *repaint_area;
{
    gct.canvas_width= (int)window_get(canvas,CANVAS_WIDTH);
    gct.canvas_height= (int)window_get(canvas, CANVAS_HEIGHT);
    
    draw_splited(NO_SPLIT);
}


draw_splited(no)
int no;
{
    int no_jobs;

    if(recalc) 
    {
	no_jobs= compute_tasks(gct, no); 
	task_scheduler(no_jobs, &no_servers);
    }
    else 
    {
	pw_rop(pw, 0, 0,
	       gct.canvas_width, gct.canvas_height,
	       PIX_SRC, all_pr, 0, 0);
    }
    
}

/*
 * Compute number of task in current view and return a complete description
 * of all needed tasks. This function returns the number of tasks placed in
 * global job_table.
 */

int compute_tasks(ct,no_split)
MandelCT ct;
int no_split;
{
    int dw, min_task, no_tasks, i;

    no_tasks= no_split;

    /*
     * Compute minimum number of tasks.
     */
    min_task= ((ct.width*ct.height)/(ct.resolution*ct.resolution))/PIX_SIZE + 1;
    
    if(no_tasks< min_task)
	no_tasks= min_task;

    for(i=no_tasks; ct.width%i!= 0 && i<ct.width; i++) ;
    no_tasks=i;
    
    dw= ct.canvas_width/no_tasks;
    
    ct.height= ct.canvas_height;
    ct.x= ct.y= 0;
    ct.width= dw;
    
    for(i=0; i<no_tasks; i++)
    {
	job_table[i]= ct;
	ct.x+= dw;
    }

    return(no_tasks);
    
}


create_children(no_tasks)
int no_tasks;
{
    int i;
    int j;


    /* This will start the number of tasks required */
    
    for(i= 0; i<no_tasks; i++)
    {

	/* Make a socketpair */

	if(socketpair(AF_UNIX, SOCK_STREAM, 0, task[i].socket)<0 )
	{
	    perror("Opening stream socket pair");
	    exit(1);
	}

	/* Now fork a child */

	if( (task[i].pid= fork())== 0)
	{
	    int k, no_tasks;
	    static PixMap *res;
	    CLIENT *cl;
	    struct timeval tv;

/*	sleep(60); */

	    nice(1);

	    /* This is executed by the child */
	    
	    close(task[i].socket[0]);
	    
	    /*
	     * Create client handle...
	     */
	    cl = clnt_create(server_table[i].name, CALCPROG, CALCVERS,
		"circuit_n");
	    if (cl == NULL) 
	    {
		/* 
		 * couldn't establish connection with server.
		 */
		clnt_pcreateerror(server_table[i].name);/**/
		r_buf.reply= 1;
		if(write(task[i].socket[1],&r_buf,sizeof(r_buf))<0)
		    perror("Writing socket pair child");
		/*exit(1);*/
	    }
	    else 
	    {
		/*
		 * Change timeout to 2.5 minutes instead of 25 seconds (default)
		 */
		tv.tv_sec = 150;
		tv.tv_usec= 0;
		clnt_control(cl, CLSET_TIMEOUT, &tv);
	    }
	    
	    /* Loop until there are no more assignments */

	    for (;;)
	    {
		/* Read from socket (waits until something written) */

		if(read(task[i].socket[1],&a_buf,sizeof(a_buf),0)<0)
		    perror("Reading socket pair child");

		/* Check to see if there are more assigments for this child */
	    
		if(!a_buf.die)
		{

		    /* We have received our assignment, go for it... */
		    r_buf.reply= 0;
    
		    /*
		     * Call remote procedure
		     */
		    if (res != NULL) {
			xdr_free(xdr_PixMap, res);
		    }
		    res = calcmandel_1(&a_buf.ct, cl);
		    if (res == NULL) 
		    {
			/*
			 *  Error occurred while calling the server
			 */
			clnt_perror(cl, server_table[i].name);/**/
			r_buf.reply= 2;
		    }

		    /* Ok - we've done our part, return the result */

		    if(r_buf.reply== 0)
			memcpy((char*)(&r_buf.pm),
			       (char *)(res),
			       sizeof(PixMap));

		    r_buf.no= a_buf.no;

		    if(write(task[i].socket[1],&r_buf,sizeof(r_buf))<0)
			perror("Writing socket pair child");
		}
		else
		{
		    /* No more assigments, so leave the childprocess */
		    close(task[i].socket[1]);
		    exit(0);
		}
	    }
	}
/*	sleep(60);*/

    }
    
    /*
     * All the child-processes are forked by now
     */

	
    /* Do some leg-work (set delay to zero) */
    
    for(j=0; j<no_tasks; j++)
    {
	close(task[j].socket[1]);
	fcntl(task[j].socket[0],F_SETFL,O_NDELAY);
	task[j].busy = FALSE;
    }
}


kill_children(no_tasks)
int no_tasks;
{
    int j;
    
    /* now we close down all tasks and sockets */
    
    for(j=0; j<no_tasks; j++)
    {
	a_buf.die = TRUE;
	if(write(task[j].socket[0],&a_buf,sizeof(a_buf))<0)
	    perror("Closing socket pair main");
	close(task[j].socket[0]);
    }

}


task_scheduler(no_jobs,no_tasks)
int no_jobs;
int *no_tasks;
{
    int j, x, y, ind_x;
    int next_job;
    int finished= 0;    /* keeps track of the number of finished jobs */
    int started= 0;     /* keeps track of the number of started jobs */

    Pixrect *pr;
    
    /*
     * Open a memory image for storing results from children.
     */
    if(gct.cms_size== 2)
	/* Monochrome monitor */
	pr = mem_create(gct.width,gct.height, 1);
    else
	/* Less monochrome monitor */
	pr = mem_create(gct.width,gct.height, 8);

    /* Check to see if all servers are up ready to go. */
    
    j= 0;
    while(j<*no_tasks)
    {
	server_table[j].count= 0;
	if( (read(task[j].socket[0],&r_buf,sizeof(r_buf),0)>0) &&
	    (r_buf.reply == 1) )
	{
	    printf("Excluding %s due to no response\n",server_table[j].name);
	    a_buf.die = TRUE;
	    if(write(task[j].socket[0],&a_buf,sizeof(a_buf))<0)
		perror("Writing socket pair main");
	    task[j]= task[(*no_tasks)-1];
	    server_table[j]= server_table[(*no_tasks)-1];
	    --(*no_tasks);
	}
	++j;
    }
    
    /* Stay in this loop until there are no more sub-pix-rect to calculate */

    while(finished < no_jobs)
    {
	j= 0;
	while(j< *no_tasks)
	{
	    /* Is task busy? if not so and there are more jobs - go go go */

	    if (!task[j].busy & (started<no_jobs))
	    {
		/* assign new job to task */
		a_buf.die = FALSE;
		a_buf.no = started;
		a_buf.ct = job_table[started++];
		task[j].busy = TRUE;
		pw_rop(pw, 
		       a_buf.ct.x, 
		       a_buf.ct.y,
		       a_buf.ct.width, 
		       a_buf.ct.height,
		       PIX_SRC | PIX_COLOR(0),
		       (Pixrect *)0,0,0);
		pw_char(pw,
			a_buf.ct.x,
			a_buf.ct.y+14,
			PIX_SRC /*| PIX_COLOR(gct.cms_size-1)*/,
			small_font[(a_buf.ct.resolution<2)?0:1],
			(char)j+'0');
		
		++server_table[j].count;
		if(write(task[j].socket[0],&a_buf,sizeof(a_buf))<0)
		    perror("Writing socket pair main");
	    }
	    else /* busy - but maybe it has finished its work */
	    {
		if(read(task[j].socket[0],&r_buf,sizeof(r_buf),0)>0)
		{
		    /* Childprocess has delivered a reply */
		    /* Is everything OK? */

		    if(r_buf.reply== 0) 
		    {
			ind_x= 0;
			for(x= r_buf.pm.x; x< (r_buf.pm.x+r_buf.pm.width); 
			    x+= r_buf.pm.resolution)
			    for(y=r_buf.pm.y; y< (r_buf.pm.y+r_buf.pm.height);
				y+= r_buf.pm.resolution)
				pr_rop(pr, 
				       x-r_buf.pm.x, y-r_buf.pm.y, 
				       r_buf.pm.resolution, r_buf.pm.resolution,
				       PIX_SRC |
				       PIX_COLOR((int)r_buf.pm.pixels[ind_x++]),
/*				       PIX_COLOR((int)r_buf.pm.pixels.pixels_val[ind_x++]),
*/
				       (Pixrect *)0,0,0);
			
			pw_rop(pw, r_buf.pm.x, r_buf.pm.y,
			       r_buf.pm.width, r_buf.pm.height,
			       PIX_SRC, pr, 0, 0);
			pr_rop(all_pr,r_buf.pm.x, r_buf.pm.y,
			       r_buf.pm.width, r_buf.pm.height,
			       PIX_SRC, pr, 0, 0);
		    

			task[j].busy= FALSE;
			finished++;		    

			if (started<no_jobs)
			{
			    /* assign new job to task */
			    a_buf.die = FALSE;
			    a_buf.no = started;
			    a_buf.ct= job_table[started++];
			    task[j].busy = TRUE;
			    pw_rop(pw, 
				   a_buf.ct.x, 
				   a_buf.ct.y,
				   a_buf.ct.width, 
				   a_buf.ct.height,
				   PIX_SRC | PIX_COLOR(0),
				   (Pixrect *)0,0,0);
			    pw_char(pw,
				    a_buf.ct.x,
				    a_buf.ct.y+14,
				    PIX_SRC/* | PIX_COLOR(gct.cms_size-1)*/,
				    small_font[(a_buf.ct.resolution<2)?0:1],
				    (char)j+'0');
			    ++server_table[j].count;
			    if(write(task[j].socket[0],&a_buf,sizeof(a_buf))<0)
				perror("Writing socket pair main");
			}
		    }
		    else
		    {
			/* A server has droped out - Kill it! */

		      printf("Excluding %s due to no response.\n",server_table[j].name);	    
			a_buf.die = TRUE;
			if(write(task[j].socket[0],&a_buf,sizeof(a_buf))<0)
			    perror("Writing socket pair main");
			task[j]= task[(*no_tasks)-1];
			server_table[j]= server_table[(*no_tasks)-1];
			--(*no_tasks);
			job_table[--started]= job_table[r_buf.no];

			/* Test to see if there is no servers left. */
			if(*no_tasks== 0)
			{
			    finished= no_jobs;
			    printf("All servers have droped out. So why not quit.\n");
			}
			
		    }
		    
		}
	    }
	    ++j;
	    
	}
	usleep(100000);
    }
    pr_close(pr);
    recalc= FALSE;
    write_account_file();
}


FILE *faccp;

open_account_file()
{
    if( (faccp= fopen(ACCOUNT_FILE, "w"))== NULL)
    {
	fprintf(stderr,"Can't open %s file for writing.",ACCOUNT_FILE);
	exit(1);
    }
    fprintf(faccp,"************************************************************************\n");
    fprintf(faccp,"* This is the official version of Gr. 303's Multi-Mandel Account-file. *\n");
    fprintf(faccp,"************************************************************************\n\n");
}


close_account_file()
{
    close(faccp);
}

write_account_file()
{
    int sum,i;
    char name[4];
    
    sum = 0;
    for(i=0;i<no_servers;i++)
    {
	name[0]= server_table[i].name[0];
	name[1]= server_table[i].name[1];
	name[2]= server_table[i].name[2];
	name[3]= '\0';
	fprintf(faccp,"SERVER: %s \t\tCOUNT:\t%d\n",name,server_table[i].count);
	sum+= server_table[i].count;
    }
    fprintf(faccp,"-------------------------------------------\n");
    fprintf(faccp,"TOTAL: \t\t\t\t%d\n",sum);
    fprintf(faccp,"===========================================\n\n");
}

