/*
 
 *  sock.h --
 
 *      High level socket interface for PC NFS file server.
 
 *
 
 *  Author:
 
 *      See-Mong Tan
 
 */
 

 
/* exported functions */
 

 
  /* creates socket - combination of 4 BSD "socket" and "bind" calls */
 
extern int sock_create(int, int, struct sockaddr_in *);
 
  /* closes socket - 4 BSD "close" */
 
extern void sock_close(int);
 
  /* receive - 4 BSD "recvfom" */
 
extern int sock_recv(int, char *, int, struct sockaddr_in *);
 
  /* synchronous I/O multiplexing - 4 BSD "select" */
 
extern int sock_select(long *, long *);
 
  /* UDP message send */
 
extern int sock_send(int, struct sockaddr_in *, char *, int);
 
  /* returns host name given internet address */
 
extern char *sock_gethostbyaddr(struct sockaddr_in);
 
  /* returns host address given host name */
 
extern long sock_gethostbyname(char *);
 
