/*
 
 *  files.h --
 
 *      Interface for the file manipulation procedures.
 
 *
 
 *  Author:
 
 *      See-Mong Tan
 
 */
 

 
#define BASIC_BLOCKSIZE ((u_long) 1024)	/* preferred block size in bytes */
 
#define FS_BLOCKSIZE ((u_long) 1024)	/* file system block size */
 

 
#ifndef MAXFILENAMELEN
 
#define MAXFILENAMELEN 20
 
#endif
 

 
#ifndef MAXPATHNAMELEN
 
#define MAXPATHNAMELEN 128	/* 128 chars for maximum file name */
 
#endif
 

 
/* UNIX file access permissions */
 

 
  /* permissions returned */
 
#define UPERM_REG ((u_long) 0100777)
 
#define UPERM_SUBDIR ((u_long) 040777)
 
#define UPERM_RDONLY ((u_long) 0100555)
 
  /* what is requested */
 
#define UCHK_RD	((u_long) 0400)		/* rd by owner */
 
#define UCHK_WR ((u_long) 0200)		/* write by owner */
 
#define UCHK_SD ((u_long) 04000)	/* subdirectory */
 

 
  /* path name to file handle */
 
extern fhandle_t pntofh(char *);
 
  /* get file attributes by dos call */
 
extern bool_t file_getattr(char *, struct nfsfattr *);
 
  /* free blocks on disk */
 
extern long files_freeblocks(int, long *, long *);
 
  /* read directory on disk */
 
extern bool_t file_rddir(char *, int, struct udirect *);
 
  /* all converts all alpahabets in string to lower case */
 
extern char *strtolower(char *);
 
  /* create a file with specified permissions */
 
extern int file_create(char *, struct nfssattr *, struct nfsfattr *);
 
  /* set file type */
 
extern int file_setperm(char *, long);
 
  /* set file time */
 
extern int file_settime(char *, long);
 
  /* get number of subdirectories in directory */
 
extern int file_nsubdirs();
 
  /* unlink a file */
 
extern int file_unlink(char *);
 
