.TH SOS 1
.SH NAME
\fBsos\fR \(em Stan's Own Server
.SH SYNOPSIS
\fBsos\fR [-v] [-r]
.SH DESCRIPTION
\fBSOS\fR is a file server conforming to SUN Microsystem's NFS protocol
version 2.  It will run on IBM PC's or compatibles with Microsoft
MS-DOS and an Excelan EXOS ethernet interface.
.sp
The file "\fIexport.us\fR" must exist in the default directory on
the server.  The format is similar to Sun NFS's "\fI/etc/exports\fR"
as defined in \fBexports(5)\fR, except that directories on the server
side are specified in MS-DOS format, 
ie. "<\fIdrive\fR>:<\fIpath name\fR>."  \fBSOS\fR will parse this file
to learn which filesystems on the local machine it will accept mount
requests for.  Up to 50 individual clients may be specified for any
exported directory.
.sp
\fBSOS\fR requires some free disk space on the directory from which it
was started, for maintaining an inode list;  MS-DOS does not support
index nodes directly.
.sp
\fBSOS\fR requires the system clock to be set correctly.  The MS-DOS
\fBtimezone\fR environment variable should be set correctly for whichever
timezone the server exists in.  Note that MS-DOS does not understand
dates prior to January 1, 1980.
.sp
There should be a capacity for at least fifteen files to be opened
at a time.  \fBSOS\fR caches file handles for faster access during
reads.
.sp
File names in filesystems mounted with \fBSOS\fR are limited to eight
characters, with a three character extension.  Attempts to create
a file with a name not matching the above restrictions will result
in an error message, NFSERR_NAMETOOLONG.
.sp
Files created in \fBSOS\fR filesystems will be tagged as owned by
the superuser.  Files have three possible modes:  regular files, which
are global read, write and executable, read only, which are global read
and executable, and subdirectories, which are global read, write
and executable.  \fBChmod(1)\fR may not work as expected with \fBSOS\fR
files, and \fBchown(1)\fR will not work at all.
.sp
An \fBSOS\fR filesystem may be mounted by \fBmount(1)\fR.  On the
mount command line, a filesystem is specifed by the sequence
"/\fIdrive\fR/\fIdirectory\fR."  On the server side, only a subdirectory
may be exported.  \fBSOS\fR cannot export root directories of any
drive.
.SH OPTIONS
.IP -v
The -v option causes \fBSOS\fR to announce successful completion of
each NFS request (verbose mode).  \fBSOS\fR normally announces only errors
and mount requests.
.IP -r
The -r option causes all exported filesystems to be read only.
.SH FILES
These two files should exist in the default directory from which the 
server was started:
.br
\fIexport.us\fR \(em list of exported filesystems and clients.
.br
\fIinode.dmp\fR \(em index node information for crash recovery.
.sp
\fIhosts\fR \(em host table resident on PC.
\fI
.SH "SEE ALSO"
nfs(4p), nfsd(8), mount(1), mount(8), umount(1), exports(5)
.br
\fINetworking on the Sun Workstation\fR, Sun Part No. 800-1324-03.
.SH BUGS
\fBSOS\fR portmapper and mount daemons are incomplete.  See below.
.br
The portmapper operates on datagrams.  TCP requests are not
supported.
.SH REQUESTS
.sp 1
.I "Port Mapper Requests"
.br
Only one call is supported:  PMAPPROC_GETPORT. The port mapper
knows of only the NFS and mount daemon ports.  In version two of
the NFS protocol, NFS port is bound to 2049.  This is a bug in the
NFS protocol which Sun Microsystem claims it will fix in the near
future.
.sp
.I "Mount Daemon Requests"
.br
Two calls are supported:  MOUNTPROC_MOUNT and MOUNTPROC_UMOUNT.  These
reply to mount and unmount requests for specified filesystems.
.sp
.I "NFS Server Requests"
.br
\fBSOS\fR supports the whole range of valid requests for version two
of the NFS protocol, except NFSPROC_READLINK, NFSPROC_LINK
and NFSPROC_SYMLINK.  MS-DOS
does not support symbolic links.  This is a list of requests:
.sp
Procedure 0:	NFSPROC_NULL		\fI/* for server response and timing */\fR
.br
Procedure 1:	NFSPROC_GETATTR		\fI/* get file attributes */\fR
.br
Procedure 2:	NFSPROC_SETATTR		\fI/* set file attributes */\fR
.br
Procedure 3:	NFSPROC_ROOT		\fI/* obsolete \(em not supported */\fR
.br
Procedure 4:	NFSPROC_LOOKUP		\fI/* lookup file in directory */\fR
.br
Procedure 5:	NFSPROC_READLINK		\fI/* not supported */\fR
.br
Procedure 6:	NFSPROC_READ		\fI/* read from file */\fR
.br
Procedure 7:	NFSPROC_WRITECACHE	\fI/* obsolete \(em not supported */\fR
.br
Procedure 8:	NFSPROC_WRITE		\fI/* write to file */\fR
.br
Procedure 9:	NFSPROC_CREATE		\fI/* create file */\fR
.br
Procedure 10:	NFSPROC_REMOVE		\fI/* remove file */\fR
.br
Procedure 11:	NFSPROC_RENAME		\fI/* rename a file */\fR
.br
Procedure 12:	NFSPROC_LINK		\fI/* not supported */\fR
.br
Procedure 13:	NFSPROC_SYMLINK		\fI/* not supported */\fR
.br
Procedure 14:	NFSPROC_MKDIR		\fI/* make directory */\fR
.br
Procedure 15:	NFSPROC_RMDIR		\fI/* remove directory */\fR
.br
Procedure 16:	NFSPROC_READDIR		\fI/* read directory */\fR
.br
Procedure 17:	NFSPROC_STATFS		\fI/* status of filesystem */\fR
.sp
.SH COMMENTS
Comments and bugs should be addressed to:
.br
\fIstan\fR@\fIlbl-csam.arpa\fR, \fIstan\fR@\fIlbl-csam.lbl.doe.gov\fR, or
\fIlbl-csam.arpa\fR!\fIstan\fR.
.SH AUTHORS
See-Mong Tan, Harvard Holmes, Craig Eades
