/*
 
 *  nb.c --
 
 *      Bug free host to network and network to host data conversion.
 
 *
 
 *  Author:
 
 *      Thanks to David Peterson
 
 */
 

 
#include "types.h"
 
#include <sys/socket.h>
 

 
/*
 
 *  long dntohl(long var) --
 
 *      32 bit network to host byte ordering
 
 */
 
long dntohl (var)
 
	long var ;
 
{
 
    unsigned short word0 ;
 
    unsigned short word1 ;
 

 
    word0 = ((var >> 16) & 0xffff) ;
 
    word1 = (var & 0xffff) ;
 
    word0 = ntohs(word0) ;
 
    word1 = ntohs(word1) ;
 
    var = 0 ;
 
    var |= word1 ;
 
    var <<= 16 ;
 
    var |= word0 ;
 
    /* printf ("dntohl var = %lx\n",var) ; */
 
    return (var) ;
 
}
 

 
/*
 
 *  long dhtonl(long var) --
 
 *      32 bit host to network byte odering
 
 */
 
long dhtonl (var)
 
	long var ;
 
{
 
    unsigned short word0 ;
 
    unsigned short word1 ;
 

 
    /* printf ("dhtonl before = %lx\n",var) ; */
 
    word0 = ((var >> 16) & 0xffff) ;
 
    word1 = (var & 0xffff) ;
 
    word0 = ntohs(word0) ;
 
    word1 = ntohs(word1) ;
 
    var = 0 ;
 
    var |= word1 ;
 
    var <<= 16 ;
 
    var |= word0 ;
 
    /* printf ("dhtonl var = %lx\n",var) ; */
 
    return (var) ;
 
}
 
