/* system.c - MIB realization of the System group */

#ifndef	lint
static char *rcsid = "$Header: /f/osi/snmp/RCS/system.c,v 7.0 89/11/23 22:23:33 mrose Rel $";
#endif

/* 
 * $Header: /f/osi/snmp/RCS/system.c,v 7.0 89/11/23 22:23:33 mrose Rel $
 *
 * Contributed by NYSERNet Inc.  This work was partially supported by the
 * U.S. Defense Advanced Research Projects Agency and the Rome Air Development
 * Center of the U.S. Air Force Systems Command under contract number
 * F30602-88-C-0016.
 *
 *
 * $Log:	system.c,v $
 * Revision 7.0  89/11/23  22:23:33  mrose
 * Release 6.0
 * 
 */

/*
 *				  NOTICE
 *
 *    Acquisition, use, and distribution of this module and related
 *    materials are subject to the restrictions of a license agreement.
 *    Consult the Preface in the User's Manual for the full terms of
 *    this agreement.
 *
 */


#include <stdio.h>
#include "mib.h"
#include "tailor.h"

/*  */

static int  o_sysUpTime (oi, v, offset)
OI	oi;
register struct type_SNMP_VarBind *v;
int	offset;
{
    struct timeval boottime,
		   now;
    register OID    oid = oi -> oi_name;
    register OT	    ot = oi -> oi_type;
    static   int lastq = -1;
    static   integer diff;

    switch (offset) {
	case type_SNMP_PDUs_get__request:
	    if (oid -> oid_nelem != ot -> ot_name -> oid_nelem + 1
		    || oid -> oid_elements[oid -> oid_nelem - 1] != 0)
		return int_SNMP_error__status_noSuchName;
	    break;

	case type_SNMP_PDUs_get__next__request:
	    if (oid -> oid_nelem == ot -> ot_name -> oid_nelem) {
		OID	new;

		if ((new = oid_extend (oid, 1)) == NULLOID)
		    return int_SNMP_error__status_genErr;
		new -> oid_elements[new -> oid_nelem - 1] = 0;

		if (v -> name)
		    free_SNMP_ObjectName (v -> name);
		v -> name = new;
	    }
	    else
		return NOTOK;
	    break;

	default:
	    return int_SNMP_error__status_genErr;
    }

    if (quantum != lastq) {
	lastq = quantum;

	if (getkmem (nl + N_BOOTTIME, (caddr_t) &boottime, sizeof boottime)
	        == NOTOK)
	    return int_SNMP_error__status_genErr;
	if (gettimeofday (&now, (struct timezone *) 0) == NOTOK) {
	    advise (LLOG_EXCEPTIONS, "failed", "gettimeofday");
	    return int_SNMP_error__status_genErr;	    
	}
	diff = (now.tv_sec - boottime.tv_sec) * 100
	     + ((now.tv_usec - boottime.tv_usec) / 10000);
    }

    return o_number (oi, v, diff);
}

/*  */

init_system () {
    register OT	    ot;

    if (ot = text2obj ("sysDescr"))
	ot -> ot_getfnx = o_generic;
    if (ot = text2obj ("sysObjectID"))
	ot -> ot_getfnx = o_generic;
    if (ot = text2obj ("sysUpTime"))
	ot -> ot_getfnx = o_sysUpTime;
    if (ot = text2obj ("sysContact"))
	ot -> ot_getfnx = o_generic;
    if (ot = text2obj ("sysName")) {
	ot -> ot_getfnx = o_generic;
	if (ot -> ot_syntax) {
	    char    buffer[BUFSIZ];

	    (void) gethostname (buffer, sizeof buffer);
	    (void) (*ot -> ot_syntax -> os_parse) ((struct qbuf **)
						   		&ot -> ot_info,
						   buffer);
	}
    }
    if (ot = text2obj ("sysLocation"))
	ot -> ot_getfnx = o_generic;
    if (ot = text2obj ("sysServices"))
	ot -> ot_getfnx = o_generic;
}
