: run this script through /bin/sh

P=/usr/local/lib/awk

F=mib.connections S= T=mib.protocols

agent= community= flags=

for A in $*
do
    case $A in
	-a)	flags="$flags -v aflag=1" ;;
	-n)	;;
	-o)	flags="$flags -v oflag=1" ;;
	-s)	S=1 flags="$flags -v sflag=1" ;;
	-t)	echo "$A: unimplemented (warning)" 1>&2 ;;
	-A)	echo "$A: unimplemented (warning)" 1>&2 ;;

	-m)	F=mib.mbufs T=mib.mbufs ;;
	-i)	F=mib.interfaces T=mib.interfaces ;;
	-h)	echo "hosts: no MIB-II support" 1>&2
		exit 1 ;;
	-r)	F=mib.routes T=mib.routes ;;
	-z)	F=mib.arp T=mib.arp ;;
	-Z)	F=mib.system T=mib.system ;;

	-*)	echo "$A: unknown flag" 1>&2
		exit 1 ;;
	
	*)	if [ "x$agent" = "x" ]; then
		    agent="-v AGENT=$A"
		elif [ "x$community" = "x" ]; then
		    community="-v COMMUNITY=$A"
		else
		    echo "usage: s-netstat [switches] [agent [community]]" 1>&2
		    exit 1
		fi ;;
    esac
done

if [ "x$S" != "x" ]; then
    F="$T"
fi

if [ ! -f $F ]; then
    F="$P/$F"
fi

exec gawk $flags $agent $community -f $F
