/*
dllist.h: header file for dllist.c

Copyright (C) 1993 Eugene Eric Kim
All rights reserved.

LAST REVISION: August 25, 1993
*/

#include "global.h"

typedef struct _node {
  char entry[LEN];
  struct _node* next;
  struct _node* prev;
} node;

typedef struct {
  node* head;
} dllist;

extern void list_create(dllist* l);
extern node* list_next(node* w);
extern node* list_prev(node* w);
extern int list_size(dllist l);
extern short list_empty(dllist l);
extern short list_first(node* w);
extern short list_last(node* w);
extern node* list_start(dllist l);
extern node* list_end(dllist l);
extern node* list_position(dllist l, int i);
extern node* list_del(dllist* l, node* w);
extern node* list_insafter(dllist* l, node* w, char item[LEN]);
extern node* list_insbefore(dllist* l, node* w, char item[LEN]);
extern void list_replace(dllist* l, node* w, char item[LEN]);
extern void list_interchange(dllist* l, node* w, node* v);
extern void list_traverse(dllist l, void (*visit)(node* w));
extern void list_clear(dllist* l);
