/*
 * pathsend dest-host user
 */

#include <stdio.h>
#include <ctype.h>

typedef struct {
	char *dptr;
	int dsize;
} datum;

/* From sendmail sysexits.c */
#define	ERR_USAGE	64
#define	ERR_DATAERR	65
#define	ERR_NOHOST	68
#define	ERR_UNAVAILABLE	69
#define	ERR_SOFTWARE	70
#define	ERR_OSERR	71
#define	ERR_OSFILE	72

extern datum fetch();

#define PATHALIASES	"/usr/lib/pathaliases"
#define SENDMAIL	"/usr/lib/sendmail"

#define MAXRECIPIENTS	100+3

char *sendmail = SENDMAIL;

extern int errno;

main(argc, argv)
char *argv[];
{
    datum key, content;
    int i, pid, verbose = 0, debug = 0, index, saveindex;
    register char *bp;
    char *user, *from = ((char *) NULL), *mkstring(), *findhost();
    char dest[2048], buf[2048];
    char *sendargv[MAXRECIPIENTS];

    for (argc--, argv++; argc && **argv == '-'; argc -= i, argv += i) {
	i = 1;
	while (*++*argv) {
	    switch (**argv) {
		case 'd':
		    debug++;
		    break;
		case 'f':
		    if (argc <= i)
			done(ERR_USAGE, 0, "Not enough args for '-f'");
		    from = argv[i++];
		    break;
		case 'm':
		    if (argc <= i)
			done(ERR_USAGE, 0, "Not enough args for '-m'");
		    sendmail = argv[i++];
		    break;
		case 'v':
		    verbose++;
		    break;
		default:
		    fprintf(stderr,"Unknown switch '-%c'\n",**argv);
		    done(ERR_USAGE, 0,
		"Usage: pathsend [-dv] [-m mailer] [host!...!user]");
	    }
	}
    }

    if (dbminit(PATHALIASES) < 0)
	done(ERR_SOFTWARE, errno, "pathsend: can't dbminit %s",PATHALIASES);

    index = 0;
    sendargv[index++] = "pathsendmail";

    if (verbose)
	sendargv[index++] = "-v";
	
    if (from) {
	sendargv[index++] = "-f";
	sendargv[index++] = from;
    }

    saveindex = index;
    for (; argc > 0; argv++, argc--) {

	/* Default pathalias address is original address */
	strcpy(buf,*argv);

	/* Try and pathalias each host in left-to-right order,
	 * until a pathalias-able host is found
	 */
	for (user = *argv; user = findhost(user,dest);) {

	    key.dptr = dest;
	    key.dsize = strlen(dest) + 1;
	    content = fetch(key);

	    if (content.dptr != 0) {
		sprintf(buf, content.dptr, user);
		break;
	    }
	}

	/* Make sure there is no recursive pathaliasing */
	strcat(buf,";nopath");

	sendargv[index++] = mkstring(buf);
    }

    if (index != saveindex) {
	sendargv[index] = (char *)NULL;
	if (debug) {
	    printf("sending to < ");
	    for (i = saveindex; i < index; i++)
		printf("%s ",sendargv[i]);
	    printf(">\n");
	} else {
	    switch (pid = fork()) {
		case -1:
		    done(ERR_OSERR, errno, "pathsend: can't fork");
		case 0:
		    execv(sendmail,sendargv);
		    done(ERR_OSFILE, errno,
			"pathsend: can't execl %s", SENDMAIL);
		default:
		    while (wait((int *) NULL) != pid);
		    break;
	    }
	}
    }

    done(0);
}

extern int sys_nerr;
extern char *sys_errlist[];

done(status,err,str,a,b,c,d,e,f)
int status, err;
char *str;
{
    if (status) {
	fprintf(stderr,str,a,b,c,d,e,f);
	if (err && err < sys_nerr)
	    fprintf(stderr, ": %s", sys_errlist[err]);
	else
	    fprintf(stderr, ": unknown error %d", err);
	fprintf(stderr, "\n");
    }
    exit(status);
}

char *
mkstring(string)
char *string;
{
    char *str, *malloc();

    if ((str = malloc(strlen(string)+1)) == (char *)NULL)
	done(ERR_SOFTWARE, errno, "can't malloc for destination");
    strcpy(str,string);
    return(str);
}

char *
findhost(user,dest)
char *user,*dest;
{
    char *newuser,*index();

    if ((newuser = index(user,'!')) == NULL)
	return((char *) NULL);

    sscanf(user,"%[^!]!",dest);
    return(++newuser);
}
