
############################################################
############################################################
#####
#####		Local and Program Mailer specification
#####
############################################################
############################################################

Mlocal,	S=11, R=12, F=rlsFDmn, A=mail -d $u,
ifdef(`DEBUG',
`	P=/toe/guest/dudek/bin/dmail',
`	P=/bin/mail')
Mprog, S=11, R=12, F=lsF, A=sh -c $u,
ifdef(`DEBUG',
`	P=/toe/guest/dudek/bin/dmail',
`	P=/bin/sh')
ifdef(`TTYMAILER',
`Mtty,	P=/usr/local/bin/send, F=rlsn, S=11, R=12, A=send $u, M=5000'
)

S10

S11
R$+			$:$>10$1
R@			MAILER-DAEMON		errors to mailer-daemon???

S12
R$+			$:$>10$1

############################################################
############################################################
#####
#####		LOCAL(!!) smtp (tcp/ip) mailer spec
#####
############################################################
############################################################

Mether-mailer, S=14, R=15, F=RmsFDuX, E=\r\n,
ifdef(`DEBUG',
`	P=/toe/guest/dudek/bin/dmail, A=dmail $u',
`	P=[IPC], A=IPC $h')

S13
# convert to external now, so we can be sure there is an '@' for
# crotchety SMTP's (like Wollongong)
R$+			$:$>8$1
ifdef(`SENDDOMAIN',
`# Make sure our domain is present in the address for domain-less hosts
R$*<@$->		$:$1<@$2.$D>',`')

S14
R$+			$:$>13$1			externalize

R$*<@$+>		$@$1<@$2>			already ok
R$+			$:$1<@$J>			tack on our name
ifdef(`SENDDOMAIN',
`R$+<@$->		$@$1<@$2.$D>			tack on our domain',
`# sending within our own domain, so ok not to append our domain to hostname
R$+<@$-.$D>		$@$1<@$2>			strip our domain name')

S15
R$+			$:$>13$1			externalize

############################################################
############################################################
#####
#####		DECNET Mailer specification
#####
############################################################
############################################################

Mdecnet-mailer,	F=mnsFDR, S=16, R=16, A=decnetmail $f $x $h $u,
ifdef(`DEBUG',
`	P=/toe/guest/dudek/bin/dmail',
`	P=/usr/lib/dnet/local/decnetmail')

S16

############################################################
############################################################
#####
#####		UUCP Mailer specification
#####
############################################################
############################################################

Muucp-mailer, S=20, R=21, M=150000, F=RsFDhuUm, A=uux - -a$f -gA $h!rmail ($u),
ifdef(`DEBUG',
`	P=/toe/guest/dudek/bin/dmail',
`	P=/usr/bin/uux')
Mtcpuucp, S=20, R=21, F=RmsFDuX,
ifdef(`DEBUG',
`	P=/toe/guest/dudek/bin/dmail, A=dmail $u',
`	P=[IPC], A=IPC $h')

S19
R$+			$:$>8$1			convert to external form

# Change internal non-UUCP routing to '!' syntax
# First, change internal '@'s to '%'s
R$+@$+<$+>		$1%$2<$3>		change smith@foo... to smith%foo
# Change smith%foo%bar... to foo!smith%bar...
R$+%$+%$+<$+>		$2!$1%$3<$4>		change smith%foo%bar... to !
# Change foo!smith%bar... to bar!foo!smith...
R$+%$+<$+>		$2!$1<$3>		change smith%foo... to !

R$+<@$+>		$@$2!$1			u@host.ARPA => host.ARPA!u

S20
R$+			$:$>19$1		convert to old style
R$=U!$+			$2			strip local name
R$+			$:$U!$1			stick on our host name

S21
R$+			$:$>19$1		convert to old style

############################################################
############################################################
#####
#####		Arpanet TCP Mailer specification
#####
############################################################
############################################################

Marpa-mailer, S=23, R=24, E=\r\n, F=RmsDFMuXL,
ifdef(`DEBUG',
`	P=/toe/guest/dudek/bin/dmail, A=dmail $u',
`	P=[IPC], A=IPC $h')

S22
# externalize now, so sender looks right if we stick on our own address
R$+			$:$>8$1

# output our mail clients as harvard.harvard.edu
R$+<@$=J>		$@$1<@$A>

ifdef(`ARPACLIENTS',
`# output our ARPA clients as harvard.harvard.edu
#  this means that users on these arpa clients MUST have mailboxes
#  on this machine
R$+<@$=K>		$@$1<@$A>'
)

# output our mail relay as harvard.harvard.edu
ifdef(`MAILRELAY',
`R$+<@$R>		$@$1<@$A>'
)

# output local hosts in user%host@harvard.harvard.edu syntax
R$+@$+<@$->		$@$1@$2@$3<@$A>		broken local hosts
R$+<@$->		$@$1%$2<@$A>		local hosts

# handle other external cases
R$+<@$+>		$@$1<@$2>

# kludge for numeric internet spec
R$+<@>			$@$1

# otherwise, just stick on our hostname
R$+			$@$1<@$A>

S23
R$+			$:$>22$1		externalize

# forward from domains other than ARPA domains
R$+@$+<@$+.$~A>		$@$1@$2@$3.$4<@$A>	broken user@host.DOMAIN
R$+<@$+.$~A>		$@$1%$2.$3<@$A>		user@host.DOMAIN

S24
R$+			$:$>22$1		externalize

############################################################
############################################################
#####
#####		BITNET Mailer specification
#####
############################################################
############################################################


Mbitnet-mailer, S=25, R=26, M=150000, F=RSsnFD, A=rscsmail $f $h $u,
ifdef(`DEBUG',
`	P=/toe/guest/dudek/bin/dmail',
`	P=/usr/lib/rscs/rscs%mail')
Mccnet-mailer, F=RSsnFD, S=26, R=27, M=100000, A=rscsmail $f$h$u cuvma mailer,
ifdef(`DEBUG',
`	P=/toe/guest/dudek/bin/dmail',
`	P=/usr/lib/rscs/rscs%mail')

S25
R$+			$:$>8$1				externalize

R$*<@$*.BITNET>		$@$1@$2.BITNET
R$+<@$+>		$1%$2
R$+			$:$1@$B.BITNET			stick on our name

S26
R$+			$:$>8$1				externalize

############################################################
############################################################
#####
#####		PATHALIAS Mailer specification
#####
############################################################
############################################################

Mpath-mailer, S=28, R=28, F=fhume,
ifdef(`DEBUG',
`	P=/toe/guest/dudek/bin/pathsend,
	A=pathsend -m /toe/guest/dudek/bin/dsendmail $u',
`	P=/usr/lib/uucp/pathsend, A=pathsend $u')

S28

