############################################################
############################################################
#####
#####		SENDMAIL CONFIGURATION FILE
#####
############################################################
############################################################

######################
#   General Macros   #
######################

include(defines)

include(localdomain)

include(hostnames)

# my official (Domain) hostname
ifdef(`DOMAININNAME',
`Dj$w'
,
`Dj$w.$D')

# my offical (Domain) return address
ifdef(`DOMAININNAME',
`DA$J'
,
`DA$J.$D')

# known top-level domains (other than ARPA domains)
CDLOCAL UUCP BITNET DEC UTEXAS CSNET MAILNET CCNET
# known ARPA domains
FA/usr/local/lib/mail/mailhosts.arpadomains
# domains with ARPA gateways
CCDEC UTEXAS CSNET MAILNET
# known BITNET domains, or domains with BITNET gateways
CZBITNET CCNET

include(relays)


#########################
###   Trusted users   ###
#########################

include(trusted)


############################################################
#
#	General configuration information
#
#	This information is basically just "boiler-plate"; it must be
#	there, but is essentially constant.
#
#	Information in this file should be independent of location --
#	i.e., although there are some policy decisions made, they are
#	not specific to Berkeley per se.
#
#
############################################################

DVa0.25

##########################
###   Special macros   ###
##########################

# my name
DnMAILER-DAEMON
# UNIX header format
DlFrom $g  $d
# delimiter (operator) characters
Do.:%@!^=/[],;
# format of a total name
Dq$g$?x ($x)$.
# SMTP login message
De$j Sendmail $v/$V ready at $b

###################
###   Options   ###
###################

include(options)

###############################
###   Message precedences   ###
###############################

Pfirst-class=0
Pspecial-delivery=100
Pjunk=-100

#############################
###   Format of headers   ###
#############################

H?P?Return-Path: <$g>
H?R?Received: $?sfrom $s $.by $j$?r with $r$.; $b
H?D?Date: $a
H?F?Resent-From: $q
H?F?From: $q
HSubject:


###########################
###   Rewriting rules   ###
###########################


################################
#  Sender Field Pre-rewriting  #
################################
S1

###################################
#  Recipient Field Pre-rewriting  #
###################################
S2

#################################
#  Final Output Post-rewriting  #
#################################
S4

R@			$@				handle <> error addr

# call local externalizing ruleset
R$+			$:$>8$1

# kludge for internet spec
R$+<@>			$:$1

# remove focus
R$*<$+>$*		$1$2$3				defocus

# change mixed-mode '@' and '!' into route-addr if appropriate
R$+!$+@$+		$:$>9$1!$2@$3

# turn multiple-'@' to route-addr
R$+@$+@$+		$:<:$1@$2>@$3
R<:$*>@$+@$+		<@$2:$1>@$3
R<:$*>@$+		$@@$2:$1
R<@$*>@$+@$+		<@$2,@$1>@$3
R<$*>@$+		$@@$2,$1

#################################
#  Local externalization        #
#################################
S8

# make sure UUCP is in old form
R$+<@$*.UUCP>		$@$2!$1				u@host.UUCP => host!u

# externalize local domain info
R$*<@$*.LOCAL>		$@$1<@$2>			change local info

# handle other external cases
R$+<@$+>		$@$1<@$2>

#################################
#  UUCP -> ARPA route-addr	#
#################################
S9
# focus on first uucp address
R$+!$+@$+		$:<!$1>$2@$3
# if the first bang-host is arpa-style, turn it into an '@'
R<!$+.$=A>$+@$+		$@$>9$3@$1.$2@$4
# else simply return as mixed-mode
R<!$+>$+@$+		$@$1!$2@$3

###########################
#  Name Canonicalization  #
###########################
S3

# handle "from:<>" special case
R<>			$@@				turn into magic token

# basic textual canonicalization
R$*<$+>$*		$2				basic RFC821/822 parsing
R$+ at $+		$1@$2				"at" -> "@" for RFC 822

# handle route-addr (ARPA routing syntax)
# in general, change @a,@b:user@c <=> user@c@b@a
# prepare to focus
#
# KLUDGE - strip stupid uucp path from front of route-addrs - gd 8/6/87
#  foo!@bar:user@gag <=> @bar:user@gag
R$+!@$+:$+@$+		$:@$2:$3@$4
# recognize route-addr
R@$+			$:@$1<>
# change @b,@c:user@d<@a> <=> @c:user@d<@b@a>
R@$+,@$+:$+<$*>		@$2:$3<@$1$4>
# change @a:user@b <=> user@b<@a>
R@$+:$+<$*>		$2<@$1$3>
# defocus, and treat as simple 'user@site' below
R$+<$*>			$1$2

# focus on destination host.domain
R$+@$+			$:$1<@$2>			focus on domain
# This is repeated until focused on the rightmost '@'
R$+<$+@$+>		$1$2<@$3>			move gaze right
# canonical - do local rewriting
R$+<@$+>		$@$>6$1<@$2>

# convert old-style addresses to a domain-based address
# (has to come after recognition of user@site, else bad recursion)
#
# user%host
R$+%$+			$:$1<@$2>			user%host
R$+<@$+%$+>		$1%$2<@$3>			move right
R$+<@$*>		$@$>6$1<@$2>			already canonical
#
# host^user or host!user
# host!user is the same as 'user@host' for known local hosts, or
# 'user@host.UUCP' for other hosts.
R$+^$+			$1!$2				convert ^ to !
R$-!$+			$:$2<@$1>			resolve uucp names
R$+<@$=L>		$@$>6$1<@$2>			canonicalize local host
R$+<@$->		$@$>6$1<@$2.UUCP>		add UUCP domain
# harvard.ARPA!root <=> root<@harvard.ARPA>
# NOTE: this relies on matching the FIRST "!" in the address
R$-.$+!$+		$@$>6$3<@$1.$2>			keep domain info

#
# host::user
# host::user is the same as 'user@host' for known local hosts, or
# 'user@host.DECNET' for other hosts.
R$-::$+			$:$2<@$1>			resolve decnet names
R$+<@$=L>		$@$>6$1<@$2>			canonicalize local host
R$+<@$->		$@$>6$1<@$2.DECNET>		add DECNET domain
# harvard.ARPA::root <=> root<@harvard.ARPA>
# NOTE: this relies on matching the FIRST "::" in the address
R$-.$+::$+		$@$>6$3<@$1.$2>			harvard.ARPA::root

#
# host:user
# ':' represents BITNET just like '!' represents UUCP - kludge for sob
# host:user is the same as 'user@host' for known local hosts, or
# 'user@host.BITNET' for other hosts.
# NOTE: ":" parsed after "!" so that site1!site2:user parsed as
#  site2:user<@site1.UUCP>
R$-:$+			$:$2<@$1>			resolve BITNET names
R$+<@$=L>		$@$>6$1<@$2>			canonicalize local host
R$+<@$->		$@$>6$1<@$2.BITNET>		add BITNET domain
# harvard.ARPA:root <=> root<@harvard.ARPA>
# NOTE: this relies on matching the FIRST ":" in the address
R$-.$+:$+		$@$>6$3<@$1.$2>			harvard.ARPA:root

#################################
#  Local Name Canonicalization  #
#################################
S6

# Make canonical (using /etc/hosts)
# Note that the domain may not be returned from /etc/hosts, but that's ok
ifdef(`NODOMAINS',
`R$*<@$-.$D>		$:$1<@$[$2$]>
R$*<@$->		$:$1<@$[$2$]>'
,
`# Use our domain in lookup to avoid ambiguities (like seismo.harvard.edu)
R$*<@$->		$:$1<@$2.$D>
R$*<@$-.$D>		$:$1<@$[$2.$D$]>')

# Kludge around BITNET mail bug - strip BITNET if destination host
# really in DOMAIN syntax
R$*<@$*$=A.BITNET>	$:$1<@$2$3>

# Convert LOCAL to our local domain
R$*<@$-.LOCAL>		$1<@$2.$D>
# Local hosts are recognized later by the fact that there is NO domain
#  in the focus.  Strip our domain here.
R$*<@$-.$D>		$1<@$2>

# Pass thru mail specifier
# foo!bar;nopath<@seismo> <=> foo!bar<@seismo;nopath>
R$*;$-<@$*>		$1<@$3;$2>


############################################################
############################################################
#####
#####		RULESET ZERO
#####
############################################################
############################################################

S0

# handle special cases.....
R@			$#local$:MAILER-DAEMON		handle <> form

# handle numeric internet spec
#  do not pass host address to mailer rulesets, cause host won't recognize its
#  own address.  Need the '@' so we don't tack local hostname on the end.
R$*<@[$+]>		$#arpa-mailer$@[$2]$:$1<@>	numeric internet spec

##################################
#  End of ruleset zero preamble  #
##################################

#
# find our host
# user@ourhost <=> user
R$+<@$=J>		$@$>7$1			user@harvard
# Check for UUCP
R$+<@$=U.UUCP>		$@$>7$1			user@harvard.UUCP
# Check for BITNET
R$+<@$=B.BITNET>	$@$>7$1			user@harvard.BITNET

ifdef(`ANYDOMAIN',
`# These are sorta dangerous, if our canonical name is not unique
# user@ourhost.ARPA <=> user
R$+<@$=J.ARPA>		$@$>7$1			user@harvard.ARPA (sigh)
# user@ourhost.FOONET <=> user
R$+<@$=J.$=D>		$@$>7$1			user@harvard.BITNET',`')

# find our domain, and do something appropriate (send to machine harvard)
R$+<@$D>		$@$>7$1@harvard		user@HARVARD.EDU

#
# watch for UUCP to us
# harvard!user<@site.UUCP> <=> user
R$=U!$+<@$+.UUCP>	$@$>7$2			harvard!user@site.UUCP
# watch for uucp-type forwarding to ARPA
# harvard!user<@site.NOTUUCP> <=> user<@site.NOTUUCP>
R$=U!$+<@$+>		$2<@$3>			harvard!USER@SITE.ARPA
# Other forwarding to ARPA - try not to be too amibitious here, use only
#  the canonical hostname
# harvard:user<@site.ANYTHING> <=> user<@site.ANYTHING>
R$=J:$+<@$+>		$2<@$3>			harvard:USER@SITE.ARPA

#
# mailer specified addresses
#
# These are here for emergencies and mail testing
#
ifdef(`BITNETRELAY',
`# force to BITNET relay
R$*<@$*;bitnet>		$@$>7$1@$2;bitnet@$F
R$*<@$*;ccnet>		$@$>7$1@$2;ccnet@$F'
,
`# force to BITNET
R$*<@$-$*;bitnet>	$#bitnet-mailer$@$2$:$1
# problem here - does mailer need user@site.CCNET for destination???
R$*<@$-$*;ccnet>	$#ccnet-mailer$@$2$:$1')

ifdef(`ARPARELAY',
`# force to ARPA relay
R$*<@$*;arpa>		$@$>7$1@$2;arpa@$C'
,
`# force to ARPA
R$*<@$*;arpa>		$#arpa-mailer$@$2$:$1<@$2>')

# force to uucp
R$*<@$-$*;uucp>		$#uucp-mailer$@$2$:$1

# force to pathalias
R$*<@$*;pathalias>	$#path-mailer$@pathalias:$2!$1

ifdef(`ETHERRELAY',
`# force to ether relay
R$*<@$*;ether>		$@$>7$1@$2;ether@$G'
,
`# force to ether
R$+@$+<@$*;ether>	$#ether-mailer$@$3$:$1@$2
R$*<@$*;ether>		$#ether-mailer$@$2$:$1<@$2>')

# put relaying here, before trying to resolve addresses
include(relayrules)

#
# non-local addresses
#

# resolve UUCP links
ifdef(`PATHALIAS',
`# watch for hosts listed in L.sys but should be pathaliased anyway
R$*<@$=Y.UUCP>		$#path-mailer$@pathalias$:$2!$1',`')
# uucp direct to non-local host
R$*<@$=E.UUCP>		$#uucp-mailer$@$2$:$1	user@host.UUCP
ifdef(`PATHALIAS',
`R$*<@$=E.UUCP;nopath>	$#uucp-mailer$@$2$:$1',`')

ifdef(`PATHALIAS',
`# uucp (non-direct) to non-local host - try pathalias
R$*<@$*.UUCP>		$#path-mailer$@pathalias$:$2!$1
# Already tried pathalias, so remove "nopath" specifier
R$*<@$*;nopath>		$1<@$2>			already tried pathalias
R$*;nopath		$1			pathaliased to this host',`')

ifdef(`UUCPRELAY',
`# uucp (non-direct) to non-local host - send to UUCP relay host
R$*<@$*.UUCP>		$@$>7$1@$2.UUCP@$E	user@somewhere.UUCP'
,
`# uucp to unknown host - try uucp anyway
R$*<@$*.UUCP>		$#uucp-mailer$@$2$:$1	user@somewhere.UUCP')

ifdef(`BITNETRELAY',
`# BITNET to non-local host - send to local BITNET relay
R$*<@$*.$=Z>		$@$>7$1@$2.$3@$F	user@somewhere.BITNET'
,
`# BITNET to non-local host direct
R$*<@$*.BITNET>		$#bitnet-mailer$@$2$:$1
R$*<@$*.CCNET>		$#ccnet-mailer$@$2$:$1@$2.CCNET')

ifdef(`DECNETRELAY',
`# DECNET to non-local host - send to local DECNET relay
R$*<@$*.DECNET>		$@$>7$1@$2.DECNET@$H	user@somewhere.DECNET'
,
`# DECNET to non-local host direct
R$*<@$*.DECNET>		$#decnet-mailer$@$2$:$1')

ifdef(`ARPARELAY',
`# ARPA to non-local host - send to local ARPA relay
R$*<@$*.$=A>		$@$>7$1@$2.$3@$C	user@somewhere.ARPA
R$*<@$*.$=C>		$@$>7$1@$2.$3@$C	user@somewhere.CSNET'
,
`# ARPA to non-local host direct
R$*<@$-.$*$=A>		$#arpa-mailer$@$2.$3$4$:$1<@$2.$3$4>
R$*<@$*.DEC>		$#arpa-mailer$@decwrl.dec.com$:$1<@$2.DEC>
R$*<@$*.UTEXAS>		$#arpa-mailer$@sally.utexas.edu$:$1<@$2.UTEXAS>
R$*<@$*.CSNET>		$#arpa-mailer$@relay.cs.net$:$1<@$2.CSNET>
R$*<@$*.MAILNET>	$#arpa-mailer$@mit-multics.arpa$:$1<@$2.MAILNET>')

#
# resolve local addresses
#

ifdef(`MAILSLAVES',
`# mail to local users on our mail slaves can be delivered directly
R$-<@$=R>		$1')

ifdef(`BITNETRELAY',
`# BITNET to local host - send to local BITNET relay
R$*<@$=F>		$@$>7$1@$2.BITNET@$F'
,
`# BITNET to local host direct
R$*<@$=F>		$#bitnet-mailer$@$2$:$1')

ifdef(`DECNETRELAY',
`# decnet to local host - send to local DECNET relay
R$*<@$=H>		$@$>7$1@$2.DECNET@$H'
,
`# decnet to local host direct
R$*<@$=H>		$#decnet-mailer$@$2$:$1')

ifdef(`ETHERRELAY',
`# ethernet to local host - send to local ETHER relay
R$*<@$=G>		$@$>7$1@$2@$G'
,
`# ethernet to local host direct
R$+@$+<@$=G>		$#ether-mailer$@$3$:$1@$2
R$*<@$=G>		$#ether-mailer$@$2$:$1<@$2>')

# uucp to local host
R$*<@$=E>		$#uucp-mailer$@$2$:$1		person@localuucphost

ifdef(`LOCALRELAY',
`# to other local hosts - send to local generic LOCAL relay
R$*<@$->		$@$>7$1@$2@$L'
,
`# unknown local host
ifdef(`DEFAULTMAILER',
`# try default mailer
R$*<@$->		$#$M$@$2$:$1',
`# the buck stops here - local host unknown
R$*<@$*>		$#error$@x$:$2: Unknown local host')')

ifdef(`DEFAULTRELAY',
`# Forward to a host which is smarter than us
R$*<@$*>		$@$>7$1@$2@$N		user@unknowndomain',
`# unknown destination host/domain - bounce
R$*<@$*>		$#error$@x$:$2: Unknown host/domain')

# remaining names must be local
ifdef(`MAILRELAY',
`# Relay all local mail
R$+			$@$>7$1@$R		everything else'
,
`R$+			$#local$:$1		everything else')


#####################################################
#  Code to retry through Rulesets 3 and 0           #
#####################################################
S7

# Make canonical
R$+			$:$>3$1
# Retry
R$+			$@$>0$1

