/*
 * Copyright (c) 1983 Eric P. Allman
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted provided
 * that: (1) source distributions retain this entire copyright notice and
 * comment, and (2) distributions including binaries display the following
 * acknowledgement:  ``This product includes software developed by the
 * University of California, Berkeley and its contributors'' in the
 * documentation or other materials provided with the distribution and in
 * all advertising materials mentioning features or use of this software.
 * Neither the name of the University nor the names of its contributors may
 * be used to endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Update src/Makefile and src/conf.h after creating a new config file. */
/* Update ../doc/07.sendmailop/op.me if creating a new parameter. */

/*
**  proto.H -- configurable parameters for sendmail on proto platforms.
*/

#define VMUNIX		1	/* running on systems w. 4.2/4.3 networking */
#define ISC		1	/* Interactive Unix Host-based TCP/IP */
#define SIG_TYPE	void	/* Value returned by signal() */
#define TIME_TYPE	time_t	/* Value used and returned by time() */
#define SHARE		1	/* Convex share scheduler */
#define SYSV		1	/* running on a system 5 system */

/*
 * Pick one of the next two if your system lacks the flock() call, else
 * leave them all commented out.
 * N.B., verify that flock() locks are inherited across fork()s, otherwise
 *       use fcntl() locking.
 * N.B., lockf() does not provide advisory locking and requires that files
 *       always be opened O_RDWR or O_WRONLY.  Real flock() or fcntl() locks
 *       are preferred as being more flexible.
 */
#define FCNTL_FLOCK	1	/* Berkeley flock() emulation using fcntl() */
#define LOCKF_FLOCK	1	/* Berkeley flock() emulation using lockf() */

/*
 * Define one of the following.  If your system has both, define HAVE_WAIT3.
 * If your system lacks both, sendmail will fake with wait().
 */
#define HAVE_WAIT3	1	/* has the wait3() call */
#define HAVE_WAITPID	1	/* has the waitpid() call */

/*
 * Routines that provide greater functionality.  Not required for normal
 * operation.
 */
/*#define HAVE_UNAME	1	/* System has the uname() call */

/*
 * Missing routines.  Delete the leading comment characters for any missing
 * routines.
 */
/*#define LACK_VSPRINTF	1	/* need the vsprintf() call */
/*#define LACK_SIGBLOCK	1	/* sigblock() is missing.  Use sigprocmask() */
/*#define LACK_RENAME	1	/* rename() is missing.  Use link()/unlink() */
/*#define LACK_INITGROUPS 1	/* need the initgroups() call */
/*#define LACK_MALLOC	1	/* replace broken malloc() or one that puts */
				/* static data in bss (not saved by freeze()) */
/*#define LACK_STRSEP	1	/* Need the strsep() call for uiuc/phquery.c */
/*#define LACK_SYSLOG	1	/* Need the syslog() call */
/*#define SYSLOG_NOIPC	1	/* To file rather than UNIX domain socket */

/* Define following if compiling using BSD emulation */
/*#define SVR4BSD	1	/* To use BSD direct/dirent on System 5 */

/* Optional features dependent on OS capabilities */
#define SETPROCTITLE_OK	1	/* OK to munge argv for status display via ps */
