#!/bin/csh -f
# usage:
#	cfstrip <infile >outfile
# Bruce Barnett
#
# this file strips out all comments from a sendmail.cf file
# it also converts 
#	<tab>[whitespace] 	to 	<tab>
#	<space>[whitespace]	to	<space>
#	<space>$		to	$
#	<space><		to	<
#	<space>@		to	@
if ( $#argv != 0 ) then
	echo no arguments are allowed
	exit 1
endif
sed -e 's/^#.*//' \
	-e 's/^\(R[^	]*[	][	]*[^	]*\)[	]*.*$/\1/' \
	-e 's/^\(R[^	]*[	][	]*[^	]*\)[	]*$/\1/' \
	-e 's/^\(R[^	]*[	][	]*[^	]*\)$/\1/' \
	-e 's/	[	 ]*/	/g' \
	-e 's/ [	 ]*/ /g' \
	-e 's/ \$/$/g' \
	-e 's/ </</g' \
	-e 's/ @/@/g' \
	 |grep -v '^[ 	]*$'
