#!/bin/csh -f
# Bruce Barnett
# usage:
# cfdiff file1.cf file2.cf
# this removes all comments from the cf file
if ( $#argv != 2 ) then
	echo usage cfdiff file1 file2
	exit 1
endif
onintr bomb
# if SunOS, use the -b -w option
set DIFF = "diff -b"
if ( -f /bin/arch ) then
	if ( `/bin/arch` =~ sun* ) then
		set DIFF = "diff -b -w"
	endif
endif
if ( ! -f $1 ) then
	echo file $1 does not exist
	exit 1
endif
if ( ! -f $2 ) then
	echo file $2 does not exist
	exit 1
endif
cfstrip <$1>/tmp/$1:t
cfstrip <$2>/tmp/$2:t

cd /tmp
${DIFF} $1:t $2:t

bomb:
	/bin/rm /tmp/$1:t /tmp/$2:t
