/*
**  Lexical analyzer for the gag language.  We have our own FSA
**  for comments because it's much smaller and quicker that way.
*/
%{
/* SUPPRESS 15 on yyt *//* Copying a bad pointer */
/* SUPPRESS 25 on yycrank *//* Creating a bad pointer during initialization */
/* SUPPRESS 26 on yyt *//* Storing a bad pointer */
/* SUPPRESS 592 on ncform_sccsid *//* Static variable was not used */
/* SUPPRESS 593 on yyfussy *//* Label was not used */
#include "gate.h"
#include "gag.h"

/* State of our automaton. */
typedef enum _STATE {
    S_STAR, S_NORMAL, S_END
} STATE;

/* Key-value pair. */
typedef struct _PAIR {
    char	*name;
    int		value;
} PAIR;

char		yyfilename[SM_SIZE];
extern int	Errors;

/* List of GAG's keywords. */
STATIC PAIR	Keywords[] = {
    {	"default",		tDEFAULT	},
    {	"directory",		tDIRECTORY	},
    {	"distributions",	tDISTRIBUTIONS	},
    {	"dotify",		tDOTIFY		},
    {	"false",		tFALSE		},
    {	"flags",		tFLAGS		},
    {	"gateway",		tGATEWAY	},
    {	"inews",		tINEWS		},
    {	"mail2news",		tMAIL2NEWS	},
    {	"mailcontact",		tMAILCONTACT	},
    {	"mailhost",		tMAILHOST	},
    {	"mailinglist",		tMAILINGLIST	},
    {	"mailpost",		tMAILPOST	},
    {	"moderator",		tMODERATOR	},
    {	"news2mail",		tNEWS2MAIL	},
    {	"organization",		tORGANIZATION	},
    {	"owner",		tOWNER		},
    {	"request_address",	tREQUESTADDR	},
    {	"site",			tSITE		},
    {	"true",			tTRUE		},
    {	"user",			tUSER		},
    {	NULL,			0		}
};

%}

%%

[-+0-9A-Za-z_.]+	{
		    /* A simple tID or keyword. */
		    register PAIR	*p;

		    /* Keyword? */
		    for (p = Keywords; p->name; p++)
			if (EQ(p->name, yytext))
			    return p->value;
		    yylval.String = COPY(yytext);
		    return tID;
		    /* NOTREACHED */
		}

^#[ \t]+[0-9]+[ \t]+"[^\n]+"[^\n]*$	{
		    /* C pre-processor control line. */
		    register char	*p;
		    char		*namep;

		    /* Find the line number. */
		    for (p = yytext; *p && !isdigit(*p); p++)
			continue;
		    /* Parse the number, find the start of the filename. */
		    for (yylineno = atoi(p); *p && *p != '"'; p++)
			continue;
		    /* March down to the end of the filename. */
		    for (namep = p; *++p && *p != '"'; p++)
			continue;
		    *p = '\0';
		    (void)strncpy(yyfilename, namep, sizeof yyfilename - 1);
		    yyfilename[sizeof yyfilename - 1] = '\0';
		}

\"[^"]*		{
		    /* Quoted string. */
		    int		c;

		    /* See the Lex paper in Volume 2A or PS1:16
		     * for details on this code. */
		    if (yytext[yyleng - 1] == '\\')
			yymore();
		    else {
			if ((c = input()) == '"') {
			    yylval.String = COPY(&yytext[1]);
			    return tID;
			}
			unput(c);
			yyerror("Bad string");
		    }
		}

"/*"	        {
		    /* Comment. */
		    register STATE	S;

		    for (S = S_NORMAL; S != S_END; )
			switch (input()) {
			case '/':
			    if (S == S_STAR) {
				S = S_END;
				break;
			    }
			    /* FALLTHROUGH */
			default:
			    S = S_NORMAL;
			    break;
			case '\0':
			    S = S_END;
			    break;
			case '*':
			    S = S_STAR;
			    break;
			}
		}

[ \t\n]		{
		    /* Tasty whitespace. */
		}

.		{
		    /* Random special character. */
		    return *yytext;
		    /* NOTREACHED */
		}

%%


/*
**  Called by lex at end-of-stream.  Return one if no more input.
*/
int
yywrap()
{
    return 1;
}


yyopen(p)
    char	*p;
{
    if (p == NULL)
	(void)strcpy(yyfilename, "stdin");
    else {
	if ((yyin = fopen(p, "r")) == NULL) {
	    Fprintf(stderr, "%s: Can't open \"%s\" for input, %s.\n",
		    Pname, p, strerror(errno));
	    exit(1);
	}
	(void)strcpy(yyfilename, p);
    }
}


/*
**  Write an error message.
*/
yyerror(p)
    char	*p;
{
    char	buff[SM_SIZE];

    (void)strncpy(buff, yytext, sizeof buff);
    buff[sizeof buff - 1] = '\0';
    Fprintf(stderr, "\"%s\", line %d: %s (near \"%s\")\n",
	    yyfilename, yylineno, p, buff);
    Errors++;
}
