/*
**  SIGNOFF
**  Quickie hack to see of a mail message is a "please drop me" request.
**  Exit's with status 0 if it is a regular message, or 1 if it appears to
**  be a one of this administrative requests that annoy everyone when
**  they're sent to the whole list.  Optional first argument is the name
**  of the input file, or stdin is read if none is given.
**
**  Original program written by Russ Nelson, <nelson@clutx.clarkson.edu>.
**  Severely hacked on by Rich $alz, <rsalz@bbn.com>.  This program is
**  basically incorporated into mail2news; it's pulled out here for
**  demonstration.
**
**  For example, here is a script that could be used as a wrapper around
**  the mail2news program:
**	#! /bin/sh
**	cat >/tmp/signoff$$
**	if /usr/lib/news/signoff </tmp/signoff$$ ; then
**	    /usr/ucb/Mail -s "Sign on/off request" usenet </tmp/signoff$$
**	else
**	    /usr/lib/news/mail2news.real </tmp/signoff$$
**	fi
**	exec rm /tmp/signoff$$
**
**  Russ ran the following test for a month and got only one real message
**  (a gnu.gcc bug report) treated as a subscription request.  He doesn't
**  know how many subs made it out to the net, tho:  that would entail
**  reading ALL netnews articles -- yuck!
**
**  Put the following line in your news sys file:
**	allmail:all::/usr/lib/news/ts
**  here is the "ts" script:
**	#! /bin/sh
**	cat >/tmp/ts.$$
**	/usr/lib/news/signoff </tmp/ts.$$ || mail usenet </tmp/ts.$$
**	exec rm /tmp/ts.$$
**
**  Perhaps a better way to test is to make the test less conservative,
**  and see what "real" articles get caught, and make adjustments then?
**  Comments solicited.
*/
#include <stdio.h>
#include <ctype.h>

#define EQ(a, b)		(strcmp((a), (b)) == 0)


main(ac, av)
    int			ac;
    char		*av[];
{
    register FILE	*F;
    register char	*p;
    register int	c;
    register int	drop_or_add;
    register int	from_or_to;
    register int	mail_word;
    register int	count;
    char		word[128];

    /* Get input. */
    if (ac < 2)
	F = stdin;
    else if ((F = fopen(av[1], "r")) == NULL) {
	(void)fprintf(stderr, "%s: cannot open %s\n", av[0], av[1]);
	exit(1);
    }

    /* Skip headers by waiting for the first blank line. */
    while (fgets(word, sizeof word, F) && *word != '\n')
	    ;

    /* Clear counts. */
    drop_or_add = 0;
    from_or_to = 0;
    mail_word = 0;
    count = 0;

    /* Read input a word at a time. */
    for (p = word; (c = getc(F)) != EOF; ) {
	if (!isalpha(c)) {
	    *p = '\0';
	    if (p > word)
		count++;
	    p = word;

	    if (EQ(word, "remove") || EQ(word, "drop") || EQ(word, "off")
	     || EQ(word, "subscribe") || EQ(word, "get") || EQ(word, "add"))
		drop_or_add++;
	    else if (EQ(word, "from") || EQ(word, "to"))
		from_or_to++;
	    else if (EQ(word, "mail") || EQ(word, "mailing")
		  || EQ(word, "list") || EQ(word, "dl"))
		mail_word++;
	}
	else if (p < &word[sizeof word - 1])
	    *p++ = isupper(c) ? tolower(c) : c;
    }

    (void)fclose(F);

    /* Use fancy-shmancy AI techniques to determine what the message is. */
    c = count < 25 && drop_or_add && from_or_to && mail_word;

#if	defined(DEBUG)
    printf("%s: %d words, %d drop, %d mail --> %s\n",
	   av[1] ? av[1] : "<stdin>",
	   count, drop_or_add, mail_word,
	   c ? "yes" : "no");
#endif	/* defined(DEBUG) */

    /* Exit appropriately. */
    exit(c ? 0 : 1);
}
