set boundindex 1

proc bogo__bogo_ {switches envelope inputs} {
    global boundindex
    set fname "| _bin_/lcat _spooldir_/services._bogo_"
    if {[catch "set fid [open $fname w]"]==0} {
      dumpenv $envelope $fid
      dumpbody $inputs $fid
    close $fid
}
}

proc dumpenv {envelope fid} {
      set size [llength $envelope]
      set size [expr $size/2]
      puts $fid "From [getfield $envelope FROM] Thu Jan 01 00:00:00 1970"
      for {set i 0} {$i<=$size} {incr i} {
        if {[string length [lindex $envelope [expr {$i*2}]]]==0} continue
        puts $fid [lindex $envelope [expr {$i*2}]] nonewline
        puts $fid ": " nonewline
        puts $fid [lindex $envelope [expr {$i*2+1}]]
      }
      puts $fid ""
}

proc dumpbody {inputs fid} {
  global boundindex 
  puts $fid "Content-Type: " nonewline
  if {[getfield $inputs TYPE]=="multipart"} {
    set parts [getfield $inputs PARTS]
    set size [expr {[llength $parts]-1}]
    incr boundindex
    set boundary mumblemumble$boundindex
    puts $fid multipart/ nonewline
    puts $fid [getfield $inputs SUBTYPE]\;
    puts $fid "  boundary=\"$boundary\""
    for {set i 0} {$i<=$size} {incr i} {
      puts $fid --$boundary
      dumpbody [lindex $parts $i] $fid
    }
    puts $fid --$boundary--
    puts $fid ""
  } else {
    puts $fid [getfield $inputs TYPE]/[getfield $inputs SUBTYPE]
    puts $fid ""
    if {[catch "set fd2 [open [getfield $inputs FILE] r]"]==0} {
      for {} {1} {} {
        set tmp [gets $fd2]
        if {$tmp == ""} {
          if {[eof $fd2] == 1} {
            close $fd2
            break
          }
        }
        puts $fid $tmp
      }
    } else {
    puts $fid ""
    }
  }
}    
      

  
  

      
      
    
