# stock: respond with stock quote info
#
# salil@eitech.com
#
# this service works on a local database with a special format;
# we include it merely as an example

proc stock {switches envelope inputs} {
   set stockfile [glob ~/lib/stocks];
   set symbolfile [glob ~/lib/symbols];
   set badsymerr [glob ~/lib/bad.symbol.err];
   if {[lindex $switches 0] == "history"} {
      set symbol [lindex $switches 1];
      set pattern (^${symbol}\ |from\ host|volume) ;
      set badsym [catch {exec /usr/bin/egrep -i $symbol $symbolfile}];
      if {$badsym} {
	 setfield response STRING [exec cat $badsymerr $symbolfile];
      } else {
	 setfield response STRING [exec /usr/bin/egrep -i $pattern $stockfile];
      }
   } else {
      set symbol [lindex $switches 0];
      set pattern (^${symbol}\ |from\ host|volume) ;
      set badsym [catch {exec /usr/bin/egrep -i $symbol $symbolfile}];
      if {$badsym} {
	 setfield response STRING [exec cat $badsymerr $symbolfile];
      } else {
	 setfield response STRING [exec /usr/bin/egrep -i $pattern $stockfile | tail -3];
      }
   }
   return [mailout [turnaround $envelope] $response];
}