/******************************************************************************
 * Include xpi_utils.h - Public definitions for analysis tool utilities
 *
 * Written:	06/13/91 by John H. Lee
 * Last Change:	06/13/91 by John H. Lee
 * Bersion:	0.1
 ******************************************************************************
 * Revisions:
 *   0.1  06/13/91 JHL  Initial Creation
 *****************************************************************************/

#ifndef	_XPI_UTILS_H
#define	_XPI_UTILS_H

#include <X11/Intrinsic.h>
#include <sys/types.h>

#ifdef	__ARGS(a)
#undef	__ARGS(a)
#endif	__ARGS(a)
#ifdef	_NO_PROTO		/* Use function prototypes?		*/
#define	__ARGS(a)	()	/* Nope, drop arg list			*/
#else
#define	__ARGS(a)	a	/* Yes, include arg list		*/
#endif	_NO_PROTO


/*** Type Definitions ***/

typedef struct EvDialogStruct {	/* Evaluator dialog			*/
	Widget	dialog,		/* Dialog box				*/
		message_lbl,	/* Message label			*/
		value_lbl,	/* Value label				*/
		scroll_bar,	/* Value scrollbar			*/
		button_sep,	/* Pushbutton separator			*/
		ok_btn,		/* OK pushbutton			*/
		cancel_btn;	/* Cancel pushbutton			*/
} *EvDialog;

typedef struct LiDialogStruct {	/* List box dialog			*/
	Widget	dialog,		/* Dialog box				*/
		form,		/* Dialog form				*/
		message_lbl,	/* Message label			*/
		header_lbl,	/* List box header			*/
		list,		/* List box				*/
		value_lbl,	/* Value label				*/
		ok_btn,		/* OK pushbutton			*/
		cancel_btn;	/* Cancel pushbutton			*/
} *LiDialog;


/*** Public Function Definitions ***/

#if	defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif
				/* Message dialog functions		*/
extern void	SetMessageDialog __ARGS((Widget wd, Widget shell,
			XmString title_str, XmString message_str,
			XmString ok_str, XmString cancel_str));

				/* Evaluator dialog functions		*/
extern EvDialog	CreateEvaluatorDialog __ARGS((Widget parent));
extern void	SetEvaluatorDialog __ARGS((EvDialog ev, Widget shell,
			XmString title_str, XmString message_str,
			XmString value_str));

				/* List dialog functions		*/
extern LiDialog	CreateListDialog __ARGS((Widget parent));
extern void	SetListDialog __ARGS((LiDialog li, Widget shell,
			XmString title_str, XmString message_str,
			XmString header_str, XmString value_str));

#if	defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif	_XPI_UTILS_H
/* DON'T ADD ANYTHING AFTER THIS #endif */

/***************************** End of xpi_utils.h ****************************/

