/******************************************************************************
 * Module xpi_tools.c - Tool management routines for xperfisis
 *
 * Written:	 06/01/91 by John H. Lee
 * Last Changed: 06/17/91 by John H. Lee
 * Version:	 0.2
 ******************************************************************************
 * Description:
 *
 *	This module contains the routines to create and destroy tools.
 ******************************************************************************
 * Exports:
 *	Tool CreateTool()		Create new instance of a tool class
 *	void DestroyTool()		Destroy a tool class instance
 *
 * Imports:
 * 	None
 ******************************************************************************
 * Revisions:
 *   0.1   06/01/91 JHL  Initial Creation
 *   0.2   06/17/91 JHL  Added function prototypes
 *****************************************************************************/

#include <isis.h>
#include "xperfisis.h"
#include "xpi_tooldefs.h"
#include "xpi_tools.h"



/******************************************************************************
 *
 *	Tool Instance Creation/Destruction
 *
 *****************************************************************************/

#ifdef	_NO_PROTO
Tool CreateTool(tool_class, app_win)
ToolClass	tool_class;
AppWindow	*app_win;
#else
Tool CreateTool(ToolClass tool_class, AppWindow *app_win)
#endif	_NO_PROTO
{
Tool		t;


				/* Allocate instance record		*/
	t = (Tool)XtCalloc(1, tool_class->instance_size);
	t->common.class_rec = tool_class;
	t->common.app_win = app_win;
				/* Initialized class if needed		*/
	if (!t->common.class_rec->class_initialized) {
	    if (t->common.class_rec->class_init != NULL)
		    (*t->common.class_rec->class_init)();
	    t->common.class_rec->class_initialized = True;
	} /* if */
				/* Initialize instance			*/
	if (t->common.class_rec->init != NULL)
		(*t->common.class_rec->init)(t);

	return (t);
} /* function CreateTool */




#ifdef	_NO_PROTO
void DestroyTool(t)
Tool	t;
#else
void DestroyTool(Tool t)
#endif	_NO_PROTO
{
	if (t->common.class_rec->destroy != NULL)
		(*t->common.class_rec->destroy)(t);
	XtFree(t);
} /* function DestroyTool */

/**************************** End of xpi_tools.c *****************************/
