/******************************************************************************
 * Include xpi_tooldefs.h - Public definitions for performance analysis tools
 *
 * Written:	05/20/91 by John H. Lee
 * Last Change:	05/20/91 by John H. Lee
 * Bersion:	0.1
 ******************************************************************************
 * Revisions:
 *   0.1  05/20/91 JHL  Initial Creation
 *****************************************************************************/

#ifndef	_XPI_TOOLDEFS_H
#define	_XPI_TOOLDEFS_H

#include <X11/Intrinsic.h>
#include <sys/types.h>

#include "xperfisis.h"


/*** Type Definitions ***/

typedef struct {		/* Tool class record			*/
	char		*title;
	char		*menu_name;
	void		(*class_init)();
	void		(*init)();
	void		(*destroy)();
	unsigned	instance_size;
	Boolean		class_initialized;
} ToolClassRec, *ToolClass;


typedef struct {		/* Common part of tool instance record	*/
	ToolClass			class_rec;
	struct _AppWindow_Struct	*app_win;
} ToolCommonPart;


typedef struct _ToolRec_Struct {/* Generic tool instance record		*/
	ToolCommonPart	common;
} ToolRec;


typedef ToolRec		*Tool;	/* Generic tool instance 		*/



/*** Public Global Variable Definitions ***/
				/* List of tools available		*/
extern ToolClass	*ToolsList;


#endif	_XPI_TOOLDEFS_H
/* DON'T ADD ANYTHING AFTER THIS #endif */

/*************************** End of xpi_tooldefs.h ***************************/

