/******************************************************************************
 * Include xperfisis.h - Common definitions for ISIS performance tool for X
 *
 * Written:	 05/14/91 by John H. Lee
 * Last Changed: 05/14/91 by John H. Lee
 * Version:	 0.1
 ******************************************************************************
 * Revisions:
 *   0.1  05/14/91 JHL Initial Creation
 *****************************************************************************/

#ifndef	_XPERFISIS_H_
#define	_XPERFISIS_H_

#include <X11/Intrinsic.h>	/* "System" include files		*/
#include <Xm/Xm.h>
#include "isis.h"
#include "perfisis.h"


#ifdef	__ARGS(a)		/* Function prototype definition macro	*/
#undef	__ARGS(a)
#endif	__ARGS(a)
#ifdef	_NO_PROTO
#define	__ARGS(a)	()
#else
#define	__ARGS(a)	a
#endif	_NO_PROTO


#include "xpi_tooldefs.h"	/* "Local" include files		*/
#include "xpi_notify.h"
#include "xpi_utils.h"



/*** Type Definitions **/

typedef struct _AppWindow_Struct {
	int		win_index;
	XtAppContext	app_context;
	address		*gaddr_p;
	Widget		shell,
			main_win,
			menu_bar,
			main_form,
			tool_frame,
			tool_form,
			info_frame,
			info_lbl;
	Widget		warn_dlg;
	struct _ToolRec_Struct		*tool;
	char		*title;
} AppWindow;


/*** Definitions for Program-wide Public Globals ***/

extern Display	*AppDisplay;	/* Application display connection	*/
extern char	*AppName;	/* Application name			*/
extern char	*AppClass;	/* Application class			*/
extern XtAppContext AppContext;	/* Application context			*/
extern address	*GAddr_P;	/* perfserver ISIS group address	*/

extern AppWindow **AppWindows;	/* Application windows array		*/
extern int	AppWindowsSize;	/* Size of Application window array	*/
extern int	AppWindowsOpen;	/* Number of application windows open	*/


#endif	_XPERFISIS_H_
/* DON'T ADD ANYTHING AFTER #endif */

/**************************** End of xperfisis.h *****************************/
