/******************************************************************************
 * Program ps_transact.c - ISIS performance server, transaction test routines
 *
 * Written:	 06/19/91 by John H. Lee
 * Last Changed: 06/19/91 by John H. Lee
 * Version:	 0.1
 ******************************************************************************
 * Description:
 *
 *	This module contains the Transaction Manager portion of the
 * transaction model test routines.
 ******************************************************************************
 * Revisions:
 *   0.1    06/19/91 JHL  Initial Creation
 *****************************************************************************/

#include <stdio.h>
#include <errno.h>
#include <sys/time.h>
#include "isis.h"
#include "perfisis.h"
#include "perfserverDM.h"
#include "ps_transact.h"




				/* Data Manager group access token name	*/
#define	DMACCESSTOKENNAME	"/perfserver/DMAccessToken"


/*** External globals ***/

extern address	*GAddrP;	/* Our group address			*/


/*** Public globals ***/

				/* Data manager group address		*/
static address	*DMGAddrP = NULL;





/******************************************************************************
 *
 *	Initialization
 *		If we're being used for the first time, lookup the Data
 *	Manager group and join as a client.  Return is 0 if join was
 *	successful, -1 if not.
 *
 *****************************************************************************/

static int Initialize()
{
	if (addr_isnull(DMGAddrP = pg_lookup(PERFSERVDMNAME))) {
	    DMGAddrP = NULL;
	    return (-1);
	} /* if */
	if (pg_client(DMGAddrP, "") == -1) {
	    DMGAddrP = NULL;
	    return (-1);
	} /* if */

	return (0);
} /* function Initialize */

/******************************************************************************
 *
 *	Private Routines
 *
 *****************************************************************************/

/*** Reply to performance server client ***/

static void SendReply(msg_p, status, transtime_norm, rw_time_avg)
message	*msg_p;			/* Pointer to entry message		*/
int	status,			/* Operation status			*/
	transtime_norm,		/* Normalized Transaction time, msecs	*/
	rw_time_avg;		/* Average DM R/W time, msecs		*/
{
	reply(msg_p, "%d,%d,%d", status, transtime_norm, rw_time_avg);
} /* function SendReply */

/******************************************************************************
 *
 *	Entry Point Routines
 *
 *****************************************************************************/

/*** Transactions using ABCast ***/

int do_transaction_abcast(msg_p)
message	*msg_p;
{
int		dm_size,
		num_read,
		num_write,
		packet_size;
char		*packet;
int		i,
		dm_group_size,
		elapsed;
struct timeval	t_start,
		t_end;
groupview	*dm_gv;


				/* Do initialization if needed		*/
	if ((DMGAddrP == NULL) && Initialize())
		SendReply(msg_p, RET_NOGROUP, 0, 0);

				/* Get test parameters			*/
	msg_get(msg_p, "%d,%d,%d,%d", &dm_size, &num_read, &num_write,
		&packet_size);
				/* Determine DM group size		*/
	dm_gv = pg_getview(DMGAddrP);
	dm_group_size = dm_gv->gv_nmemb;
				/* Allocate data packet (no need to init) */
	packet = malloc(packet_size);


	/*** Test section ***/
				/* Get starting time			*/
	(void)gettimeofday(&t_start, NULL);
				/* Perform DM writes			*/
	for (i=num_write; i > 0; i--) {
	    abcast(DMGAddrP, DM_WRITE, "%d,%C",
		    my_site_no, packet, packet_size,
		    0);
	} /* for */
				/* Commit transaction			*/
	abcast(DMGAddrP, DM_COMMIT, "%d", my_site_no, 0);
				/* Get ending time			*/
	(void)gettimeofday(&t_end, NULL);

				/* Calculate total elapsed time		*/
	elapsed = (t_end.tv_sec * 1000000 + t_end.tv_usec)
		- (t_start.tv_sec * 1000000 + t_start.tv_usec);

				/* Return timings			*/
	SendReply(msg_p, RET_OK,
		(elapsed / dm_group_size),
		(elapsed / num_write));
} /* function transaction_abcast */





/*** Transactions using Token Passing ***/

int do_transaction_token(msg_p)
message	*msg_p;
{
int		dm_size,
		num_read,
		num_write,
		packet_size;
char		*packet;
int		i,
		dm_group_size,
		elapsed;
struct timeval	t_start,
		t_end;
groupview	*dm_gv;


				/* Do initialization if needed		*/
	if ((DMGAddrP == NULL) && Initialize())
		SendReply(msg_p, RET_NOGROUP, 0, 0);

				/* Get test parameters			*/
	msg_get(msg_p, "%d,%d,%d,%d", &dm_size, &num_read, &num_write,
		&packet_size);
				/* Determine DM group size		*/
	dm_gv = pg_getview(DMGAddrP);
	dm_group_size = dm_gv->gv_nmemb;
				/* Allocate data packet (no need to init) */
	packet = malloc(packet_size);


	/*** Test section ***/
				/* Get DM access token			*/
	t_request(GAddrP, DMACCESSTOKENNAME, TRUE);
				/* Get starting time			*/
	(void)gettimeofday(&t_start, NULL);
				/* Perform DM writes			*/
	for (i=num_write; i > 0; i--) {
	    cbcast(DMGAddrP, DM_WRITE, "%d,%C",
		    my_site_no, packet, packet_size,
		    0);
	} /* for */
				/* Commit transaction			*/
	cbcast(DMGAddrP, DM_COMMIT, "%d", my_site_no, 0);
				/* Get ending time			*/
	(void)gettimeofday(&t_end, NULL);
				/* Pass token on			*/
	t_pass(GAddrP, DMACCESSTOKENNAME);

				/* Calculate total elapsed time		*/
	elapsed = (t_end.tv_sec * 1000000 + t_end.tv_usec)
		- (t_start.tv_sec * 1000000 + t_start.tv_usec);

				/* Return timings			*/
	SendReply(msg_p, RET_OK,
		(elapsed / dm_group_size),
		(elapsed / num_write));
} /* function transaction_token */





/*** Transactions using Quorum Agreement ***/

int do_transaction_quorum(msg_p)
message	*msg_p;
{
int		dm_size,
		num_read,
		num_write,
		packet_size;
char		*packet;
int		i,
		dm_group_size,
		elapsed;
struct timeval	t_start,
		t_end;
groupview	*dm_gv;


				/* Do initialization if needed		*/
	if ((DMGAddrP == NULL) && Initialize())
		SendReply(msg_p, RET_NOGROUP, 0, 0);

				/* Get test parameters			*/
	msg_get(msg_p, "%d,%d,%d,%d", &dm_size, &num_read, &num_write,
		&packet_size);
	/*### Later, we'll determine and set the read and write DM groups
	 * here, picking a random majority of the DM's			*/
				/* Determine DM group size		*/
	dm_gv = pg_getview(DMGAddrP);
	dm_group_size = dm_gv->gv_nmemb;
				/* Allocate data packet (no need to init) */
	packet = malloc(packet_size);


	/*** Test section ***/
				/* Get starting time			*/
	(void)gettimeofday(&t_start, NULL);
				/* Perform DM writes			*/
	for (i=num_write; i > 0; i--) {
	    cbcast(DMGAddrP, DM_WRITE, "%d,%C",
		    my_site_no, packet, packet_size,
		    0);
	} /* for */
				/* Commit transaction			*/
	abcast(DMGAddrP, DM_COMMIT, "%d", my_site_no, 0);

				/* Calculate total elapsed time		*/
	elapsed = (t_end.tv_sec * 1000000 + t_end.tv_usec)
		- (t_start.tv_sec * 1000000 + t_start.tv_usec);

				/* Return timings			*/
	SendReply(msg_p, RET_OK,
		(elapsed / dm_group_size),
		(elapsed / num_write));
} /* function transaction_quorum */

/**************************** End of ps_transact.c ***************************/
