/******************************************************************************
 * Include xpi_notify.h - Public defs for xperfisis notification routines
 *
 * Written:	 06/18/91 by John H. Lee
 * Last Changed: 06/18/91 by John H. Lee
 * Version:	 0.1
 ******************************************************************************
 * Revisions:
 *   0.1  06/18/91 JHL  Initial Creation
 *****************************************************************************/

#ifndef	_XPI_NOTIFY_H
#define	_XPI_NOTIFY_H

#include <sys/types.h>
#include "xperfisis.h"


/*** Type Definitions ***/

typedef struct _NotifyList_Struct	*NotifyList;


/*** Public Function Definitions ***/

#if	defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif
				/* Initialize notify list		*/
extern NotifyList CreateNotifyList __ARGS((void));
				/* Destroy notify list			*/
extern void	DestroyNotifyList __ARGS((NotifyList nl));
				/* Set function to call when notify done */
extern void	SetNotifyDoneProc __ARGS((NotifyList nl,
			void (*done_proc)(), caddr_t done_proc_arg));
				/* Add procedure to notify list		*/
extern void	AddNotify __ARGS((Tool tool, NotifyList nl,
			void (*callback_proc), caddr_t client_data));
				/* Remove procedure from notify list	*/
extern void	RemoveNotify __ARGS((Tool tool, NotifyList nl,
			void (*callback_proc), caddr_t client_data));
				/* Trigger to invoke notify procs when safe */
extern void	TriggerNotify __ARGS((NotifyList nl, caddr_t call_data));
				/* Invoke procs of next triggered notify list*/
extern Bool	HandleNextNotify __ARGS((void));
				/* Invoke procs of all triggered notify lists*/
extern Bool	HandleNotify __ARGS((void));

#if	defined(__cplusplus) || defined(c_plusplus)
}
#endif


#endif	_XPI_NOTIFY_H
/* DON'T ADD ANYTHING AFTER THIS #endif */

/**************************** End of xpi_notify.h ****************************/
