/******************************************************************************
 * Module xpi_TLdefault.c - Default tool for xperfisis
 *
 * Written:	 06/20/91 by John H. Lee
 * Last Changed: 06/20/91 by John H. Lee
 * Version:	 0.1
 ******************************************************************************
 * Description:
 *	This is the default tool loaded for a newly create application window.
 * Currently it does nothing but determine the initial size of the window.
 ******************************************************************************
 * Exports:
 *	ToolClass defaultToolClass	Tool class record pointer
 *
 * Imports:
 * 	None
 ******************************************************************************
 * Revisions:
 *   0.1   06/20/91 JHL  Initial Creation
 *****************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Core.h>
#include <Xm/Xm.h>

#include "xperfisis.h"
#include "xpi_tooldefs.h"
#include "xpi_TLdefault.h"






/*** Tool Class Functions ***/

static void	Init();





/*** Tool Instance Record ***/

struct _DefaultToolRec_Struct {
	ToolCommonPart	common;
};
typedef struct _DefaultToolRec_Struct	DefaultToolRec;



/*** Tool Class Record ***/

static ToolClassRec	defaultToolClassRec = {
    /* tool_title		*/ "(None)",
    /* menu_name		*/ "Default",
    /* class_init		*/ NULL,
    /* init			*/ Init,
    /* destroy			*/ NULL,
    /* instance_size		*/ sizeof(DefaultToolRec),
    /* class_initialized	*/ False
};

ToolClass	defaultToolClass = &defaultToolClassRec;

/******************************************************************************
 *
 *	Initialization
 *
 *		This procedure is called to initialized a new instance of
 *	this tool class.  It is called exactly once per new instance by
 *	CreateTool().
 *
 *****************************************************************************/

static void Init(t)
Tool		t;
{
int		n;
Arg		args[5];


				/* Create empty widget to take up space	*/
	n = 0;
	XtSetArg(args[n], XtNwidth, 400);				n++;
	XtSetArg(args[n], XtNheight, 300);				n++;
	XtCreateManagedWidget("space", xmPrimitiveWidgetClass,
		t->common.app_win->tool_form, args, n);

				/* Force tool form to resize		*/
	n = 0;
	XtSetArg(args[n], XmNwidth, 0);					n++;
	XtSetArg(args[n], XmNheight, 0);				n++;
	XtSetValues(t->common.app_win->tool_form);
} /* function Init */

/************************** End of xpi_TLdefault.c ***************************/
