/******************************************************************************
 * Module xpi_utils.c - Misc routines for xperfisis analysis tools
 *
 * Written:	06/13/91 by John H. Lee
 * Last Change:	06/13/91 by John H. Lee
 * Version:	0.1
 ******************************************************************************
 * Description:
 *
 *	This module contains various convenience routines that tools can
 * use.  Currently, the routines deal with dialogs and allow easy use of
 * various non-standard popups.
 ******************************************************************************
 * Revisions:
 *   0.1  06/13/91 JHL  Initial Creation
 *****************************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>
#include <Xm/Xm.h>
#include <Xm/BulletinB.h>
#include <Xm/Form.h>
#include <Xm/LabelG.h>
#include <Xm/List.h>
#include <Xm/MessageB.h>
#include <Xm/PushBG.h>
#include <Xm/ScrollBar.h>
#include <Xm/SeparatoG.h>

#include "xperfisis.h"
#include "xpi_utils.h"





/******************************************************************************
 *
 *	Message Dialog - Standard message-giving Dialog box
 *
 *****************************************************************************/

#ifdef	_NO_PROTO
void SetMessageDialog(md, shell, title_str, message_str, ok_str,
	cancel_str)
Widget		md;
Widget		shell;
XmString	title_str,
		message_str,
		ok_str,
		cancel_str;
#else
void SetMessageDialog(Widget md, Widget shell, XmString title_str,
	XmString message_str, XmString ok_str, XmString cancel_str)
#endif	_NO_PROTO
{
Widget	button;
Arg	args[5];
int	n;


	n = 0;
	if (title_str != NULL) {	/* Set dialog title		*/
	    XtSetArg(args[n], XmNdialogTitle, title_str);		n++;
	} /* if */
	if (message_str != NULL) {	/* Set message 			*/
	    XtSetArg(args[n], XmNmessageString, message_str);		n++;
	} /* if */
					/* Set OK button string		*/
	if (ok_str != NULL && !XmStringEmpty(ok_str)) {
	    XtSetArg(args[n], XmNokLabelString, ok_str);		n++;
	} /* if */
					/* Set Cancel button string	*/
	if (cancel_str != NULL && !XmStringEmpty(cancel_str)) {
	    XtSetArg(args[n], XmNcancelLabelString, cancel_str);	n++;
	} /* if */
	if (n != 0) XtSetValues(md, args, n);

					/* Manage/Unmanage desired buttons */
	button = XmMessageBoxGetChild(md, XmDIALOG_OK_BUTTON);
	if (ok_str != NULL && XmStringEmpty(ok_str))
		XtUnmanageChild(button);
	else	XtManageChild(button);
	button = XmMessageBoxGetChild(md, XmDIALOG_CANCEL_BUTTON);
	if (cancel_str != NULL && XmStringEmpty(cancel_str))
		XtUnmanageChild(button);
	else	XtManageChild(button);

	if (shell != NULL) {	/* Set dialog shell position		*/
	    XtSetArg(args[n], XmNx, shell->core.x + (shell->core.width
		       - XtParent(md)->core.width) / 2);		n++;
	    XtSetArg(args[n], XmNy, shell->core.y + (shell->core.height
		       - XtParent(md)->core.height) / 2);		n++;
	    XtSetValues(XtParent(md), args, n);
	} /* if */
} /* function SetMessageDialog */

/******************************************************************************
 *
 *	Evaluator Dialog - Dialog box with scrollbar for setting numeric values
 *
 *****************************************************************************/

#ifdef	_NO_PROTO
EvDialog CreateEvaluatorDialog(parent)
Widget	parent;
#else
EvDialog CreateEvaluatorDialog (Widget parent)
#endif	_NO_PROTO
{
EvDialog	ev;
Widget		dlg_sep;

Arg		args[5];
int		n;


	ev = (EvDialog)XtMalloc(sizeof(struct EvDialogStruct));


	/*** Create evaluator dialog ***/

	n = 0;
	XtSetArg(args[n], XmNallowOverlap, True);			n++;
	XtSetArg(args[n], XmNautoUnmanage, True);			n++;
	XtSetArg(args[n], XmNdialogStyle,
		XmDIALOG_PRIMARY_APPLICATION_MODAL);			n++;
	ev->dialog = XmCreateBulletinBoardDialog(parent,
		"evaluator_dialog", args, n);
	

				/* Message label gadget			*/
	n = 0;
	ev->message_lbl = XmCreateLabelGadget(ev->dialog,
		"message_lbl", args, n);
	XtManageChild(ev->message_lbl);
				/* Granularity value label gadget	*/
	n = 0;
	ev->value_lbl = XmCreateLabelGadget(ev->dialog, "value_lbl", args, n);
	XtManageChild(ev->value_lbl);

				/* Granularity scrollbar		*/
	n = 0;
	XtSetArg(args[n], XmNorientation, XmHORIZONTAL);		n++;
	ev->scroll_bar = XmCreateScrollBar(ev->dialog, "scroll_bar", args, n);
	XtManageChild(ev->scroll_bar);

				/* Separator to separate buttons	*/
	n = 0;
	ev->button_sep = XmCreateSeparatorGadget(ev->dialog,
		"button_sep", args, n);
	XtManageChild(ev->button_sep);

				/* OK pushbutton			*/
	n = 0;
	XtSetArg(args[n], XmNmarginHeight, 4);				n++;
	XtSetArg(args[n], XmNmarginWidth, 4);				n++;
	ev->ok_btn = XmCreatePushButtonGadget(ev->dialog,
		"  OK  ", args, n);
	XtManageChild(ev->ok_btn);

				/* Cancel pushbutton			*/
	n = 0;
	XtSetArg(args[n], XmNmarginHeight, 4);				n++;
	XtSetArg(args[n], XmNmarginWidth, 4);				n++;
	ev->cancel_btn = XmCreatePushButtonGadget(ev->dialog,
		"Cancel", args, n);
	XtManageChild(ev->cancel_btn);

				/* Set default button			*/
	n = 0;
	XtSetArg(args[n], XmNdefaultButton, ev->ok_btn);		n++;
	XtSetValues(ev->dialog, args, n);


	return (ev);
} /* function CreateEvaluatorDialog */






#ifdef	_NO_PROTO
void SetEvaluatorDialog(ev, shell, title_str, message_str, value_str)
EvDialog	ev;
Widget		shell;
XmString	title_str,
		message_str, 
		value_str;
#else
void SetEvaluatorDialog (EvDialog ev, Widget shell, XmString title_str,
	XmString message_str, XmString value_str)
#endif	_NO_PROTO
{
Dimension	dlg_margin_width,
		dlg_margin_height,
		shadow;
Arg	args[5];
int	n;


				/* Get dialog's margins			*/
	n = 0;
	XtSetArg(args[n], XmNmarginWidth, &dlg_margin_width);		n++;
	XtSetArg(args[n], XmNmarginHeight, &dlg_margin_height);		n++;
	XtSetArg(args[n], XmNshadowThickness, &shadow);			n++;
	XtGetValues(ev->dialog, args, n);
	dlg_margin_width  += shadow;
	dlg_margin_height += shadow;

				/* Set message label gadget		*/
	n = 0;
	if (message_str != NULL) {
	    XtSetArg(args[n], XmNlabelString, message_str);		n++;
	} /* if */
	XtSetArg(args[n], XmNx, dlg_margin_width);			n++;
	XtSetArg(args[n], XmNy, dlg_margin_height);			n++;
	XtSetValues(ev->message_lbl, args, n);

				/* Set dialog title & width		*/
	n = 0;
	if (title_str != NULL) {
	    XtSetArg(args[n], XmNdialogTitle, title_str);		n++;
	} /* if */
	XtSetArg(args[n], XmNwidth, ev->message_lbl->core.width
		+ 2 * dlg_margin_width);				n++;
	XtSetValues(ev->dialog, args, n);

				/* Dialog value label gadget		*/
	if (value_str != NULL) {
	    n = 0;
	    XtSetArg(args[n], XmNlabelString, value_str);		n++;
	    XtSetValues(ev->value_lbl, args, n);
	} /* if */
	n = 0;
	XtSetArg(args[n], XmNx, (ev->dialog->core.width
		- ev->value_lbl->core.width
		- 2 * ev->value_lbl->core.border_width) / 2);		n++;
	XtSetArg(args[n], XmNy, ev->message_lbl->core.y
		+ ev->message_lbl->core.height
		+ 2 * ev->message_lbl->core.border_width + 5);		n++;
	XtSetValues(ev->value_lbl, args, n);

				/* Value scrollbar			*/
	n = 0;
	XtSetArg(args[n], XmNx, dlg_margin_width);			n++;
	XtSetArg(args[n], XmNy, ev->value_lbl->core.y
		+ ev->value_lbl->core.height
		+ 2 * ev->value_lbl->core.border_width + 5);		n++;
	XtSetArg(args[n], XmNwidth, ev->dialog->core.width
		- 2 * dlg_margin_width);				n++;
	XtSetValues(ev->scroll_bar, args, n);

				/* Button separator			*/
	n = 0;
	XtSetArg(args[n], XmNwidth, ev->dialog->core.width
		- 2 * dlg_margin_width);				n++;
	XtSetArg(args[n], XmNx, 0);					n++;
	XtSetArg(args[n], XmNy, ev->scroll_bar->core.y
		+ ev->scroll_bar->core.height
		+ 2 * ev->scroll_bar->core.border_width + 10);		n++;
	XtSetValues(ev->button_sep, args, n);

				/* OK pushbutton			*/
	n = 0;
	XtSetArg(args[n], XmNx, ev->dialog->core.width / 10);		n++;
	XtSetArg(args[n], XmNy, ev->button_sep->core.y
		+ ev->button_sep->core.height
		+ 2 * ev->button_sep->core.border_width + 10);		n++;
	XtSetValues(ev->ok_btn, args, n);

				/* Cancel pushbutton			*/
	n = 0;
	XtSetArg(args[n], XmNx, (int)(ev->dialog->core.width * 0.90)
		- ev->cancel_btn->core.width
		- 2 * ev->cancel_btn->core.border_width);		n++;
	XtSetArg(args[n], XmNy, ev->button_sep->core.y
		+ ev->button_sep->core.height
		+ 2 * ev->button_sep->core.border_width + 10);		n++;
	XtSetValues(ev->cancel_btn, args, n);

	if (shell != NULL) {	/* Set dialog shell position		*/
	    XtSetArg(args[n], XmNx, shell->core.x + (shell->core.width
		       - XtParent(ev->dialog)->core.width) / 2);	n++;
	    XtSetArg(args[n], XmNy, shell->core.y + (shell->core.height
		       - XtParent(ev->dialog)->core.height) / 2);	n++;
	    XtSetValues(XtParent(ev->dialog), args, n);
	} /* if */
} /* function SetEvaluatorDialog */

/******************************************************************************
 *
 *	List Dialog - Dialog box with list box
 *
 *****************************************************************************/

#ifdef	_NO_PROTO
LiDialog CreateListDialog(parent)
Widget	parent;
#else
LiDialog CreateListDialog(Widget parent)
#endif	_NO_PROTO
{
LiDialog	li;
Widget		dlg_sep;
Dimension	dlg_shadow,
		margin_width,
		shadow_width;
Arg		args[10];
int		n;


	li = (LiDialog)XtMalloc(sizeof(struct LiDialogStruct));


	/*** Create List Box dialog ***/

	n = 0;
	XtSetArg(args[n], XmNallowOverlap, True);			n++;
	XtSetArg(args[n], XmNautoUnmanage, True);			n++;
	XtSetArg(args[n], XmNmarginWidth, 0);				n++;
	XtSetArg(args[n], XmNdialogStyle,
		XmDIALOG_PRIMARY_APPLICATION_MODAL);			n++;
	XtSetArg(args[n], XmNnoResize, True);				n++;
	XtSetArg(args[n], XmNtraversalOn, True);			n++;
	li->dialog = XmCreateBulletinBoardDialog(parent,
		"list_dialog", args, n);

				/* Get dialog parameters		*/
	n = 0;
	XtSetArg(args[n], XmNshadowThickness, &dlg_shadow);		n++;
	XtGetValues(li->dialog, args, n);

				/* Dialog form				*/
	n = 0;
	XtSetArg(args[n], XmNx, dlg_shadow);				n++;
	XtSetArg(args[n], XmNy, dlg_shadow);				n++;
	XtSetArg(args[n], XmNhorizontalSpacing, 4);			n++;
	li->form = XmCreateForm(li->dialog, "form", args, n);
	XtManageChild(li->form);

				/* Dialog message gadget		*/
	n = 0;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE);		n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNresizable, True);				n++;
	li->message_lbl = XmCreateLabelGadget(li->form,
		"message_lbl", args, n);
	XtManageChild(li->message_lbl);
		
				/* List box header gadget		*/
	/* We'll first create the list box header but wait until we create
	 * the list box to try to align the header with the contents of the
	 * list box.
	 */
	n = 0;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE);		n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNtopOffset, 10);				n++;
	XtSetArg(args[n], XmNtopWidget, li->message_lbl);		n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET);		n++;
	XtSetArg(args[n], XmNresizable, True);				n++;
	XtSetArg(args[n], XmNalignment, XmALIGNMENT_BEGINNING);		n++;
	XtSetArg(args[n], XmNmarginWidth, 0);				n++;
	XtSetArg(args[n], XmNshadowThickness, 0);			n++;
	li->header_lbl = XmCreateLabelGadget(li->form, "header_lbl", args, n);
	XtManageChild(li->header_lbl);

				/* List box				*/
	n = 0;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE);		n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNtopWidget, li->header_lbl);		n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET);		n++;
	XtSetArg(args[n], XmNresizable, True);				n++;
	XtSetArg(args[n], XmNlistSizePolicy, XmCONSTANT);		n++;
	XtSetArg(args[n], XmNvisibleItemCount, 10);			n++;
	li->list = XmCreateList(li->form, "list", args, n);
	XtManageChild(li->list);

				/* Align list box header with list box	*/
	n = 0;
	XtSetArg(args[n], XmNlistMarginWidth, &margin_width);		n++;
	XtSetArg(args[n], XmNshadowThickness, &shadow_width);		n++;
	XtGetValues(li->list, args, n);
	n = 0;
	XtSetArg(args[n], XmNmarginLeft, margin_width + shadow_width + 3
		+ li->list->core.border_width
		- li->header_lbl->core.border_width);			n++;
	XtSetValues(li->header_lbl, args, n);

				/* Dialog value gadget			*/
	n = 0;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE);		n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNtopWidget, li->list);			n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET);		n++;
	XtSetArg(args[n], XmNresizable, True);				n++;
	li->value_lbl = XmCreateLabelGadget(li->form, "value_lbl", args, n);
	XtManageChild(li->value_lbl);

				/* Button separator gadget		*/
	n = 0;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE);		n++;
	XtSetArg(args[n], XmNleftOffset, -2);				n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNrightOffset, -2);				n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNtopOffset, 10);				n++;
	XtSetArg(args[n], XmNtopWidget, li->value_lbl);			n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET);		n++;
	XtSetArg(args[n], XmNresizable, True);				n++;
	dlg_sep = XmCreateSeparatorGadget(li->form, "separator", args, n);
	XtManageChild(dlg_sep);

				/* OK button gadget			*/
	n = 0;
	XtSetArg(args[n], XmNmarginWidth, 4);				n++;
	XtSetArg(args[n], XmNmarginHeight, 4);				n++;
	li->ok_btn = XmCreatePushButtonGadget(li->dialog,
		"  OK  ", args, n);
	XtManageChild(li->ok_btn);

				/* Cancel button gadget			*/
	n = 0;
	XtSetArg(args[n], XmNmarginWidth, 4);				n++;
	XtSetArg(args[n], XmNmarginHeight, 4);				n++;
	li->cancel_btn = XmCreatePushButtonGadget(li->dialog,
		"Cancel", args, n);
	XtManageChild(li->cancel_btn);

				/* Set default button			*/
	n = 0;
	XtSetArg(args[n], XmNdefaultButton, li->ok_btn);		n++;
	XtSetValues(li->dialog, args, n);

				/* Force Form widget to account for children */
	XtRealizeWidget(li->dialog);


	return (li);
} /* function CreateListDialog */





#ifdef	_NO_PROTO
void SetListDialog(li, shell, title_str, message_str, header_str, value_str)
LiDialog	li;
Widget		shell;
XmString	title_str,
		message_str, 
		header_str,
		value_str;
#else
void SetListDialog(LiDialog li, Widget shell, XmString title_str,
	XmString message_str, XmString header_str, XmString value_str)
#endif	_NO_PROTO
{
Dimension	dlg_shadow;
Arg		args[5];
int		n;


				/* Get dialog parameters		*/
	n = 0;
	XtSetArg(args[n], XmNshadowThickness, &dlg_shadow);		n++;
	XtGetValues(li->dialog, args, n);

				/* Set dialog title 			*/
	if (title_str != NULL) {
	    n = 0;
	    XtSetArg(args[n], XmNdialogTitle, title_str);		n++;
	    XtSetValues(li->dialog, args, n);
	} /* if */

				/* Set message label gadget		*/
	if (message_str != NULL) {
	    n = 0;
	    XtSetArg(args[n], XmNlabelString, message_str);		n++;
	    XtSetValues(li->message_lbl, args, n);
	} /* if */

				/* Set list box header gadget		*/
	if (header_str != NULL) {
	    n = 0;
	    XtSetArg(args[n], XmNlabelString, header_str);		n++;
	    XtSetValues(li->header_lbl, args, n);
	} /* if */

				/* Set list box header gadget		*/
	if (value_str != NULL) {
	    n = 0;
	    XtSetArg(args[n], XmNlabelString, value_str);		n++;
	    XtSetValues(li->value_lbl, args, n);
	} /* if */

				/* Position OK pushbutton		*/
	n = 0;
	XtSetArg(args[n], XmNx, li->form->core.width / 10);		n++;
	XtSetArg(args[n], XmNy, li->form->core.y
		+ li->form->core.height
		+ 2 * li->form->core.border_width + 10);		n++;
	XtSetValues(li->ok_btn, args, n);

				/* Position Cancel pushbutton		*/
	n = 0;
	XtSetArg(args[n], XmNx, (int)(li->form->core.width * 0.90)
		- li->cancel_btn->core.width
		- 2 * li->cancel_btn->core.border_width);		n++;
	XtSetArg(args[n], XmNy, li->form->core.y
		+ li->form->core.height
		+ 2 * li->form->core.border_width + 10);		n++;
	XtSetValues(li->cancel_btn, args, n);

				/* Resize dialog			*/
	n = 0;
	XtSetArg(args[n], XmNwidth, li->form->core.width
		+ 2 * li->form->core.border_width
		+ 2 * dlg_shadow);					n++;
	XtSetArg(args[n], XmNheight, li->cancel_btn->core.y
		+ li->cancel_btn->core.height
		+ 2 * li->cancel_btn->core.border_width
		+ 2 * dlg_shadow + 10);					n++;
	XtSetValues(li->dialog, args, n);


	if (shell != NULL) {	/* Set dialog shell position		*/
	    n = 0;
	    XtSetArg(args[n], XmNx, shell->core.x + (shell->core.width
		       - XtParent(li->dialog)->core.width) / 2);	n++;
	    XtSetArg(args[n], XmNy, shell->core.y + (shell->core.height
		       - XtParent(li->dialog)->core.height) / 2);	n++;
	    XtSetValues(XtParent(li->dialog), args, n);
	} /* if */
} /* function SetListDialog */

/***************************** End of xpi_utils.c ****************************/

