/******************************************************************************
 * Module xpi_tooldefs.c - Tool declaration module for xperfisis
 *
 * Written:	05/20/91 by John H. Lee
 * Last Change:	06/08/91 by John H. Lee
 * Version:	0.2
 ******************************************************************************
 * Description:
 *
 *	All tools are added into xperfisis through this single point.  The
 * application-wide global ToolsList contains the tool class record pointers
 * which enable xperfisis to invoke to tools.  No other file needs to be
 * modified when adding a tool.
 ******************************************************************************
 * Revisions:
 *   0.1  05/20/91 JHL  Initial Creation
 *   0.2  06/08/91 JHL  Added roundTripToolClass
 *   0.3  06/17/91 JHL  Changed demo tool to throughput
 *   0.3  06/19/91 JHL  Added transactToolClass
 *****************************************************************************/

#include "xpi_tools.h"
				/* Includes for tools			*/
#include "xpi_TLthroughput.h"	/* Broadcast Throughput tool		*/
#include "xpi_TLroundtrip.h"	/* Broadcast+Reply round trip tool	*/
#include "xpi_TLtransact.h"	/* Transaction model test tool		*/





/*** List of tools
 *	Tools are linked into xperfisis only through their class records,
 * the addresses of which appear in the program-wide global ToolsList.  The
 * order in which the tool's class records appear in this list determines
 * the order the tools appear on the menu.
 *	The list is terminated with a NULL entry.
 */
static ToolClassRec	*tools_entries[] = {
	&throughputToolClassRec,/* Broadcast throughput tool		*/
	&roundTripToolClassRec,	/* Broadcast+Reply round trip tool	*/
	&transactToolClassRec,	/* Transaction model test tool		*/
	NULL			/*** MUST END WITH NULL ***/
};

ToolClass	*ToolsList = &tools_entries[0];

/*************************** End of xpi_tooldefs.c ***************************/

