/******************************************************************************
 * Include xpi_graph.h - Public definitions for graph display routines
 *
 * Written:	 05/14/91 by John H. Lee
 * Last Changed: 05/14/91 by John H. Lee
 * Version:	 0.1
 ******************************************************************************
 * Revisions:
 *   0.1  05/14/91 JHL  Initial Creation
 *****************************************************************************/

#ifndef	_XPI_GRAPH_H
#define	_XPI_GRAPH_H

#include <Xm/Xm.h>

#include "xperfisis.h"



/*** Type definitions ***/

typedef struct {
	long	x,
		cnt;
} GDatum;


typedef struct {
				/* Public fields			*/
	long	view_min_x,		/* Left edge of visible area	*/
		view_min_y,		/* Bottom edge of visible area	*/
		view_max_x,		/* Right edge of visible area	*/
		view_max_y;		/* Top edge of visible area	*/
	long	interval_x,		/* X-axis tic interval		*/
		interval_base_x;	/* X-axis tic start value	*/
	long	interval_y,		/* Y-axis tic interval		*/
		interval_base_y;	/* Y-axis tic start value	*/
	long	radix_x,		/* X value divisor		*/
		radix_y;		/* Y value divisor		*/
	long	scale_x,		/* X value per pixel		*/
		scale_y;		/* Y value per pixel		*/
	Boolean	auto_scale;		/* Scale display automagically	*/
	XmString label_x,		/* X-axis label			*/
		 label_y;		/* Y-axis label			*/
	char	*format_x,		/* X-axis tic label fprint format*/
		*format_y;		/* Y-axis tic label fprint format*/
				/* Private or read-only fields		*/
	Widget	draw_area,		/* XmDrawArea widget		*/
		x_lbl,			/* X-axis label widget		*/
		y_lbl;			/* Y-axis label widget		*/
	Dimension tic_spacing_x,	/* X-axis tic mark spacing	*/
		  tic_spacing_y;	/* Y-axis tic mark spacing	*/
	Dimension tic_margin_width,	/* Width margin for tic marks	*/
		  tic_margin_height;	/* Height margin for tic marks	*/
	GDatum	*data;			/* Data points			*/
	unsigned num_data,		/* Number of gata points	*/
		 data_sz;		/* Size of data array		*/
	GDatum	*graph_data;		/* Graph points			*/
	unsigned num_graph,		/* Number of graph points	*/
		 graph_sz;		/* Size of graph array		*/
	Pixmap	draw_pixmap;		/* Graph image pixmap		*/
	GC	draw_gc,		/* Drawing Graphics Context	*/
		erase_gc;		/* Erasing Graphics Context	*/
	XmFontList fontlist;		/* Font list for text		*/
	long	min_x,			/* X value minimum		*/
		max_x;			/* X value maximum		*/
	long	min_y,			/* Y value minimum		*/
		max_y;			/* Y value maximum		*/
	Bool	redraw;			/* TRUE=needs to be redrawn	*/
	Bool	not_realized;		/* TRUE=not yet realized	*/
} Graph;



/*** Public Functions ***/

#if	defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif


extern Graph	*GraphCreate __ARGS((Widget w, Graph *g));
extern void	GraphDestroy __ARGS((Graph *g));
extern void	GraphSet __ARGS((Graph *g));
extern void	GraphSetData __ARGS((Graph *g, GDatum *data,
			unsigned num_data));
extern void	GraphAddPoint __ARGS((Graph *g, long val));
extern void	GraphDeleteData __ARGS((Graph *g));


#if	defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif	_XPI_GRAPH_H
/* DON'T ADD ANYTHING AFTER THIS #endif */

/**************************** End of xpi_graph.h *****************************/
