/******************************************************************************
 * Program perfserverDM.c - ISIS performance test server, Data Manager
 *
 * Written:	 06/19/91 by John H. Lee
 * Last Changed: 06/19/91 by John H. Lee
 * Version:	 0.1
 ******************************************************************************
 * Description:
 *
 *	This ISIS program provides the Data Managers for testing transactional
 * models by the perfserver program.  Currently, the four basic Data Manager
 * commands (read, write, abort, commit) don't do anything useful.
 ******************************************************************************
 * Execution:
 *
 *	ISIS must be up and running on the local machine.  There are no
 * command-line arguments to this program.
 ******************************************************************************
 * Exports:
 *	None
 *
 * Imports:
 *	None
 ******************************************************************************
 * Compilation Flags:
 *	None
 ******************************************************************************
 * Modules:
 *	perfserverDM.c		Main function
 *
 * Compilation and Linking:
 *
 *	This program was developed for ISIS v3.0.
 *	The ISIS include files must be in the local include search path for the 
 * compiler, and this program must be linked with the ISIS libraries.
 ******************************************************************************
 * Revisions:
 *   0.1    06/19/91 JHL  Initial Creation
 *****************************************************************************/

#include <stdio.h>
#include "isis.h"
#include "perfisis.h"
#include "perfserverDM.h"





main()
{
static int	service_maintask(),
		do_read(),
		do_write(),
		do_abort(),
		do_commit();


				/* Do ISIS initialization		*/
	isis_init(PERFPORTNO);

	isis_task(service_maintask, "service_maintask");

				/* Declare command entry points		*/
	isis_entry(DM_READ,	do_read,	"do_read");
	isis_entry(DM_WRITE,	do_write,	"do_write");
	isis_entry(DM_ABORT,	do_abort,	"do_abort");
	isis_entry(DM_COMMIT,	do_commit,	"do_commit");

				/* Execute primary execution task	*/
	isis_mainloop(service_maintask);

	/*NOTREACHED*/
} /* main */




static int service_maintask()
{
address		*gaddr;


				/* Join  service group			*/
	while ((gaddr = pg_join(PERFSERVDMNAME,
		0)) == NULL) {
	    if (isis_errno == IE_MUSTJOIN) {
		(void)fputs("perfserverDM: log out of date, will sleep and try\
to join again after 30 secs\n", stderr);
		sleep(30);
	    } else {
		isis_perror("perfserverDM: couldn't join group");
		exit(1);
		/*NOTREACHED*/
	    } /* else */
	} /* while */

				/* OK, we're open for business!		*/
	isis_start_done();
} /* function service_maintask */





/***** DM Read Data Entry Function
 *
 *	This entry point is used to read data from the data manager.  Right
 * now, it's just a dummy routine that returns a packet of junk of the
 * requested size.  The entry arguments aren't even realistic.
 *
 * ENTRY:
 *	int read_size			Size of data packet to return
 *	int transaction_id		Transaction ID (not used)
 * REPLY:
 *	char *data			Array of characters of size read_size
 */
static int do_read(msg_p)
message	*msg_p;
{
char	*data;
int	read_size;

extern	void free();


	msg_get(msg_p, "%d", &read_size);
	data = malloc(read_size);

	reply(msg_p, "%*C", data, read_size, free);
} /* function do_read */





/***** DM Write Data Entry Function
 *
 *	This entry point is used to write data into the data manager.  Right
 * now, it's just a dummy routine that does nothing--it doesn't even bother
 * getting the data from the message.  The entry arguments aren't realistic,
 * either.
 *
 * ENTRY:
 *	char *data			Array of chars to be written (not used)
 *	int transaction_id		Transaction ID (not used)
 * REPLY:
 *	(Empty Reply)
 */
static int do_write(msg_p)
message	*msg_p;
{
	reply(msg_p, "");
} /* function do_write */





/***** DM Write Data Entry Function
 *
 *	This entry point is used to abort a transaction.  Right now, it's
 * just a dummy routine that does nothing--it doesn't even bother getting
 * the data from the message.  The entry arguments aren't realistic, either.
 *
 * ENTRY:
 *	int transaction_id		ID of transaction to abort (not used)
 * REPLY:
 *	(Empty Reply)
 */
static int do_abort(msg_p)
message	*msg_p;
{
	reply(msg_p, "");
} /* function do_abort */





/***** DM Write Data Entry Function
 *
 *	This entry point is used to commit a transaction.  Right now, it's
 * just a dummy routine that does nothing--it doesn't even bother getting
 * the data from the message.  The entry arguments aren't realistic, either.
 *
 * ENTRY:
 *	int transaction_id		ID of transaction to abort (not used)
 * REPLY:
 *	(Empty Reply)
 */
static int do_commit(msg_p)
message	*msg_p;
{
	reply(msg_p, "");
} /* function do_commit */

/*************************** End of perfserverDM.c ***************************/
