/******************************************************************************
 * Program perfserver.c - ISIS performance test server
 *
 * Written:	 05/17/91 by John H. Lee
 * Last Changed: 06/19/91 by John H. Lee
 * Version:	 0.3
 ******************************************************************************
 * Description:
 *
 *	This program serves as a performance server operating under ISIS,
 * primarily for the xperfisis program.  Various entry points provide the
 * routines to measure various performance parameters.
 ******************************************************************************
 * Execution:
 *
 *	This program requires that ISIS be setup and running on the local
 * machine.  There are no command-line arguments to this program.
 ******************************************************************************
 * Exports:
 *	address GAddrP		perfserver group address
 * Imports:
 *	int do_transaction_abcast()	ABcast transaction entry
 *	int do_transaction_token()	Token-passing transaction entry
 *	int do_transaction_quorum()	Quorum transaction entry
 ******************************************************************************
 * Compilation Flags:
 *	None
 ******************************************************************************
 * Modules:
 *	perfserver		Main routine
 *	ps_transact		Transaction testing routines
 *
 * Compilation and Linking:
 *	This program was developed for ISIS v3.0.
 *	The ISIS include files must be in the local search path for the
 * compiler, and this program must be linked with the ISIS libraries.
 ******************************************************************************
 * Revisions:
 *   0.1    05/17/91 JHL  Initial Creation
 *   0.2    06/10/91 JHL  Added ENTRY_JUSTREPLY entry point
 *   0.3    06/19/91 JHL  Added transaction entry points
 *****************************************************************************/

#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include "isis.h"
#include "perfisis.h"
#include "ps_transact.h"





/*** Public globals */

address	*GAddrP;		/* Our group address			*/





main()
{
static int	service_maintask(),
		do_nothing(),
		do_justreply();


				/* Do ISIS initialization		*/
	isis_init(PERFPORTNO);

	isis_task(service_maintask, "service_maintask");

				/* Declare command entry points		*/
	isis_entry(ENTRY_NOTHING,	do_nothing,
		"do_nothing");
	isis_entry(ENTRY_JUSTREPLY,	do_justreply,
		"do_justreply");
	isis_entry(ENTRY_TRANSABCAST,	do_transaction_abcast,
		"do_transaction_abcast");
	isis_entry(ENTRY_TRANSTOKEN,	do_transaction_token,
		"do_transaction_token");
	isis_entry(ENTRY_TRANSQUORUM,	do_transaction_quorum,
		"do_transaction_quorum");

				/* Execute primary execution task	*/
	isis_mainloop(service_maintask);

	/*NOTREACHED*/
} /* main */




static int service_maintask()
{
				/* Join  service group			*/
	while ((GAddrP = pg_join(PERFSERVNAME,
		0)) == NULL) {
	    if (isis_errno == IE_MUSTJOIN) {
		(void)fputs("perfserver: log out of date, will sleep and try\
to join again after 30 secs\n", stderr);
		sleep(30);
	    } else {
		isis_perror("perfserver: couldn't join group");
		exit(1);
		/*NOTREACHED*/
	    } /* else */
	} /* while */

				/* OK, we're ready to rock and roll	*/
	isis_start_done();
} /* function service_maintask */





static int do_nothing(msg_p)
message	*msg_p;
{
	return (0);
} /* function do_nothing */





static int do_justreply(msg_p)
message	*msg_p;
{
	fflush(stdout);
	reply(msg_p, "");
} /* function do_justreply */

/***************************** End of perfserver.c ***************************/
