/*

Copyright 1990 by M. Beck and K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

*/

#define WORK_ENTRY	1
#define REPLAY_ENTRY	2

typedef message **Index;

typedef struct {
	RELNAME	name;
	int	stable;
	int	repl_factor;
	int	num_attributes;
	int 	num_tuples;
	int	version;
	char	exist;
	AttDes	*attributes;
	Index 	*index;	
} RelDes;

#define INDEX(r,i)	((r)->index[(i) - TBL_SORTALL])
#define INDEXALL(r)	INDEX(r,TBL_SORTALL)

/* sysrel info */
#define TBL_SYSREPL	1
#define TBL_SYSNATTR	1
extern AttDes t_sysattr[];

#define POST(o) ((o) == postorder || (o) == leaf)

extern int rel_cmp(), T_cmp(), T_dcmp(), T_pcmp();
extern RelDes *rel_lookup();
extern RelDes *sys_rel, *root_rel, *sort_rel;
extern int sort_column_num;

extern message *attrs_to_mp();
extern int elected;
extern address *gaddr_p;

void table_process();
